/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.registries;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import novamachina.exnihilosequentia.world.item.crafting.PrecipitateRecipe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrecipitateRegistry {
    private static Logger log = LoggerFactory.getLogger(PrecipitateRegistry.class);
    @Nonnull
    private final List<PrecipitateRecipe> recipeList = new ArrayList<PrecipitateRecipe>();
    @Nonnull
    private final Item empty = ItemStack.f_41583_.m_41720_();
    private final LoadingCache<PrecipitateCacheKey, Item> cache;

    public PrecipitateRegistry() {
        CacheLoader<PrecipitateCacheKey, Item> loader = new CacheLoader<PrecipitateCacheKey, Item>(){

            public Item load(PrecipitateCacheKey key) {
                return PrecipitateRegistry.this.recipeList.stream().filter(fluidItemRecipe -> fluidItemRecipe.validInputs(key.fluid(), key.input())).findFirst().map(PrecipitateRecipe::getOutput).map(ItemStack::m_41720_).orElse(PrecipitateRegistry.this.empty);
            }
        };
        this.cache = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)loader);
    }

    public boolean isValidRecipe(@Nonnull Fluid fluid, @Nonnull Item input) {
        return this.getResult(fluid, input) != this.empty;
    }

    @Nonnull
    public ItemLike getResult(@Nonnull Fluid fluid, @Nonnull Item input) {
        try {
            return (ItemLike)this.cache.get((Object)new PrecipitateCacheKey(fluid, (ItemLike)input));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public List<PrecipitateRecipe> getRecipeList() {
        return this.recipeList;
    }

    public void setRecipes(@Nonnull List<PrecipitateRecipe> recipes) {
        log.debug("Fluid Item Transform Registry recipes: " + recipes.size());
        this.recipeList.addAll(recipes);
        this.cache.invalidateAll();
    }

    public void clearRecipes() {
        this.recipeList.clear();
        this.cache.invalidateAll();
    }

    private record PrecipitateCacheKey(Fluid fluid, ItemLike input) {
    }
}

