/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.registries;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import novamachina.exnihilosequentia.common.Config;
import novamachina.exnihilosequentia.common.compat.jei.sifting.JEISieveRecipe;
import novamachina.exnihilosequentia.world.item.MeshItem;
import novamachina.exnihilosequentia.world.item.MeshType;
import novamachina.exnihilosequentia.world.item.Ore;
import novamachina.exnihilosequentia.world.item.OreItem;
import novamachina.exnihilosequentia.world.item.crafting.SiftingRecipe;
import novamachina.novacore.util.IngredientUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiftingRegistry {
    private static Logger log = LoggerFactory.getLogger(SiftingRegistry.class);
    private final boolean flattenRecipes = Config.flattenSieveRecipes();
    @Nonnull
    private final List<SiftingRecipe> recipeList = new ArrayList<SiftingRecipe>();
    private final LoadingCache<SiftingCacheKey, List<SiftingRecipe>> recipeCache;
    private final LoadingCache<SiftingCacheKey, Boolean> siftableCache;

    public SiftingRegistry() {
        CacheLoader<SiftingCacheKey, List<SiftingRecipe>> recipeCacheLoader = new CacheLoader<SiftingCacheKey, List<SiftingRecipe>>(){

            public List<SiftingRecipe> load(SiftingCacheKey key) {
                return SiftingRegistry.this.recipeList.parallelStream().filter(recipe -> recipe.isWaterlogged() == key.isWaterlogged()).filter(recipe -> IngredientUtils.areIngredientsEqual((Ingredient)recipe.getInput(), (Ingredient)key.input())).map(recipe -> recipe.filterByMesh(key.meshType(), SiftingRegistry.this.flattenRecipes)).filter(recipe -> {
                    if (recipe.getDrop().m_41720_() instanceof OreItem) {
                        Ore ore = ((OreItem)recipe.getDrop().m_41720_()).getOre();
                        return ore.isEnabled();
                    }
                    return true;
                }).filter(recipe -> !recipe.getRolls().isEmpty()).collect(Collectors.toList());
            }
        };
        this.recipeCache = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)recipeCacheLoader);
        CacheLoader<SiftingCacheKey, Boolean> siftableCacheLoader = new CacheLoader<SiftingCacheKey, Boolean>(){

            public Boolean load(SiftingCacheKey key) {
                return SiftingRegistry.this.recipeList.stream().filter(recipe -> recipe.isWaterlogged() == key.isWaterlogged()).filter(recipe -> IngredientUtils.isIngredientIn((Ingredient)key.input(), (Ingredient)recipe.getInput())).anyMatch(recipe -> recipe.getRolls().stream().anyMatch(roll -> {
                    int level = roll.getMesh().getLevel();
                    if (SiftingRegistry.this.flattenRecipes) {
                        return level <= key.meshType().getLevel();
                    }
                    return level == key.meshType().getLevel();
                }));
            }
        };
        this.siftableCache = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)siftableCacheLoader);
    }

    @Nonnull
    private List<SiftingRecipe> getDrops(@Nonnull Ingredient input, @Nonnull MeshType meshType, boolean isWaterlogged) {
        try {
            return (List)this.recipeCache.get((Object)new SiftingCacheKey(input, meshType, isWaterlogged));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public List<SiftingRecipe> getDrops(@Nonnull ItemLike input, @Nonnull MeshType meshType, boolean isWaterlogged) {
        try {
            return (List)this.recipeCache.get((Object)new SiftingCacheKey(Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), meshType, isWaterlogged));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isBlockSiftable(@Nonnull Block block, @Nonnull MeshType mesh, boolean isWaterlogged) {
        try {
            return (Boolean)this.siftableCache.get((Object)new SiftingCacheKey(Ingredient.m_43929_((ItemLike[])new ItemLike[]{block}), mesh, isWaterlogged));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    private List<JEISieveRecipe> getRecipeList(boolean isWaterLogged) {
        HashSet ingredients = new HashSet();
        this.recipeList.forEach(recipe -> {
            Ingredient recipeIngredient = recipe.getInput();
            if (ingredients.stream().noneMatch(ingredient -> IngredientUtils.areIngredientsEqual((Ingredient)ingredient, (Ingredient)recipeIngredient))) {
                ingredients.add(recipeIngredient);
            }
        });
        return Arrays.stream(MeshType.values()).filter(enumMesh -> enumMesh != MeshType.NONE).flatMap(enumMesh -> {
            ItemStack mesh = new ItemStack((ItemLike)MeshItem.getMesh(enumMesh));
            return ingredients.stream().flatMap(ingredient -> {
                List<SiftingRecipe> drops = this.getDrops((Ingredient)ingredient, (MeshType)((Object)enumMesh), isWaterLogged);
                if (drops.isEmpty()) {
                    return null;
                }
                ArrayList<List> input = new ArrayList<List>(Arrays.asList(Collections.singletonList(mesh), Arrays.asList(ingredient.m_43908_())));
                return Lists.partition(drops, (int)21).stream().map(results -> new JEISieveRecipe((List<List<ItemStack>>)input, (List<SiftingRecipe>)results));
            });
        }).collect(Collectors.toList());
    }

    @Nonnull
    public List<JEISieveRecipe> getDryRecipeList() {
        return this.getRecipeList(false);
    }

    @Nonnull
    public List<JEISieveRecipe> getWetRecipeList() {
        return this.getRecipeList(true);
    }

    public void setRecipes(@Nonnull List<SiftingRecipe> recipes) {
        log.debug("Sieve Registry recipes: " + recipes.size());
        this.recipeList.addAll(recipes);
        this.recipeCache.invalidateAll();
        this.siftableCache.invalidateAll();
    }

    public void clearRecipes() {
        this.recipeList.clear();
        this.recipeCache.invalidateAll();
        this.siftableCache.invalidateAll();
    }

    private record SiftingCacheKey(Ingredient input, MeshType meshType, boolean isWaterlogged) {
    }
}

