/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.data.recipes;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import novamachina.exnihilosequentia.world.item.crafting.EXNRecipeSerializers;
import novamachina.exnihilosequentia.world.item.crafting.ItemStackWithChance;
import novamachina.novacore.data.recipes.RecipeBuilder;

public class CrushingRecipeBuilder
extends RecipeBuilder<CrushingRecipeBuilder> {
    private final Ingredient input;
    private List<ItemStackWithChance> drops;

    protected CrushingRecipeBuilder(Ingredient input, ItemStackWithChance ... drops) {
        super(EXNRecipeSerializers.CRUSHING_RECIPE_SERIALIZER.recipeSerializer());
        this.input = input;
        this.drops = Lists.newArrayList((Object[])drops);
    }

    @Nonnull
    public static CrushingRecipeBuilder crushing(ItemLike input, ItemStackWithChance ... drops) {
        return CrushingRecipeBuilder.crushing(Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), drops);
    }

    private static CrushingRecipeBuilder crushing(Ingredient input, ItemStackWithChance ... drops) {
        return new CrushingRecipeBuilder(input, drops);
    }

    protected void validate(ResourceLocation id) {
        Preconditions.checkNotNull((Object)this.input, (Object)"Input cannot be null.");
        Preconditions.checkArgument((!this.drops.isEmpty() ? 1 : 0) != 0, (Object)"Recipe needs at least one drop.");
    }

    public CrushingRecipeBuilder addDrop(ItemStack stack) {
        return this.addDrop(stack, 1.0f);
    }

    public CrushingRecipeBuilder addDrop(ItemStack stack, float chance) {
        return this.addDrop(stack, 1, chance);
    }

    public CrushingRecipeBuilder addDrop(ItemStack stack, int count, float chance) {
        this.drops.add(ItemStackWithChance.of(stack, count, chance));
        return this;
    }

    protected CrushingRecipeResult getResult(ResourceLocation id) {
        return new CrushingRecipeResult(id);
    }

    public class CrushingRecipeResult
    extends RecipeBuilder.RecipeResult {
        public CrushingRecipeResult(ResourceLocation id) {
            super((RecipeBuilder)CrushingRecipeBuilder.this, id);
        }

        public void m_7917_(JsonObject json) {
            json.add("input", CrushingRecipeBuilder.this.input.m_43942_());
            JsonArray results = new JsonArray();
            CrushingRecipeBuilder.this.drops.forEach(drop -> results.add(drop.serialize()));
            json.add("results", (JsonElement)results);
        }
    }
}

