/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.init;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import novamachina.exnihilosequentia.common.Config;
import novamachina.exnihilosequentia.common.compat.top.CompatTOP;
import novamachina.exnihilosequentia.common.network.PacketHandler;
import novamachina.exnihilosequentia.common.registries.ExNihiloRegistries;
import novamachina.exnihilosequentia.world.item.EXNItems;
import novamachina.exnihilosequentia.world.item.crafting.CompostRecipe;
import novamachina.exnihilosequentia.world.item.crafting.CrushingRecipe;
import novamachina.exnihilosequentia.world.item.crafting.EXNRecipeTypes;
import novamachina.exnihilosequentia.world.item.crafting.HarvestRecipe;
import novamachina.exnihilosequentia.world.item.crafting.HeatRecipe;
import novamachina.exnihilosequentia.world.item.crafting.MeltingRecipe;
import novamachina.exnihilosequentia.world.item.crafting.PrecipitateRecipe;
import novamachina.exnihilosequentia.world.item.crafting.SiftingRecipe;
import novamachina.exnihilosequentia.world.item.crafting.SolidifyingRecipe;
import novamachina.exnihilosequentia.world.item.crafting.TransitionRecipe;
import novamachina.exnihilosequentia.world.level.block.entity.mode.BarrelModeRegistry;
import novamachina.novacore.world.item.ItemDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod.EventBusSubscriber(modid="exnihilosequentia", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ExNihiloInitialization {
    private static Logger log = LoggerFactory.getLogger(ExNihiloInitialization.class);

    private ExNihiloInitialization() {
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void clearRegistries(@Nonnull ClientPlayerNetworkEvent.LoggingOut event) {
        log.debug("Fired LoggedOutEvent");
        ExNihiloRegistries.clearRegistries();
    }

    public static void init(@Nonnull IEventBus modEventBus) {
        log.debug("Initializing modded items");
    }

    @SubscribeEvent
    public static void loadClientRecipes(@Nonnull RecipesUpdatedEvent event) {
        ExNihiloRegistries.clearRegistries();
        ExNihiloInitialization.loadRecipes(event.getRecipeManager());
    }

    @SubscribeEvent
    public static void onPlayerLogin(@Nonnull PlayerEvent.PlayerLoggedInEvent event) {
        log.debug("Fired PlayerLoggedInEvent");
    }

    @SubscribeEvent
    public static void onServerStart(@Nonnull ServerStartingEvent event) {
        log.debug("Fired FMLServerStartingEvent");
        ExNihiloInitialization.registerOreCompat();
        ExNihiloInitialization.overrideOres();
        if (event.getServer().m_6982_()) {
            ExNihiloInitialization.loadRecipes(event.getServer().m_129894_());
        }
    }

    @SubscribeEvent
    public static void registerTOP(@Nonnull InterModEnqueueEvent event) {
        log.debug("The One Probe detected: " + ModList.get().isLoaded("theoneprobe"));
        if (ModList.get().isLoaded("theoneprobe")) {
            CompatTOP.register();
        }
    }

    @SubscribeEvent
    public static void setupNonTagBasedRegistries(@Nonnull FMLCommonSetupEvent event) {
        log.debug("FIRED FMLCOMMONSETUPEVENT");
        BarrelModeRegistry.initialize();
        PacketHandler.registerMessages();
        ExNihiloInitialization.registerVanillaCompost();
        ExNihiloInitialization.registerDispenserFluids();
    }

    private static void registerDispenserFluids() {
        DefaultDispenseItemBehavior idispenseitembehavior = new DefaultDispenseItemBehavior(){
            @Nonnull
            private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

            @Nonnull
            public ItemStack m_7498_(@Nonnull BlockSource pSource, @Nonnull ItemStack pStack) {
                BucketItem bucketitem = (BucketItem)pStack.m_41720_();
                BlockPos blockpos = pSource.m_7961_().m_121945_((Direction)pSource.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
                ServerLevel world = pSource.m_7727_();
                if (bucketitem.m_142073_(null, (Level)world, blockpos, null)) {
                    bucketitem.m_142131_(null, (Level)world, pStack, blockpos);
                    return new ItemStack((ItemLike)Items.f_42446_);
                }
                return this.defaultDispenseItemBehavior.m_6115_(pSource, pStack);
            }
        };
        DispenserBlock.m_52672_(EXNItems.SEA_WATER_BUCKET, (DispenseItemBehavior)idispenseitembehavior);
        DispenserBlock.m_52672_(EXNItems.WITCH_WATER_BUCKET, (DispenseItemBehavior)idispenseitembehavior);
    }

    private static void registerVanillaCompost() {
        ExNihiloInitialization.createMCCompost(EXNItems.GRASS_SEED);
        ExNihiloInitialization.createMCCompost(EXNItems.MYCELIUM_SPORE);
        ExNihiloInitialization.createMCCompost(EXNItems.SILKWORM);
        ExNihiloInitialization.createMCCompost(EXNItems.COOKED_SILKWORM);
    }

    private static void createMCCompost(ItemDefinition<? extends Item> item) {
        ComposterBlock.f_51914_.put(item, 0.3f);
    }

    private static <R extends Recipe<?>> List<R> filterRecipes(@Nonnull Collection<Recipe<?>> recipes, @Nonnull Class<R> recipeClass, @Nonnull RecipeType<R> recipeType) {
        log.debug("Filter Recipes, Class: " + recipeClass + ", Recipe Type: " + recipeType);
        return recipes.stream().filter(iRecipe -> iRecipe.m_6671_() == recipeType).map(recipeClass::cast).collect(Collectors.toList());
    }

    private static void loadRecipes(@Nonnull RecipeManager manager) {
        log.debug("Loading Recipes");
        Collection recipes = manager.m_44051_();
        if (recipes.isEmpty()) {
            return;
        }
        ExNihiloRegistries.HAMMER_REGISTRY.setRecipes(ExNihiloInitialization.filterRecipes(recipes, CrushingRecipe.class, EXNRecipeTypes.CRUSHING));
        ExNihiloRegistries.CROOK_REGISTRY.setRecipes(ExNihiloInitialization.filterRecipes(recipes, HarvestRecipe.class, EXNRecipeTypes.HARVEST));
        ExNihiloRegistries.COMPOST_REGISTRY.setRecipes(ExNihiloInitialization.filterRecipes(recipes, CompostRecipe.class, EXNRecipeTypes.COMPOST));
        ExNihiloRegistries.FLUID_BLOCK_REGISTRY.setRecipes(ExNihiloInitialization.filterRecipes(recipes, PrecipitateRecipe.class, EXNRecipeTypes.PRECIPITATE));
        ExNihiloRegistries.FLUID_ON_TOP_REGISTRY.setRecipes(ExNihiloInitialization.filterRecipes(recipes, SolidifyingRecipe.class, EXNRecipeTypes.SOLIDIFYING));
        ExNihiloRegistries.FLUID_TRANSFORM_REGISTRY.setRecipes(ExNihiloInitialization.filterRecipes(recipes, TransitionRecipe.class, EXNRecipeTypes.TRANSITION));
        ExNihiloRegistries.CRUCIBLE_REGISTRY.setRecipes(ExNihiloInitialization.filterRecipes(recipes, MeltingRecipe.class, EXNRecipeTypes.MELTING));
        ExNihiloRegistries.HEAT_REGISTRY.setRecipes(ExNihiloInitialization.filterRecipes(recipes, HeatRecipe.class, EXNRecipeTypes.HEAT));
        ExNihiloRegistries.SIEVE_REGISTRY.setRecipes(ExNihiloInitialization.filterRecipes(recipes, SiftingRecipe.class, EXNRecipeTypes.SIFTING));
    }

    private static void overrideOres() {
        if (Config.enableOreOverride()) {
            EXNItems.COPPER.setEnabled(Config.enableCopper());
            EXNItems.LEAD.setEnabled(Config.enableLead());
            EXNItems.LEAD.setEnabled(Config.enableLead());
            EXNItems.NICKEL.setEnabled(Config.enableNickel());
            EXNItems.SILVER.setEnabled(Config.enableSilver());
            EXNItems.TIN.setEnabled(Config.enableTin());
            EXNItems.ALUMINUM.setEnabled(Config.enableAluminum());
            EXNItems.PLATINUM.setEnabled(Config.enablePlatinum());
            EXNItems.URANIUM.setEnabled(Config.enableUranium());
            EXNItems.ZINC.setEnabled(Config.enableZinc());
            EXNItems.IRON.setEnabled(Config.enableIron());
            EXNItems.GOLD.setEnabled(Config.enableGold());
        }
    }

    private static void registerOreCompat() {
        log.debug("Register ore compatibility");
        EXNItems.IRON.setEnabled(true);
        EXNItems.GOLD.setEnabled(true);
        log.debug("Immersive Engineering detected: " + ModList.get().isLoaded("immersiveengineering"));
        if (ModList.get().isLoaded("immersiveengineering")) {
            log.debug("Added Immersive Engineering");
            EXNItems.ALUMINUM.setEnabled(true);
            EXNItems.COPPER.setEnabled(true);
            EXNItems.SILVER.setEnabled(true);
            EXNItems.NICKEL.setEnabled(true);
            EXNItems.LEAD.setEnabled(true);
            EXNItems.URANIUM.setEnabled(true);
        }
        log.debug("Create detected: " + ModList.get().isLoaded("create"));
        if (ModList.get().isLoaded("create")) {
            log.debug("Added Create");
            EXNItems.COPPER.setEnabled(true);
            EXNItems.ZINC.setEnabled(true);
        }
    }
}

