/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.tags;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import novamachina.exnihilosequentia.world.item.Ore;

public class ExNihiloTags {
    public static final TagKey<Item> CLAY = ItemTags.create((ResourceLocation)ExNihiloTags.forgeLoc("clay"));
    public static final TagKey<Item> HAMMER = ItemTags.create((ResourceLocation)ExNihiloTags.modLoc("hammer"));
    public static final TagKey<Item> CROOK = ItemTags.create((ResourceLocation)ExNihiloTags.modLoc("crook"));
    public static final TagKey<Item> MEAT_COOKED = ItemTags.create((ResourceLocation)ExNihiloTags.forgeLoc("meat_cooked"));
    public static final TagKey<Item> MEAT_UNCOOKED = ItemTags.create((ResourceLocation)ExNihiloTags.forgeLoc("meat_uncooked"));
    public static final TagKey<Item> CRUCIBLE = ItemTags.create((ResourceLocation)ExNihiloTags.modLoc("crucibles"));
    public static final TagKey<Item> BARREL = ItemTags.create((ResourceLocation)ExNihiloTags.modLoc("barrels"));
    public static final TagKey<Item> SIEVE = ItemTags.create((ResourceLocation)ExNihiloTags.modLoc("sieves"));
    public static final TagKey<Item> PIECE = ItemTags.create((ResourceLocation)ExNihiloTags.modLoc("pieces"));
    public static final TagKey<Item> PEBBLES = ItemTags.create((ResourceLocation)ExNihiloTags.modLoc("pebbles"));
    public static final TagKey<Block> MINEABLE_WITH_CROOK = BlockTags.create((ResourceLocation)ExNihiloTags.modLoc("mineable/crook"));
    public static final TagKey<Block> MINEABLE_WITH_HAMMER = BlockTags.create((ResourceLocation)ExNihiloTags.modLoc("mineable/hammer"));
    public static final TagKey<Block> INFESTABLE = BlockTags.create((ResourceLocation)ExNihiloTags.modLoc("infestable"));
    public static final TagKey<Item> NUGGET_COPPER = ItemTags.create((ResourceLocation)ExNihiloTags.forgeLoc("nuggets/copper"));

    private ExNihiloTags() {
    }

    public static ResourceLocation getIngot(String ingot) {
        return ExNihiloTags.forgeLoc("ingots/" + ingot);
    }

    public static ResourceLocation getRawMaterial(String ore) {
        return ExNihiloTags.forgeLoc("raw_materials/" + ore);
    }

    public static ResourceLocation getNugget(String ore) {
        return ExNihiloTags.forgeLoc("nuggets/" + ore);
    }

    private static ResourceLocation forgeLoc(String path) {
        return new ResourceLocation("forge", path);
    }

    private static ResourceLocation modLoc(String path) {
        return new ResourceLocation("exnihilosequentia", path);
    }

    public static class OreTag {
        private final TagKey<Item> ingot;
        private final TagKey<Item> rawMaterial;
        private final TagKey<Item> nugget;

        public OreTag(Ore ore) {
            this.ingot = ItemTags.create((ResourceLocation)ExNihiloTags.getIngot(ore.getOreName()));
            this.rawMaterial = ItemTags.create((ResourceLocation)ExNihiloTags.getRawMaterial(ore.getOreName()));
            this.nugget = ItemTags.create((ResourceLocation)ExNihiloTags.getNugget(ore.getOreName()));
        }

        public TagKey<Item> getIngotTag() {
            return this.ingot;
        }

        public TagKey<Item> getRawMaterialTag() {
            return this.rawMaterial;
        }

        public TagKey<Item> getNuggetTag() {
            return this.nugget;
        }
    }
}

