/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.world.item.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import novamachina.exnihilosequentia.world.item.crafting.EXNRecipeSerializers;
import novamachina.exnihilosequentia.world.item.crafting.EXNRecipeTypes;
import novamachina.exnihilosequentia.world.level.block.EXNBlocks;
import novamachina.novacore.util.FluidStackUtils;
import novamachina.novacore.util.ItemStackHelper;
import novamachina.novacore.world.item.crafting.Recipe;
import org.checkerframework.checker.nullness.qual.NonNull;

public class SolidifyingRecipe
extends Recipe {
    private final FluidStack fluidInTank;
    private final FluidStack fluidOnTop;
    private final ItemStack result;

    public SolidifyingRecipe(ResourceLocation id, FluidStack fluidInTank, FluidStack fluidOnTop, ItemStack result) {
        super(id);
        this.fluidInTank = fluidInTank;
        this.fluidOnTop = fluidOnTop;
        this.result = result;
    }

    public boolean validInputs(@NonNull Fluid fluidInTank, @NonNull Fluid fluidOnTop) {
        return this.fluidInTank.getFluid().m_6212_(fluidInTank) && this.fluidOnTop.getFluid().m_6212_(fluidOnTop);
    }

    public @NonNull ItemStack m_8042_() {
        return EXNBlocks.OAK_SIEVE.itemStack();
    }

    public @NonNull RecipeSerializer<?> m_7707_() {
        return EXNRecipeSerializers.SOLIDIFYING_RECIPE_SERIALIZER.recipeSerializer();
    }

    public @NonNull RecipeType<?> m_6671_() {
        return EXNRecipeTypes.SOLIDIFYING;
    }

    public void write(FriendlyByteBuf buffer) {
        this.fluidInTank.writeToPacket(buffer);
        this.fluidOnTop.writeToPacket(buffer);
        buffer.m_130055_(this.result);
    }

    public FluidStack getFluidInTank() {
        return this.fluidInTank;
    }

    public FluidStack getFluidOnTop() {
        return this.fluidOnTop;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public static class Serializer<T extends SolidifyingRecipe>
    implements RecipeSerializer<T> {
        private final IFactory<T> factory;

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
        }

        public @NonNull T fromJson(@NonNull ResourceLocation id, JsonObject json) {
            FluidStack fluidInTank = FluidStackUtils.deserialize((JsonObject)json.getAsJsonObject("fluidInTank"));
            FluidStack fluidOnTop = FluidStackUtils.deserialize((JsonObject)json.getAsJsonObject("fluidOnTop"));
            ItemStack result = ItemStackHelper.deserialize((JsonElement)json.get("result"));
            return (T)((Object)((SolidifyingRecipe)((Object)this.factory.create(id, fluidInTank, fluidOnTop, result))));
        }

        public @NonNull T fromNetwork(@NonNull ResourceLocation id, @NonNull FriendlyByteBuf buffer) {
            FluidStack fluidInTank = FluidStack.readFromPacket((FriendlyByteBuf)buffer);
            FluidStack fluidOnTop = FluidStack.readFromPacket((FriendlyByteBuf)buffer);
            ItemStack result = buffer.m_130267_();
            return (T)((Object)((SolidifyingRecipe)((Object)this.factory.create(id, fluidInTank, fluidOnTop, result))));
        }

        public void toNetwork(@NonNull FriendlyByteBuf buffer, T recipe) {
            ((SolidifyingRecipe)((Object)recipe)).write(buffer);
        }

        @FunctionalInterface
        public static interface IFactory<T> {
            public T create(ResourceLocation var1, FluidStack var2, FluidStack var3, ItemStack var4);
        }
    }
}

