/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.world.level.block;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import novamachina.exnihilosequentia.common.Config;
import novamachina.exnihilosequentia.common.compat.top.ITOPInfoProvider;
import novamachina.exnihilosequentia.common.registries.ExNihiloRegistries;
import novamachina.exnihilosequentia.world.item.MeshItem;
import novamachina.exnihilosequentia.world.item.MeshType;
import novamachina.exnihilosequentia.world.level.block.entity.SieveBlockEntity;
import novamachina.novacore.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SieveBlock
extends Block
implements SimpleWaterloggedBlock,
ITOPInfoProvider {
    private static Logger log = LoggerFactory.getLogger(SieveBlock.class);
    @Nonnull
    public static final EnumProperty<MeshType> MESH = EnumProperty.m_61587_((String)"mesh", MeshType.class);
    @Nonnull
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public SieveBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(MESH, (Comparable)((Object)MeshType.NONE))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public void activateBlock(@Nonnull BlockState state, @Nonnull Level worldIn, @Nonnull Player player, @Nonnull BlockPos pos, @Nonnull InteractionHand handIn) {
        Item item;
        ItemStack stack = player.m_21120_(handIn);
        SieveBlockEntity sieveBlockEntity = (SieveBlockEntity)worldIn.m_7702_(pos);
        if (sieveBlockEntity == null) {
            return;
        }
        log.debug("isReadyToSieve: " + sieveBlockEntity.isReadyToSieve());
        if (sieveBlockEntity.isReadyToSieve()) {
            sieveBlockEntity.activateSieve(player, (Boolean)state.m_61143_((Property)WATERLOGGED));
        }
        if (!sieveBlockEntity.isReadyToSieve() && (item = stack.m_41720_()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            log.debug("Is Block Siftable: " + ExNihiloRegistries.SIEVE_REGISTRY.isBlockSiftable(blockItem.m_40614_(), sieveBlockEntity.getMeshType(), (Boolean)state.m_61143_((Property)WATERLOGGED)));
            if (ExNihiloRegistries.SIEVE_REGISTRY.isBlockSiftable(blockItem.m_40614_(), sieveBlockEntity.getMeshType(), (Boolean)state.m_61143_((Property)WATERLOGGED))) {
                sieveBlockEntity.insertSiftableBlock(stack, player);
            }
        }
        worldIn.m_7260_(pos, worldIn.m_8055_(pos), worldIn.m_8055_(pos), 2);
    }

    @Override
    public void addProbeInfo(@Nonnull ProbeMode probeMode, @Nonnull IProbeInfo iProbeInfo, @Nonnull Player playerEntity, @Nonnull Level world, @Nonnull BlockState blockState, @Nonnull IProbeHitData iProbeHitData) {
        SieveBlockEntity sieveBlockEntity = (SieveBlockEntity)world.m_7702_(iProbeHitData.getPos());
        if (sieveBlockEntity == null) {
            return;
        }
        if (!sieveBlockEntity.getBlockStack().m_41619_()) {
            if (probeMode == ProbeMode.EXTENDED) {
                iProbeInfo.text((Component)Component.m_237110_((String)"waila.progress", (Object[])new Object[]{StringUtils.formatPercent((Float)Float.valueOf(sieveBlockEntity.getProgress()))}));
            }
            iProbeInfo.text((Component)Component.m_237110_((String)"waila.sieve.block", (Object[])new Object[]{Component.m_237115_((String)sieveBlockEntity.getBlockStack().m_41778_())}));
        }
        if (sieveBlockEntity.getMeshType() != MeshType.NONE) {
            iProbeInfo.text((Component)Component.m_237110_((String)"waila.sieve.mesh", (Object[])new Object[]{Component.m_237115_((String)("item.exnihilosequentia." + sieveBlockEntity.getMeshType().getMeshName()))}));
        }
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{MESH, WATERLOGGED});
    }

    @Nonnull
    @Deprecated(forRemoval=false)
    public FluidState m_5888_(@Nonnull BlockState state) {
        return Boolean.TRUE.equals(state.m_61143_((Property)WATERLOGGED)) ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Nonnull
    private List<BlockPos> getNearbySieves(@Nonnull Level world, @Nonnull BlockPos pos) {
        NonNullList nearbySieves = NonNullList.m_122779_();
        BlockPos.m_121990_((BlockPos)new BlockPos(pos.m_123341_() - Config.getSieveRange(), pos.m_123342_(), pos.m_123343_() - Config.getSieveRange()), (BlockPos)new BlockPos(pos.m_123341_() + Config.getSieveRange(), pos.m_123342_(), pos.m_123343_() + Config.getSieveRange())).forEach(item -> {
            if (world.m_8055_(item).m_60734_() instanceof SieveBlock) {
                nearbySieves.add((Object)new BlockPos((Vec3i)item));
            }
        });
        return nearbySieves;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Deprecated(forRemoval=false)
    public float m_7749_(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos) {
        return 1.0f;
    }

    @Nonnull
    public BlockState m_5573_(@Nonnull BlockPlaceContext context) {
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
    }

    public void m_6240_(@Nonnull Level worldIn, @Nonnull Player player, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable BlockEntity te, @Nonnull ItemStack stack) {
        super.m_6240_(worldIn, player, pos, state, te, stack);
        if (!worldIn.m_5776_() && te instanceof SieveBlockEntity) {
            SieveBlockEntity sieveBlockEntity = (SieveBlockEntity)te;
            sieveBlockEntity.removeMesh(false);
            if (!sieveBlockEntity.getBlockStack().m_41619_()) {
                worldIn.m_7967_((Entity)new ItemEntity(worldIn, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 1.1f), (double)((float)pos.m_123343_() + 0.5f), sieveBlockEntity.getBlockStack()));
            }
        }
    }

    public boolean m_7420_(@Nonnull BlockState state, @Nonnull BlockGetter reader, @Nonnull BlockPos pos) {
        return true;
    }

    public void m_6402_(@Nonnull Level worldIn, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable LivingEntity placer, @Nonnull ItemStack stack) {
        SieveBlockEntity sieveBlockEntity;
        super.m_6402_(worldIn, pos, state, placer, stack);
        if (!worldIn.m_5776_() && (sieveBlockEntity = (SieveBlockEntity)worldIn.m_7702_(pos)) != null) {
            sieveBlockEntity.setSieveState();
        }
    }

    @Nonnull
    @Deprecated(forRemoval=false)
    public BlockState m_7417_(@Nonnull BlockState stateIn, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor worldIn, @Nonnull BlockPos currentPos, @Nonnull BlockPos facingPos) {
        if (Boolean.TRUE.equals(stateIn.m_61143_((Property)WATERLOGGED))) {
            worldIn.m_183324_().m_183582_(currentPos, (Object)Fluids.f_76193_);
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Nonnull
    @Deprecated(forRemoval=false)
    public InteractionResult m_6227_(@Nonnull BlockState state, @Nonnull Level worldIn, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand handIn, @Nonnull BlockHitResult hit) {
        SieveBlockEntity sieveBlockEntity = (SieveBlockEntity)worldIn.m_7702_(pos);
        if (sieveBlockEntity == null) {
            return InteractionResult.PASS;
        }
        if (!worldIn.m_5776_()) {
            log.debug("Sieve Activated");
            ItemStack stack = player.m_21120_(handIn);
            if (player.m_6144_() && stack.m_41619_()) {
                sieveBlockEntity.removeMesh(true);
            }
            for (BlockPos sievePos : this.getNearbySieves(worldIn, pos)) {
                BlockState currentState = worldIn.m_8055_(sievePos);
                this.activateBlock(currentState, worldIn, player, sievePos, handIn);
            }
            if (stack.m_41720_() instanceof MeshItem) {
                sieveBlockEntity.insertMesh(stack, player);
            }
        }
        worldIn.m_7260_(pos, worldIn.m_8055_(pos), worldIn.m_8055_(pos), 2);
        return InteractionResult.SUCCESS;
    }
}

