/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.client.model.light;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import me.paulf.fairylights.client.model.light.ColorLightModel;
import me.paulf.fairylights.client.model.light.EasyMeshBuilder;
import me.paulf.fairylights.client.model.light.LightModel;
import me.paulf.fairylights.server.feature.light.Light;
import me.paulf.fairylights.server.feature.light.MultiLightBehavior;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.LayerDefinition;

public class IcicleLightsModel
extends LightModel<MultiLightBehavior> {
    private final List<ColorLightModel> bulbs;

    public IcicleLightsModel(ModelPart root, int lights) {
        super(root);
        this.bulbs = new ArrayList<ColorLightModel>(lights);
        for (int i = 0; i < lights; ++i) {
            this.bulbs.add(new ColorLightModel(root.m_171324_("light_" + i)));
        }
    }

    @Override
    public void animate(Light<?> light, MultiLightBehavior behavior, float delta) {
        for (int i = 0; i < this.bulbs.size(); ++i) {
            this.bulbs.get(i).animate(light, behavior.get(i), delta);
        }
    }

    @Override
    public void m_7695_(PoseStack matrix, VertexConsumer builder, int light, int overlay, float r, float g, float b, float a) {
        super.m_7695_(matrix, builder, light, overlay, r, g, b, a);
        for (ColorLightModel bulb : this.bulbs) {
            bulb.m_7695_(matrix, builder, light, overlay, r, g, b, a);
        }
    }

    @Override
    public void renderTranslucent(PoseStack matrix, VertexConsumer builder, int light, int overlay, float r, float g, float b, float a) {
        super.renderTranslucent(matrix, builder, light, overlay, r, g, b, a);
        for (ColorLightModel bulb : this.bulbs) {
            bulb.renderTranslucent(matrix, builder, light, overlay, r, g, b, a);
        }
    }

    public static LayerDefinition createLayer(int lights) {
        LightModel.LightMeshHelper helper = LightModel.LightMeshHelper.create();
        EasyMeshBuilder connector = new EasyMeshBuilder("connector", 77, 0);
        connector.setRotationPoint(0.0f, 0.0f, 0.0f);
        connector.addBox(-1.0f, -0.5f, -1.0f, 2.0f, 2.0f, 2.0f, -0.05f);
        helper.unlit().addChild(connector);
        EasyMeshBuilder wire1 = null;
        if (lights > 0) {
            wire1 = new EasyMeshBuilder("wire1", 29, 76);
            wire1.setRotationPoint(0.0f, -0.5f, 0.0f);
            wire1.addBox(-0.5f, 0.0f, -0.5f, 1.0f, 4.0f, 1.0f, 0.0f);
            wire1.xRot = -3.0543263f;
            connector.addChild(wire1);
            EasyMeshBuilder lightBase1 = new EasyMeshBuilder("lightBase1", 33, 76);
            lightBase1.setRotationPoint(0.0f, 2.0f, 0.5f);
            lightBase1.addBox(-0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            wire1.addChild(lightBase1);
            LightModel.LightMeshHelper model = LightModel.LightMeshHelper.create();
            LightModel.BulbBuilder light1 = model.createBulb().createChild("light1", 29, 72);
            light1.setPosition(0.0f, -2.4052336f, -1.1705062f);
            light1.addBox(-1.0f, -0.5f, 0.0f, 2.0f, 2.0f, 2.0f, 0.0f);
            light1.setAngles(-3.0543263f, 0.0f, 0.0f);
            helper.extra().add(model.parented("light_0"));
        }
        EasyMeshBuilder wire2 = null;
        if (lights > 1) {
            wire2 = new EasyMeshBuilder("wire2", 29, 76);
            wire2.setRotationPoint(0.0f, 4.0f, 0.0f);
            wire2.addBox(-0.5f, 0.0f, -0.5f, 1.0f, 4.0f, 1.0f, 0.0f);
            wire2.xRot = -0.2617994f;
            wire2.yRot = 0.5235988f;
            wire1.addChild(wire2);
            EasyMeshBuilder lightBase2 = new EasyMeshBuilder("lightBase2", 33, 76);
            lightBase2.setRotationPoint(0.0f, 2.0f, -1.5f);
            lightBase2.addBox(-0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            wire2.addChild(lightBase2);
            LightModel.LightMeshHelper model = LightModel.LightMeshHelper.create();
            LightModel.BulbBuilder light2 = model.createBulb().createChild("light2", 29, 72);
            light2.setPosition(-1.7077078f, -5.893569f, 2.497259f);
            light2.addBox(-1.0f, -0.5f, 0.0f, 2.0f, 2.0f, 2.0f, 0.0f);
            light2.setAngles(2.980475f, -0.5214032f, -0.050276987f);
            helper.extra().add(model.parented("light_1"));
        }
        EasyMeshBuilder wire3 = null;
        if (lights > 2) {
            wire3 = new EasyMeshBuilder("wire3", 29, 76);
            wire3.setRotationPoint(0.0f, 4.0f, 0.0f);
            wire3.addBox(-0.5f, 0.0f, -0.5f, 1.0f, 4.0f, 1.0f, 0.0f);
            wire3.xRot = 0.43633232f;
            wire3.yRot = 0.5235988f;
            wire2.addChild(wire3);
            EasyMeshBuilder lightBase3 = new EasyMeshBuilder("lightBase3", 33, 76);
            lightBase3.setRotationPoint(0.0f, 2.0f, 0.5f);
            lightBase3.addBox(-0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            wire3.addChild(lightBase3);
            LightModel.LightMeshHelper model = LightModel.LightMeshHelper.create();
            LightModel.BulbBuilder light3 = model.createBulb().createChild("light3", 29, 72);
            light3.setPosition(0.79352164f, -10.095277f, -0.4609129f);
            light3.addBox(-1.0f, -0.5f, 0.0f, 2.0f, 2.0f, 2.0f, 0.0f);
            light3.setAngles(-2.9807093f, -1.0339196f, 0.107201874f);
            helper.extra().add(model.parented("light_2"));
        }
        if (lights > 3) {
            EasyMeshBuilder wire4 = new EasyMeshBuilder("wire4", 29, 76);
            wire4.setRotationPoint(0.0f, 4.0f, 0.0f);
            wire4.addBox(-0.5f, 0.0f, -0.5f, 1.0f, 4.0f, 1.0f, 0.0f);
            wire4.xRot = -0.43633232f;
            wire4.yRot = 0.7853982f;
            wire3.addChild(wire4);
            EasyMeshBuilder lightBase4 = new EasyMeshBuilder("lightBase4", 33, 76);
            lightBase4.setRotationPoint(0.0f, 2.0f, -1.5f);
            lightBase4.addBox(-0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            wire4.addChild(lightBase4);
            LightModel.LightMeshHelper model = LightModel.LightMeshHelper.create();
            LightModel.BulbBuilder light4 = model.createBulb().createChild("light4", 29, 72);
            light4.setPosition(-2.4652689f, -12.951652f, -1.9323987f);
            light4.addBox(0.0f, 0.0f, 0.0f, 2.0f, 2.0f, 2.0f, 0.0f);
            light4.setAngles(-0.7522648f, -1.3039483f, -2.590386f);
            helper.extra().add(model.parented("light_3"));
        }
        return helper.build();
    }
}

