/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.network;

import com.google.common.collect.ArrayListMultimap;
import java.util.List;
import java.util.UUID;
import net.blay09.mods.farmingforblockheads.api.FarmingForBlockheadsAPI;
import net.blay09.mods.farmingforblockheads.api.IMarketCategory;
import net.blay09.mods.farmingforblockheads.api.IMarketEntry;
import net.blay09.mods.farmingforblockheads.menu.MarketClientMenu;
import net.blay09.mods.farmingforblockheads.registry.MarketEntry;
import net.blay09.mods.farmingforblockheads.registry.MarketRegistry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class MarketListMessage {
    private final ArrayListMultimap<IMarketCategory, IMarketEntry> entryMap;

    public MarketListMessage(ArrayListMultimap<IMarketCategory, IMarketEntry> entryMap) {
        this.entryMap = entryMap;
    }

    public static MarketListMessage decode(FriendlyByteBuf buf) {
        ArrayListMultimap entryMap = ArrayListMultimap.create();
        int categoryCount = buf.readByte();
        MarketRegistry.resetCategories();
        for (int i = 0; i < categoryCount; ++i) {
            ResourceLocation categoryId = buf.m_130281_();
            String tooltipLangKey = buf.m_130277_();
            ItemStack icon = buf.m_130267_();
            byte sortIndex = buf.readByte();
            IMarketCategory category = FarmingForBlockheadsAPI.registerMarketCategoryAndReturn(categoryId, tooltipLangKey, icon, sortIndex);
            int entryCount = buf.readShort();
            for (int j = 0; j < entryCount; ++j) {
                entryMap.put((Object)category, (Object)MarketListMessage.readEntry(buf, category));
            }
        }
        return new MarketListMessage((ArrayListMultimap<IMarketCategory, IMarketEntry>)entryMap);
    }

    public static void encode(MarketListMessage message, FriendlyByteBuf buf) {
        buf.writeByte(message.entryMap.keySet().size());
        for (IMarketCategory category : message.entryMap.keySet()) {
            buf.m_130085_(category.getRegistryName());
            buf.m_130070_(category.getTooltipLangKey());
            buf.m_130055_(category.getIconStack());
            buf.writeByte(category.getSortIndex());
            List entries = message.entryMap.get((Object)category);
            buf.writeShort(entries.size());
            for (IMarketEntry entry : entries) {
                MarketListMessage.writeEntry(entry, buf);
            }
        }
    }

    public static void handle(Player player, MarketListMessage message) {
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof MarketClientMenu) {
            MarketClientMenu marketClientMenu = (MarketClientMenu)abstractContainerMenu;
            marketClientMenu.setCategoryList(message.entryMap.keySet());
            marketClientMenu.setEntryList(message.entryMap.values());
        }
    }

    private static MarketEntry readEntry(FriendlyByteBuf buf, IMarketCategory category) {
        UUID entryId = buf.m_130259_();
        ItemStack outputItem = buf.m_130267_();
        ItemStack costItem = buf.m_130267_();
        return new MarketEntry(entryId, outputItem, costItem, category);
    }

    private static void writeEntry(IMarketEntry entry, FriendlyByteBuf buf) {
        buf.m_130077_(entry.getEntryId());
        buf.m_130055_(entry.getOutputItem());
        buf.m_130055_(entry.getCostItem());
    }
}

