/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.client;

import java.util.List;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import whocraft.tardis_refined.client.TRParticles;
import whocraft.tardis_refined.client.TardisClientData;
import whocraft.tardis_refined.client.sounds.HumSoundManager;
import whocraft.tardis_refined.client.sounds.QuickSimpleSound;
import whocraft.tardis_refined.client.sounds.TRSoundInstances;
import whocraft.tardis_refined.common.GravityUtil;
import whocraft.tardis_refined.common.capability.player.TardisPlayerInfo;
import whocraft.tardis_refined.common.soundscape.hum.HumEntry;
import whocraft.tardis_refined.common.util.ClientHelper;
import whocraft.tardis_refined.common.util.TardisHelper;
import whocraft.tardis_refined.registry.TRDimensionTypes;

public class TardisClientLogic {
    @OnlyIn(value=Dist.CLIENT)
    public static void tickClientside(TardisClientData clientData) {
        if (clientData.isTakingOff()) {
            ++clientData.takeOffTime;
            clientData.landingTime = 0;
            return;
        }
        if (clientData.isLanding()) {
            ++clientData.landingTime;
            clientData.takeOffTime = 0;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        TardisPlayerInfo.get((LivingEntity)player).ifPresent(tardisPlayerInfo -> {
            if (tardisPlayerInfo.isViewingTardis()) {
                Minecraft.m_91087_().f_91066_.m_92157_(CameraType.THIRD_PERSON_FRONT);
            }
        });
        if (player.m_9236_().m_220362_() == TRDimensionTypes.TARDIS) {
            ClientLevel tardisLevel = Minecraft.m_91087_().f_91073_;
            TardisClientLogic.createWorldAmbience((Player)player);
            TardisClientLogic.handleTardisLoopingSounds(clientData, (Player)player, (Level)tardisLevel);
            TardisClientLogic.handleScreenShake(clientData, (Player)player);
            TardisClientLogic.handleAestheticEffects(clientData, (Level)tardisLevel);
        }
        TardisClientLogic.handleVortexSounds(clientData, (Player)player);
    }

    private static void handleVortexSounds(TardisClientData clientData, Player player) {
        SoundManager soundManager = Minecraft.m_91087_().m_91106_();
        TardisPlayerInfo.get((LivingEntity)player).ifPresent(tardisPlayerInfo -> {
            if (!clientData.isLanding() && !clientData.isTakingOff() && tardisPlayerInfo.isRenderVortex() && !soundManager.m_120403_((SoundInstance)TRSoundInstances.TARDIS_SINGLE_FLY_VORTEX)) {
                TRSoundInstances.TARDIS_SINGLE_FLY_VORTEX.restartSoundPlaying();
                soundManager.m_120367_((SoundInstance)TRSoundInstances.TARDIS_SINGLE_FLY_VORTEX.setPlayer(player).setLevel((Level)Minecraft.m_91087_().f_91073_));
            }
        });
        TardisPlayerInfo.get((LivingEntity)player).ifPresent(tardisPlayerInfo -> {
            if (tardisPlayerInfo.isRenderVortex() && !soundManager.m_120403_((SoundInstance)TRSoundInstances.VORTEX_WINDS)) {
                TRSoundInstances.VORTEX_WINDS.restartSoundPlaying();
                soundManager.m_120367_((SoundInstance)TRSoundInstances.VORTEX_WINDS.setPlayer(player));
            }
        });
    }

    public static void update(TardisClientData tardisClientData) {
        if (!tardisClientData.isFlying() && tardisClientData.ROTOR_ANIMATION.m_216984_()) {
            tardisClientData.ROTOR_ANIMATION.m_216973_();
        } else if (tardisClientData.isFlying() && !tardisClientData.ROTOR_ANIMATION.m_216984_()) {
            tardisClientData.ROTOR_ANIMATION.m_216977_(0);
        }
        if (tardisClientData.isLanding()) {
            if (!tardisClientData.LANDING_ANIMATION.m_216984_()) {
                tardisClientData.TAKEOFF_ANIMATION.m_216973_();
                tardisClientData.LANDING_ANIMATION.m_216977_(0);
            }
        } else if (tardisClientData.LANDING_ANIMATION.m_216984_()) {
            tardisClientData.LANDING_ANIMATION.m_216973_();
        }
        if (tardisClientData.isTakingOff()) {
            if (!tardisClientData.TAKEOFF_ANIMATION.m_216984_()) {
                tardisClientData.LANDING_ANIMATION.m_216973_();
                tardisClientData.TAKEOFF_ANIMATION.m_216977_(0);
            }
        } else if (tardisClientData.TAKEOFF_ANIMATION.m_216984_()) {
            tardisClientData.TAKEOFF_ANIMATION.m_216973_();
        }
        if (tardisClientData.isCrashing()) {
            if (!tardisClientData.CRASHING_ANIMATION.m_216984_()) {
                tardisClientData.ROTOR_ANIMATION.m_216973_();
                tardisClientData.LANDING_ANIMATION.m_216973_();
                tardisClientData.TAKEOFF_ANIMATION.m_216973_();
                tardisClientData.CRASHING_ANIMATION.m_216977_(0);
            }
        } else if (tardisClientData.CRASHING_ANIMATION.m_216984_()) {
            tardisClientData.CRASHING_ANIMATION.m_216973_();
        }
    }

    public static void tickClientData(Minecraft client) {
        if (client.f_91073_ == null || client.m_91104_()) {
            if (!TardisClientData.getAllEntries().isEmpty() && !client.m_91104_()) {
                TardisClientData.clearAll();
            }
            return;
        }
        TardisClientLogic.handleNonTardisLoopingSounds((Player)client.f_91074_, (Level)client.f_91073_);
        for (TardisClientData tardisClientData : TardisClientData.getAllEntries()) {
            TardisClientLogic.tickClientside(tardisClientData);
        }
    }

    private static void createWorldAmbience(Player player) {
        if (player.f_19797_ % 120 == 0 && !TardisHelper.isInArsArea(player.m_20183_())) {
            return;
        }
        RandomSource random = player.m_9236_().f_46441_;
        Level level = player.m_9236_();
        ClientLevel clientLevel = (ClientLevel)level;
        double originX = player.m_20185_();
        double originY = player.m_20186_();
        double originZ = player.m_20189_();
        for (int i = 0; i < 5; ++i) {
            double particleX = originX + (double)(random.m_188503_(24) - random.m_188503_(24));
            double particleY = originY + (double)(random.m_188503_(24) - random.m_188503_(24));
            double particleZ = originZ + (double)(random.m_188503_(24) - random.m_188503_(24));
            double velocityX = (random.m_188500_() - 0.5) * 0.02;
            double velocityY = (random.m_188500_() - 0.5) * 0.02;
            double velocityZ = (random.m_188500_() - 0.5) * 0.02;
            BlockPos position = new BlockPos((int)particleX, (int)particleY, (int)particleZ);
            if (!TardisHelper.isInArsArea(position)) continue;
            ClientHelper.playParticle(clientLevel, (ParticleOptions)TRParticles.ARS_LEAVES.get(), position, velocityX, velocityY, velocityZ);
            ClientHelper.playParticle(clientLevel, (ParticleOptions)ParticleTypes.f_123810_, position, velocityX, velocityY, velocityZ);
        }
    }

    private static void handleNonTardisLoopingSounds(Player player, Level targetLevel) {
        SoundManager soundManager = Minecraft.m_91087_().m_91106_();
        if (GravityUtil.isInGravityShaft((Player)Minecraft.m_91087_().f_91074_) && !soundManager.m_120403_((SoundInstance)TRSoundInstances.GRAVITY_LOOP)) {
            soundManager.m_120367_((SoundInstance)TRSoundInstances.GRAVITY_LOOP.setPlayer(player).setLevel(targetLevel));
        }
    }

    private static void handleTardisLoopingSounds(TardisClientData clientData, Player player, Level targetLevel) {
        boolean isThisTardis = clientData.getLevelKey() == targetLevel.m_46472_();
        SoundManager soundManager = Minecraft.m_91087_().m_91106_();
        if (TardisHelper.isInArsArea(player.m_20183_()) && !soundManager.m_120403_((SoundInstance)TRSoundInstances.ARS_HUMMING)) {
            soundManager.m_120367_((SoundInstance)TRSoundInstances.ARS_HUMMING.setPlayer(player).setLevel(targetLevel));
        }
        TardisPlayerInfo.get((LivingEntity)Minecraft.m_91087_().f_91074_).ifPresent(tardisPlayerInfo -> {
            if (tardisPlayerInfo.isRenderVortex()) {
                return;
            }
            if (isThisTardis && !clientData.isTakingOff() && !clientData.isLanding() && !clientData.isCrashing() && clientData.isFlying() && !soundManager.m_120403_((SoundInstance)TRSoundInstances.TARDIS_SINGLE_FLY)) {
                TRSoundInstances.TARDIS_SINGLE_FLY.restartSoundPlaying();
                soundManager.m_120367_((SoundInstance)TRSoundInstances.TARDIS_SINGLE_FLY.setPlayer(player).setLevel(targetLevel));
            }
            HumEntry humEntry = clientData.getHumEntry();
            if (isThisTardis && humEntry != null && !humEntry.getSoundEventId().toString().equals(HumSoundManager.getCurrentRawSound().m_11660_().toString()) || !soundManager.m_120403_((SoundInstance)HumSoundManager.getCurrentHumSound())) {
                HumSoundManager.playHum(SoundEvent.m_262856_((ResourceLocation)humEntry.getSoundEventId(), (float)1.0f), player, targetLevel);
            }
            if (isThisTardis && targetLevel.m_46467_() % (long)clientData.nextAmbientNoiseCall == 0L) {
                clientData.nextAmbientNoiseCall = targetLevel.f_46441_.m_216339_(400, 2400);
                List<ResourceLocation> ambientSounds = humEntry.getAmbientSounds();
                if (ambientSounds != null && !ambientSounds.isEmpty()) {
                    RandomSource randomSource = targetLevel.f_46441_;
                    ResourceLocation randomSoundLocation = ambientSounds.get(randomSource.m_188503_(ambientSounds.size()));
                    SoundEvent randomSoundEvent = SoundEvent.m_262824_((ResourceLocation)randomSoundLocation);
                    QuickSimpleSound simpleSoundInstance = new QuickSimpleSound(randomSoundEvent, SoundSource.AMBIENT);
                    simpleSoundInstance.setVolume(0.3f);
                    ClientHelper.playAmbientSound(simpleSoundInstance, randomSource, 0.3f);
                }
            }
            if (isThisTardis && targetLevel.m_46467_() % (long)clientData.nextVoiceAmbientCall == 0L) {
                clientData.nextVoiceAmbientCall = targetLevel.f_46441_.m_216339_(6000, 36000);
                RandomSource randomSource = targetLevel.f_46441_;
                ClientHelper.playAmbientSound(TRSoundInstances.INTERIOR_VOICE, randomSource, 0.3f);
            }
        });
        if (TRSoundInstances.shouldMinecraftMusicStop(soundManager)) {
            Minecraft.m_91087_().m_91397_().m_120186_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleClient() {
        Minecraft.m_91087_().f_91066_.m_92157_(CameraType.FIRST_PERSON);
        TardisPlayerInfo.get((LivingEntity)Minecraft.m_91087_().f_91074_).ifPresent(tardisPlayerInfo -> {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            player.m_146926_(tardisPlayerInfo.getPlayerPreviousYaw());
            player.m_5616_(tardisPlayerInfo.getPlayerPreviousRot());
        });
    }

    private static void handleScreenShake(TardisClientData clientData, Player player) {
        if (player.m_9236_().m_46472_() == clientData.getLevelKey()) {
            if (clientData.isCrashing()) {
                player.m_146926_(player.m_146909_() + (player.m_217043_().m_188501_() - 0.5f) * 0.5f);
                player.m_5616_(player.m_6080_() + (player.m_217043_().m_188501_() - 0.5f) * 0.5f);
            } else if (clientData.isFlying()) {
                player.m_146926_(player.m_146909_() + (player.m_217043_().m_188501_() - 0.5f) * ((float)clientData.getThrottleStage() * 0.1f));
                player.m_5616_(player.m_6080_() + (player.m_217043_().m_188501_() - 0.5f) * ((float)clientData.getThrottleStage() * 0.1f));
            }
        }
    }

    public static float getFogTickDelta(BlockPos playerPosition) {
        return TardisHelper.isInArsArea(playerPosition) ? 1.0f : 1.0f - (float)TardisClientData.FOG_TICK_DELTA / (float)TardisClientData.MAX_FOG_TICK_DELTA;
    }

    public static void tickFog(boolean hasFuel) {
        if (!hasFuel && TardisClientData.FOG_TICK_DELTA <= TardisClientData.MAX_FOG_TICK_DELTA && TardisClientData.FOG_TICK_DELTA > 0) {
            --TardisClientData.FOG_TICK_DELTA;
            return;
        }
        if (hasFuel && TardisClientData.FOG_TICK_DELTA != TardisClientData.MAX_FOG_TICK_DELTA) {
            ++TardisClientData.FOG_TICK_DELTA;
            return;
        }
    }

    private static void handleAestheticEffects(TardisClientData clientData, Level targetLevel) {
        boolean isThisTardis;
        boolean bl = isThisTardis = clientData.getLevelKey() == targetLevel.m_46472_();
        if (isThisTardis) {
            TardisClientLogic.tickFog(clientData.getTardisState() < 2 || clientData.getFuel() != 0.0);
        }
        if (isThisTardis && clientData.getTardisState() == 2) {
            double motionX = 0.0;
            double motionY = 0.1 + (double)(targetLevel.f_46441_.m_188501_() / 2.0f);
            double motionZ = 0.0;
            Vec3 position = new Vec3(1011.5 + (double)targetLevel.f_46441_.m_188503_(4), 71.0, 53.5 + (double)targetLevel.f_46441_.m_188503_(4));
            ClientHelper.playParticle((ClientLevel)targetLevel, (ParticleOptions)ParticleTypes.f_123796_, position, motionX, motionY, motionZ);
        }
    }
}

