/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.client.forge;

import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraftforge.client.event.EntityRenderersEvent;
import whocraft.tardis_refined.TardisRefined;
import whocraft.tardis_refined.client.model.pallidium.BedrockModelUtil;

public class ModelRegistryImpl {
    public static final Map<ModelLayerLocation, Supplier<LayerDefinition>> DEFINITIONS = new ConcurrentHashMap<ModelLayerLocation, Supplier<LayerDefinition>>();

    public static ModelLayerLocation register(ModelLayerLocation location, Supplier<LayerDefinition> definition) {
        DEFINITIONS.put(location, definition);
        TardisRefined.LOGGER.info("EXPORT: " + location);
        JsonObject model = BedrockModelUtil.toJsonModel(definition.get(), location.m_171123_().m_135815_());
        Path exportFolder = Paths.get("C:\\Users\\Craig\\Documents\\GitHub\\AssetsRepository", "export_models", location.m_171124_());
        try {
            Files.createDirectories(exportFolder, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create export_models directory", e);
        }
        Path modelFile = exportFolder.resolve(location.m_171123_().m_135815_().replaceAll("_ext", "").replaceAll("int", "door") + ".json");
        try (BufferedWriter writer = Files.newBufferedWriter(modelFile, new OpenOption[0]);){
            writer.write(model.toString());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write model to file", e);
        }
        return location;
    }

    public static void register(EntityRenderersEvent.RegisterLayerDefinitions event) {
        DEFINITIONS.forEach((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterLayerDefinitions)event).registerLayerDefinition(arg_0, arg_1));
    }
}

