/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.client.model.blockentity.console;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.jeryn.frame.tardis.Frame;
import net.minecraft.client.Minecraft;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import whocraft.tardis_refined.TRConfig;
import whocraft.tardis_refined.client.TardisClientData;
import whocraft.tardis_refined.client.model.blockentity.console.ConsoleUnit;
import whocraft.tardis_refined.common.block.console.GlobalConsoleBlock;
import whocraft.tardis_refined.common.blockentity.console.GlobalConsoleBlockEntity;

public class CopperConsoleModel
extends HierarchicalModel
implements ConsoleUnit {
    public static final AnimationDefinition IDLE = Frame.loadAnimation(new ResourceLocation("tardis_refined", "frame/console/copper/idle.json"));
    public static final AnimationDefinition FLIGHT = Frame.loadAnimation(new ResourceLocation("tardis_refined", "frame/console/copper/flight.json"));
    private static final ResourceLocation COPPER_TEXTURE = new ResourceLocation("tardis_refined", "textures/blockentity/console/copper/copper_console.png");
    private final ModelPart root;
    private final ModelPart rotor;
    private final ModelPart misc;
    private final ModelPart misc2;
    private final ModelPart misc3;
    private final ModelPart misc4;
    private final ModelPart misc5;
    private final ModelPart north_left;
    private final ModelPart north_right;
    private final ModelPart east;
    private final ModelPart south_right;
    private final ModelPart south_left;
    private final ModelPart west;
    private final ModelPart modelRoot;
    private final ModelPart throttle;
    private final ModelPart handbrake;

    public CopperConsoleModel(ModelPart root) {
        this.modelRoot = root;
        this.root = root.m_171324_("root");
        this.rotor = root.m_171324_("rotor");
        this.misc = root.m_171324_("misc");
        this.misc2 = root.m_171324_("misc2");
        this.misc3 = root.m_171324_("misc3");
        this.misc4 = root.m_171324_("misc4");
        this.misc5 = root.m_171324_("misc5");
        this.north_left = root.m_171324_("north_left");
        this.north_right = root.m_171324_("north_right");
        this.east = root.m_171324_("east");
        this.south_right = root.m_171324_("south_right");
        this.south_left = root.m_171324_("south_left");
        this.west = root.m_171324_("west");
        this.throttle = this.north_right.m_171324_("bone203").m_171324_("bone213").m_171324_("main_lever_control2");
        this.handbrake = Frame.findPart(this, "lever_control8");
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rotor.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.misc.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.misc2.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.misc3.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.misc4.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.misc5.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.north_left.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.north_right.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.east.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.south_right.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.south_left.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.west.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.modelRoot;
    }

    public void m_6973_(Entity entity, float f, float g, float h, float i, float j) {
    }

    @Override
    public void renderConsole(GlobalConsoleBlockEntity globalConsoleBlock, Level level, PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        float rot;
        this.modelRoot.m_171331_().forEach(ModelPart::m_233569_);
        TardisClientData reactions = TardisClientData.getInstance((ResourceKey<Level>)level.m_46472_());
        if (globalConsoleBlock != null && ((Boolean)globalConsoleBlock.m_58900_().m_61143_((Property)GlobalConsoleBlock.POWERED)).booleanValue()) {
            if (!reactions.isFlying() && ((Boolean)TRConfig.CLIENT.PLAY_CONSOLE_IDLE_ANIMATIONS.get()).booleanValue() && globalConsoleBlock != null) {
                this.m_233381_(globalConsoleBlock.liveliness, IDLE, Minecraft.m_91087_().f_91074_.f_19797_);
            } else {
                this.m_233381_(reactions.ROTOR_ANIMATION, FLIGHT, Minecraft.m_91087_().f_91074_.f_19797_);
            }
        }
        this.throttle.f_104205_ = rot = 1.0f - 2.0f * ((float)reactions.getThrottleStage() / 5.0f);
        this.handbrake.f_104205_ = !reactions.isHandbrakeEngaged() ? 1.0f : -1.0f;
        this.modelRoot.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    @Override
    public ResourceLocation getDefaultTexture() {
        return COPPER_TEXTURE;
    }
}

