/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.client.model.blockentity.console;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.jeryn.frame.tardis.Frame;
import net.minecraft.client.Minecraft;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import whocraft.tardis_refined.TRConfig;
import whocraft.tardis_refined.client.TardisClientData;
import whocraft.tardis_refined.client.model.blockentity.console.ConsoleUnit;
import whocraft.tardis_refined.common.block.console.GlobalConsoleBlock;
import whocraft.tardis_refined.common.blockentity.console.GlobalConsoleBlockEntity;

public class VictorianConsoleModel
extends HierarchicalModel
implements ConsoleUnit {
    public static final AnimationDefinition IDLE = Frame.loadAnimation(new ResourceLocation("tardis_refined", "frame/console/victorian/idle.json"));
    public static final AnimationDefinition FLIGHT = Frame.loadAnimation(new ResourceLocation("tardis_refined", "frame/console/victorian/flight.json"));
    public static final AnimationDefinition CRASH = Frame.loadAnimation(new ResourceLocation("tardis_refined", "frame/console/victorian/crash.json"));
    public static final AnimationDefinition POWER_ON = Frame.loadAnimation(new ResourceLocation("tardis_refined", "frame/console/victorian/power_on.json"));
    public static final AnimationDefinition POWER_OFF = Frame.loadAnimation(new ResourceLocation("tardis_refined", "frame/console/victorian/power_off.json"));
    private static final ResourceLocation VICTORIAN_TEXTURE = new ResourceLocation("tardis_refined", "textures/blockentity/console/victorian/victorian_console.png");
    private final ModelPart root;
    private final ModelPart throttle_control;

    public VictorianConsoleModel(ModelPart root) {
        this.root = root;
        this.throttle_control = Frame.findPart(this, "bone187");
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.m_142109_().m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void m_6973_(Entity entity, float f, float g, float h, float i, float j) {
    }

    @Override
    public void renderConsole(GlobalConsoleBlockEntity globalConsoleBlock, Level level, PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        TardisClientData reactions = TardisClientData.getInstance((ResourceKey<Level>)level.m_46472_());
        boolean powered = globalConsoleBlock == null || (Boolean)globalConsoleBlock.m_58900_().m_61143_((Property)GlobalConsoleBlock.POWERED) != false;
        int tickCount = Minecraft.m_91087_().f_91074_.f_19797_;
        if (globalConsoleBlock != null) {
            if (powered) {
                if (globalConsoleBlock.getTicksBooting() > 0) {
                    if (!globalConsoleBlock.powerOn.m_216984_()) {
                        globalConsoleBlock.powerOff.m_216973_();
                        globalConsoleBlock.powerOn.m_216977_(tickCount);
                    }
                    this.m_233381_(globalConsoleBlock.powerOn, POWER_ON, tickCount);
                }
                if (reactions.isFlying()) {
                    this.m_233381_(reactions.ROTOR_ANIMATION, FLIGHT, tickCount);
                } else if (reactions.isCrashing()) {
                    this.m_233381_(reactions.CRASHING_ANIMATION, CRASH, tickCount);
                } else if (((Boolean)TRConfig.CLIENT.PLAY_CONSOLE_IDLE_ANIMATIONS.get()).booleanValue()) {
                    this.m_233381_(globalConsoleBlock.liveliness, IDLE, tickCount);
                }
            } else {
                if (!globalConsoleBlock.powerOff.m_216984_()) {
                    globalConsoleBlock.powerOn.m_216973_();
                    globalConsoleBlock.powerOff.m_216977_(tickCount);
                }
                this.m_233381_(globalConsoleBlock.powerOff, POWER_OFF, tickCount);
            }
            this.throttle_control.f_104204_ = 1.0f + 2.0f * ((float)reactions.getThrottleStage() / 5.0f);
        }
        this.m_142109_().m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    @Override
    public ResourceLocation getDefaultTexture() {
        return VICTORIAN_TEXTURE;
    }
}

