/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.client.overlays;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import whocraft.tardis_refined.client.TRKeybinds;
import whocraft.tardis_refined.client.TardisClientData;
import whocraft.tardis_refined.client.renderer.RenderHelper;
import whocraft.tardis_refined.common.capability.player.TardisPlayerInfo;
import whocraft.tardis_refined.constants.ModMessages;

public class ExteriorViewOverlay {
    public static final ResourceLocation BAR_TEXTURE = new ResourceLocation("tardis_refined", "textures/gui/bar/journey_bar.png");
    public static final ResourceLocation FUEL_BAR_TEXTURE = new ResourceLocation("tardis_refined", "textures/gui/bar/fuel_bar.png");
    public static boolean shouldRender = true;
    private static final RenderHelper.CustomProgressBar PROGRESS_BAR = new RenderHelper.CustomProgressBar(BAR_TEXTURE, 256, 256, 5, 182, 60);
    public static final RenderHelper.CustomProgressBar FUEL_BAR = new RenderHelper.CustomProgressBar(FUEL_BAR_TEXTURE, 256, 256, 11, 127, 60);

    public static void renderOverlay(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.m_91087_();
        if (!shouldRender) {
            return;
        }
        TardisPlayerInfo.get((LivingEntity)mc.f_91074_).ifPresent(tardisPlayerInfo -> {
            if (!tardisPlayerInfo.isViewingTardis()) {
                return;
            }
            TardisClientData tardisClientData = TardisClientData.getInstance(tardisPlayerInfo.getPlayerPreviousPos().getDimensionKey());
            PoseStack poseStack = guiGraphics.m_280168_();
            int screenWidth = mc.m_91268_().m_85445_();
            int screenHeight = mc.m_91268_().m_85446_();
            int x = 10;
            int y = 10;
            int remainingFuel = (int)tardisClientData.getFuel();
            int maxFuel = (int)tardisClientData.getMaximumFuel();
            int fuelPercentage = maxFuel != 0 ? (int)((double)remainingFuel / (double)maxFuel * 100.0) : 0;
            int throttleStage = tardisClientData.getThrottleStage();
            int maxThrottleStage = 5;
            int throttlePercentage = maxThrottleStage != 0 ? (int)((double)throttleStage / (double)maxThrottleStage * 100.0) : 0;
            Component exitKey = TRKeybinds.EXIT_EXTERIOR_VIEW.f_90816_.m_84875_();
            MutableComponent message = Component.m_237115_((String)ModMessages.EXIT_EXTERNAL_VIEW).m_7220_(exitKey).m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.WHITE});
            MutableComponent throttleMessage = Component.m_237113_((String)("Throttle: " + throttlePercentage + "%")).m_130940_(ChatFormatting.WHITE);
            MutableComponent fuelMessage = Component.m_237110_((String)ModMessages.FUEL, (Object[])new Object[]{fuelPercentage}).m_130946_("%").m_130940_(ChatFormatting.WHITE);
            BlockPos pos = mc.f_91074_.m_20183_();
            MutableComponent coordsMessage = Component.m_237113_((String)String.format("Coordinates: X: %d Y: %d Z: %d", pos.m_123341_(), pos.m_123342_(), pos.m_123343_())).m_130940_(ChatFormatting.WHITE);
            int coordsWidth = mc.f_91062_.m_92852_((FormattedText)coordsMessage);
            poseStack.m_85836_();
            if (mc.f_91080_ == null) {
                poseStack.m_85836_();
                int messageWidth = mc.f_91062_.m_92852_((FormattedText)message);
                float f = 5.0f + (float)messageWidth / 2.0f;
                float f2 = -3 + screenHeight;
                Objects.requireNonNull(mc.f_91062_);
                poseStack.m_252880_(f, f2 - 9.0f / 2.0f, 0.0f);
                int n = -messageWidth / 2;
                Objects.requireNonNull(mc.f_91062_);
                int n2 = -3 - 9 / 2;
                int n3 = messageWidth / 2;
                Objects.requireNonNull(mc.f_91062_);
                guiGraphics.m_280509_(n, n2, n3, 2 + 9 / 2, -2013265920);
                Font font = mc.f_91062_;
                String string = message.getString();
                int n4 = 8 - messageWidth / 2;
                Objects.requireNonNull(mc.f_91062_);
                guiGraphics.m_280056_(font, string, n4, -9 / 2, 0xFFFFFF, false);
                poseStack.m_85849_();
            }
            poseStack.m_85836_();
            ExteriorViewOverlay.FUEL_BAR.animate = tardisClientData.isFlying();
            poseStack.m_252880_(20.0f, 20.0f, 0.0f);
            FUEL_BAR.blit(guiGraphics, 0, 0, (double)remainingFuel / (double)maxFuel);
            guiGraphics.m_280056_(mc.f_91062_, fuelMessage.getString(), 3, 2, 5710336, false);
            poseStack.m_85849_();
            guiGraphics.m_280056_(mc.f_91062_, throttleMessage.getString(), 20, 35, 0xFFFFFF, false);
            float journeyProgress = tardisClientData.getJourneyProgress() / 100.0f;
            if (!tardisClientData.isFlying()) {
                poseStack.m_85836_();
                poseStack.m_252880_((float)(screenWidth - coordsWidth - 10), 22.0f, 0.0f);
                Objects.requireNonNull(mc.f_91062_);
                guiGraphics.m_280509_(-2, -3, coordsWidth + 2, 9 + 2, -2013265920);
                guiGraphics.m_280056_(mc.f_91062_, coordsMessage.getString(), 0, 0, 0xFFFFFF, false);
                poseStack.m_85849_();
            }
            if (tardisClientData.isFlying()) {
                ExteriorViewOverlay.renderJourneyProgressBar(guiGraphics, journeyProgress);
            }
            poseStack.m_85849_();
        });
    }

    public static void renderJourneyProgressBar(GuiGraphics guiGraphics, float journeyProgress) {
        Minecraft mc = Minecraft.m_91087_();
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        float clampedProgress = Mth.m_14036_((float)journeyProgress, (float)0.0f, (float)1.0f);
        int barWidth = 182;
        int barHeight = 5;
        int barX = (screenWidth - barWidth) / 2;
        int barY = screenHeight - 25;
        PROGRESS_BAR.blit(guiGraphics, barX, barY, clampedProgress);
        String progressText = String.format("Journey: %.0f%%", Float.valueOf(clampedProgress * 100.0f));
        Font fontRenderer = mc.f_91062_;
        int textX = (screenWidth - fontRenderer.m_92895_(progressText)) / 2;
        int textY = barY - 10;
        guiGraphics.m_280056_(mc.f_91062_, progressText, textX, textY, 0xFFFFFF, false);
    }
}

