/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.client.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class RenderHelper {
    public static Tesselator tesselator;

    public static void renderFilledBox(PoseStack stack, VertexConsumer vertexConsumer, AABB box, float red, float green, float blue, float alpha, int combinedLightIn) {
        Matrix4f matrix = stack.m_85850_().m_252922_();
        vertexConsumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82292_, (float)box.f_82290_).m_85950_(red, green, blue, alpha).m_85969_(combinedLightIn).m_5752_();
        vertexConsumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82292_, (float)box.f_82293_).m_85950_(red, green, blue, alpha).m_85969_(combinedLightIn).m_5752_();
        vertexConsumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82292_, (float)box.f_82293_).m_85950_(red, green, blue, alpha).m_85969_(combinedLightIn).m_5752_();
        vertexConsumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82292_, (float)box.f_82290_).m_85950_(red, green, blue, alpha).m_85969_(combinedLightIn).m_5752_();
        vertexConsumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82289_, (float)box.f_82290_).m_85950_(red, green, blue, alpha).m_85969_(combinedLightIn).m_5752_();
        vertexConsumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82289_, (float)box.f_82290_).m_85950_(red, green, blue, alpha).m_85969_(combinedLightIn).m_5752_();
        vertexConsumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82289_, (float)box.f_82293_).m_85950_(red, green, blue, alpha).m_85969_(combinedLightIn).m_5752_();
        vertexConsumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82289_, (float)box.f_82293_).m_85950_(red, green, blue, alpha).m_85969_(combinedLightIn).m_5752_();
        vertexConsumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82289_, (float)box.f_82290_).m_85950_(red, green, blue, alpha).m_85969_(combinedLightIn).m_5752_();
        vertexConsumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82292_, (float)box.f_82290_).m_85950_(red, green, blue, alpha).m_85969_(combinedLightIn).m_5752_();
        vertexConsumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82292_, (float)box.f_82290_).m_85950_(red, green, blue, alpha).m_85969_(combinedLightIn).m_5752_();
        vertexConsumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82289_, (float)box.f_82290_).m_85950_(red, green, blue, alpha).m_85969_(combinedLightIn).m_5752_();
        vertexConsumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82289_, (float)box.f_82293_).m_85950_(red, green, blue, alpha).m_85969_(combinedLightIn).m_5752_();
        vertexConsumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82289_, (float)box.f_82293_).m_85950_(red, green, blue, alpha).m_85969_(combinedLightIn).m_5752_();
        vertexConsumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82292_, (float)box.f_82293_).m_85950_(red, green, blue, alpha).m_85969_(combinedLightIn).m_5752_();
        vertexConsumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82292_, (float)box.f_82293_).m_85950_(red, green, blue, alpha).m_85969_(combinedLightIn).m_5752_();
        vertexConsumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82289_, (float)box.f_82290_).m_85950_(red, green, blue, alpha).m_85969_(combinedLightIn).m_5752_();
        vertexConsumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82292_, (float)box.f_82290_).m_85950_(red, green, blue, alpha).m_85969_(combinedLightIn).m_5752_();
        vertexConsumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82292_, (float)box.f_82293_).m_85950_(red, green, blue, alpha).m_85969_(combinedLightIn).m_5752_();
        vertexConsumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82289_, (float)box.f_82293_).m_85950_(red, green, blue, alpha).m_85969_(combinedLightIn).m_5752_();
        vertexConsumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82289_, (float)box.f_82290_).m_85950_(red, green, blue, alpha).m_85969_(combinedLightIn).m_5752_();
        vertexConsumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82289_, (float)box.f_82293_).m_85950_(red, green, blue, alpha).m_85969_(combinedLightIn).m_5752_();
        vertexConsumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82292_, (float)box.f_82293_).m_85950_(red, green, blue, alpha).m_85969_(combinedLightIn).m_5752_();
        vertexConsumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82292_, (float)box.f_82290_).m_85950_(red, green, blue, alpha).m_85969_(combinedLightIn).m_5752_();
    }

    public static void drawGlowingBox(PoseStack poseStack, VertexConsumer consumer, float length, float height, float width, float red, float green, float blue, float alpha, int combinedLightIn) {
        AABB box = new AABB((double)(-length / 2.0f), (double)(-height / 2.0f), (double)(-width / 2.0f), (double)(length / 2.0f), (double)(height / 2.0f), (double)(width / 2.0f));
        RenderHelper.renderFilledBox(poseStack, consumer, box, 1.0f, 1.0f, 1.0f, alpha, combinedLightIn);
        for (int i = 0; i < 3; ++i) {
            RenderHelper.renderFilledBox(poseStack, consumer, box.m_82400_((double)((float)i * 0.5f * 0.0625f)), red, green, blue, alpha, combinedLightIn);
        }
    }

    public static void rotateZYX(PoseStack poseStack, float x, float y, float z) {
        poseStack.m_252781_(new Quaternionf().rotationZYX((float)Math.PI / 180 * z, (float)Math.PI / 180 * y, (float)Math.PI / 180 * x));
    }

    public static Tesselator beginTextureColor(ResourceLocation texture, VertexFormat.Mode mode, boolean cull) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.enableBlend();
        if (cull) {
            RenderSystem.enableCull();
        } else {
            RenderSystem.disableCull();
        }
        RenderSystem.enableDepthTest();
        tesselator = Tesselator.m_85913_();
        tesselator.m_85915_().m_166779_(mode, DefaultVertexFormat.f_85819_);
        return tesselator;
    }

    public static void vertexUVColor(@NotNull PoseStack pose, float x, float y, float z, float u, float v, float r, float g, float b, float a) {
        tesselator.m_85915_().m_252986_(pose.m_85850_().m_252922_(), x, y, z).m_7421_(u, v).m_85950_(r, g, b, a).m_5752_();
    }

    public static class DynamicTimeKeep {
        public double speed = 1.0;
        private long time = Long.MIN_VALUE;
        private long last_time = System.currentTimeMillis();

        public DynamicTimeKeep() {
            this.last_time = System.currentTimeMillis();
        }

        public DynamicTimeKeep(double speed) {
            this.speed = speed;
            this.last_time = System.currentTimeMillis();
        }

        public void update() {
            long diff = System.currentTimeMillis() - this.last_time;
            diff = (long)((double)diff * this.speed);
            this.time += diff;
            this.last_time = System.currentTimeMillis();
        }

        public float getFloat() {
            return (float)(this.time % 1000L) / 1000.0f;
        }

        public double getDouble() {
            return (double)(this.time % 1000L) / 1000.0;
        }

        public float getFloat(float offset) {
            long offsetTime = this.time + (long)(offset * 1000.0f);
            return (float)(offsetTime % 1000L) / 1000.0f;
        }

        public double getDouble(double offset) {
            long offsetTime = this.time + (long)(offset * 1000.0);
            return (float)(offsetTime % 1000L) / 1000.0f;
        }

        public void speedUp(double amount) {
            this.speed += amount;
        }

        public void slowDown(double amount) {
            this.speed -= amount;
        }
    }

    public static class CustomProgressBar {
        private final ResourceLocation texture;
        private final int height;
        private final int width;
        private final int framesU;
        private final int framesV;
        private final int mspf;
        public boolean animate = true;
        private int anim = 1;
        private long last_frame;
        private boolean started = false;

        public CustomProgressBar(ResourceLocation texture, int texWidth, int texHeight, int height, int width, int fps) {
            this.texture = texture;
            this.height = height;
            this.width = width;
            this.mspf = 1000 / fps;
            this.framesU = texHeight / height;
            this.framesV = texWidth / width;
        }

        public void blit(GuiGraphics gg, int x, int y, double progress) {
            if (!this.started) {
                this.started = true;
                this.last_frame = System.currentTimeMillis();
            }
            int u = this.anim / this.framesU;
            int v = this.anim % this.framesU;
            gg.m_280218_(this.texture, x, y, 0, 0, this.width, this.height);
            gg.m_280218_(this.texture, x, y, this.width * u, this.height * v, (int)((double)this.width * progress), this.height);
            if (System.currentTimeMillis() - this.last_frame > (long)this.mspf) {
                ++this.anim;
                this.last_frame = System.currentTimeMillis();
            }
            if (this.anim >= this.framesU * this.framesV || !this.animate) {
                this.anim = 1;
            }
        }
    }
}

