/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.client.renderer.blockentity.shell;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import whocraft.tardis_refined.client.TRShaders;
import whocraft.tardis_refined.client.model.blockentity.shell.ShellModel;
import whocraft.tardis_refined.client.model.blockentity.shell.ShellModelCollection;
import whocraft.tardis_refined.common.block.shell.GlobalShellBlock;
import whocraft.tardis_refined.common.block.shell.RootedShellBlock;
import whocraft.tardis_refined.common.block.shell.ShellBaseBlock;
import whocraft.tardis_refined.common.blockentity.shell.GlobalShellBlockEntity;
import whocraft.tardis_refined.patterns.ShellPattern;

public class GlobalShellRenderer
implements BlockEntityRenderer<GlobalShellBlockEntity>,
BlockEntityRendererProvider<GlobalShellBlockEntity> {
    public GlobalShellRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(GlobalShellBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        if (blockEntity.getTardisId() == null) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_252880_(0.5f, 1.5f, 0.5f);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        BlockState blockstate = blockEntity.m_58900_();
        float rotation = ((Direction)blockstate.m_61143_((Property)RootedShellBlock.FACING)).m_122435_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(rotation));
        ResourceLocation theme = blockEntity.theme();
        boolean isOpen = (Boolean)blockstate.m_61143_((Property)GlobalShellBlock.OPEN);
        float sine = 0.0f;
        if (((Boolean)blockstate.m_61143_((Property)ShellBaseBlock.REGEN)).booleanValue() && (sine = (float)(Math.sin(0.1 * (double)blockEntity.m_58904_().m_8044_()) * 1.0)) < 0.0f) {
            sine = 0.0f;
        }
        ShellPattern pattern = blockEntity.pattern();
        ShellModel currentModel = ShellModelCollection.getInstance().getShellEntry(theme).getShellModel(pattern);
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        BlockPos blockPos = blockEntity.m_58899_();
        Biome biome = (Biome)level.m_204166_(blockPos).m_203334_();
        Biome.Precipitation precipitation = biome.m_264600_(blockPos);
        boolean renderSnow = biome.m_264473_() && precipitation == Biome.Precipitation.SNOW;
        currentModel.renderShell(blockEntity, isOpen, true, poseStack, bufferSource.m_6299_(TRShaders.translucentWithSnow(currentModel.getShellTexture(pattern, false), renderSnow)), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        Boolean isRegenerating = (Boolean)blockstate.m_61143_((Property)ShellBaseBlock.REGEN);
        if (pattern.shellTexture().emissive()) {
            RenderType glowingRenderType = TRShaders.glow(currentModel.getShellTexture(pattern, true), 1.0f);
            VertexConsumer vertexConsumer = bufferSource.m_6299_(glowingRenderType);
            currentModel.renderShell(blockEntity, isOpen, false, poseStack, vertexConsumer, 0xF00000, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, isRegenerating != false ? sine : 1.0f);
        } else if (isRegenerating.booleanValue()) {
            RenderType glowingRenderTypeRegen = TRShaders.glow(currentModel.getShellTexture(pattern, false), 1.0f);
            VertexConsumer vertexConsumerRegen = bufferSource.m_6299_(glowingRenderTypeRegen);
            currentModel.renderShell(blockEntity, isOpen, false, poseStack, vertexConsumerRegen, 0xF00000, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, sine);
        }
        poseStack.m_85849_();
    }

    public boolean shouldRenderOffScreen(GlobalShellBlockEntity blockEntity) {
        return true;
    }

    public boolean shouldRender(GlobalShellBlockEntity blockEntity, Vec3 vec3) {
        return true;
    }

    public BlockEntityRenderer<GlobalShellBlockEntity> m_173570_(BlockEntityRendererProvider.Context context) {
        return new GlobalShellRenderer(context);
    }
}

