/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.client.screen.main;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexSorting;
import com.mojang.math.Axis;
import java.awt.Color;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import whocraft.tardis_refined.client.TardisClientData;
import whocraft.tardis_refined.client.model.blockentity.shell.ShellModel;
import whocraft.tardis_refined.client.model.blockentity.shell.ShellModelCollection;
import whocraft.tardis_refined.client.renderer.vortex.VortexRenderer;
import whocraft.tardis_refined.client.screen.ScreenHelper;
import whocraft.tardis_refined.client.screen.components.CommonTRWidgets;
import whocraft.tardis_refined.client.screen.components.SelectionListEntry;
import whocraft.tardis_refined.client.screen.screens.VortexSelectionScreen;
import whocraft.tardis_refined.common.VortexRegistry;
import whocraft.tardis_refined.common.blockentity.shell.GlobalShellBlockEntity;
import whocraft.tardis_refined.common.tardis.themes.ShellTheme;
import whocraft.tardis_refined.common.util.Platform;
import whocraft.tardis_refined.constants.ModMessages;
import whocraft.tardis_refined.patterns.ShellPattern;
import whocraft.tardis_refined.patterns.ShellPatterns;
import whocraft.tardis_refined.registry.TRBlockRegistry;

public class MonitorOS
extends Screen {
    public static ResourceLocation FRAME = new ResourceLocation("tardis_refined", "textures/gui/monitor/frame_brass.png");
    protected static final int frameWidth = 256;
    protected static final int frameHeight = 180;
    protected static final int monitorWidth = 230;
    protected static final int monitorHeight = 130;
    public final ResourceLocation backdrop;
    public static final VortexRenderer VORTEX = new VortexRenderer(VortexRegistry.CLOUDS.get());
    public static ResourceLocation currentVortex = VortexRegistry.VORTEX_DEFERRED_REGISTRY.getKey(VortexRegistry.CLOUDS.get());
    public static ResourceLocation NOISE = new ResourceLocation("tardis_refined", "textures/gui/monitor/noise.png");
    public static ResourceLocation SYMBLS = new ResourceLocation("tardis_refined", "textures/gui/monitor/gallifreyan_symbols.png");
    public MonitorOS LEFT;
    public MonitorOS RIGHT;
    public MonitorOS PREVIOUS;
    public static final ResourceLocation BUTTON_LOCATION = new ResourceLocation("tardis_refined", "textures/gui/sprites/save.png");
    public static final ResourceLocation BCK_LOCATION = new ResourceLocation("tardis_refined", "textures/gui/sprites/back.png");
    public int shakeX;
    public int shakeY;
    public int age;
    public int transitionStartTime = -1;
    public float shakeAlpha;
    private MonitorOSRun onSubmit;
    private MonitorOSRun onCancel;

    public MonitorOS(Component title, ResourceLocation backdrop) {
        super(title);
        this.backdrop = backdrop;
    }

    protected void m_7856_() {
        super.m_7856_();
        ObjectSelectionList<SelectionListEntry> list = this.createSelectionList();
        if (list != null) {
            this.m_142416_((GuiEventListener)list);
        }
    }

    public void m_280273_(GuiGraphics guiGraphics) {
    }

    public ResourceLocation getPatternForRender() {
        return null;
    }

    public void render2Background(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int hPos = (this.f_96543_ - 230) / 2;
        int vPos = (this.f_96544_ - 130) / 2;
        guiGraphics.m_280588_(0, 0, this.f_96543_, vPos + this.shakeY);
        guiGraphics.m_280024_(0, 0, this.f_96543_, this.f_96544_, -1072689136, -804253680);
        guiGraphics.m_280618_();
        guiGraphics.m_280588_(0, vPos + this.shakeY, hPos + this.shakeX, this.f_96544_ - vPos + this.shakeY);
        guiGraphics.m_280024_(0, 0, this.f_96543_, this.f_96544_, -1072689136, -804253680);
        guiGraphics.m_280618_();
        guiGraphics.m_280588_(this.f_96543_ - hPos + this.shakeX, vPos + this.shakeY, this.f_96543_, this.f_96544_ - vPos + this.shakeY);
        guiGraphics.m_280024_(0, 0, this.f_96543_, this.f_96544_, -1072689136, -804253680);
        guiGraphics.m_280618_();
        guiGraphics.m_280588_(0, this.f_96544_ - vPos + this.shakeY, this.f_96543_, this.f_96544_);
        guiGraphics.m_280024_(0, 0, this.f_96543_, this.f_96544_, -1072689136, -804253680);
        guiGraphics.m_280618_();
    }

    public void renderVortex(@NotNull GuiGraphics guiGraphics) {
        PoseStack poseStack = guiGraphics.m_280168_();
        int hPos = (this.f_96543_ - 230) / 2;
        int vPos = (this.f_96544_ - 130) / 2;
        guiGraphics.m_280588_(hPos + this.shakeX, vPos + this.shakeY, this.f_96543_ - hPos + this.shakeX, this.f_96544_ - vPos + this.shakeY);
        RenderSystem.backupProjectionMatrix();
        assert (this.f_96541_ != null);
        Matrix4f perspective = new Matrix4f();
        perspective.perspective((float)Math.toRadians(((Integer)this.f_96541_.f_91066_.m_231837_().m_231551_()).intValue()), (float)this.f_96543_ / (float)this.f_96544_, 0.0f, 9999.0f, false, perspective);
        perspective.translate(0.0f, 0.0f, Platform.isForge() ? 10000.0f : 11000.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)perspective, (VertexSorting)VertexSorting.f_276450_);
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(20.0f));
        assert (Minecraft.m_91087_().f_91073_ != null);
        TardisClientData tardisClientData = TardisClientData.getInstance((ResourceKey<Level>)Minecraft.m_91087_().f_91073_.m_46472_());
        MonitorOS.VORTEX.vortexType = VortexRegistry.VORTEX_DEFERRED_REGISTRY.get(this instanceof VortexSelectionScreen ? VortexSelectionScreen.currentVortex : tardisClientData.getVortex());
        MonitorOS.VORTEX.time.speed = 0.3;
        VORTEX.renderVortex(guiGraphics, 1.0f, false);
        RenderSystem.restoreProjectionMatrix();
        poseStack.m_85849_();
        guiGraphics.m_280618_();
    }

    public void renderBackdrop(@NotNull GuiGraphics guiGraphics) {
        if (this.backdrop == null) {
            return;
        }
        int hPos = (this.f_96543_ - 230) / 2;
        int vPos = (this.f_96544_ - 130) / 2;
        guiGraphics.m_280218_(this.backdrop, hPos, vPos, 0, 0, 230, 130);
        int b = this.f_96544_ - vPos;
        int r = this.f_96543_ - hPos;
        guiGraphics.m_280509_(hPos, vPos, r, b, 0x40000000);
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.render2Background(guiGraphics, mouseX, mouseY, partialTick);
        RenderSystem.enableBlend();
        this.renderVortex(guiGraphics);
        int hPos = (this.f_96543_ - 230) / 2;
        int vPos = (this.f_96544_ - 130) / 2;
        guiGraphics.m_280588_(hPos, vPos, this.f_96543_ - hPos, this.f_96544_ - vPos);
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)this.shakeX, (float)this.shakeY, 0.0f);
        int symb = 0;
        poseStack.m_85836_();
        poseStack.m_252880_((float)(hPos + 10), (float)(vPos + 10), 0.0f);
        poseStack.m_85841_(2.0f, 2.0f, 1.0f);
        poseStack.m_252781_(Axis.f_252403_.m_252977_((float)(System.currentTimeMillis() % 5400L) / 15.0f));
        poseStack.m_252880_(-15.5f, -15.5f, 0.0f);
        guiGraphics.m_280218_(SYMBLS, 0, 0, 32 * (symb % 8), 32 * (symb / 8), 32, 32);
        poseStack.m_85849_();
        symb = 3;
        poseStack.m_85836_();
        poseStack.m_252880_((float)(hPos + 230 - 10), (float)(vPos + 130 - 10), 0.0f);
        poseStack.m_85841_(2.0f, 2.0f, 1.0f);
        poseStack.m_252781_(Axis.f_252403_.m_252977_((float)(System.currentTimeMillis() % 5400L) / 15.0f));
        poseStack.m_252880_(-15.5f, -15.5f, 0.0f);
        guiGraphics.m_280218_(SYMBLS, 0, 0, 32 * (symb % 8), 32 * (symb / 8), 32, 32);
        poseStack.m_85849_();
        symb = 9;
        poseStack.m_85836_();
        poseStack.m_252880_((float)(hPos + 10), (float)(vPos + 130 - 10), 0.0f);
        poseStack.m_85841_(2.0f, 2.0f, 1.0f);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(-((float)(System.currentTimeMillis() % 5400L)) / 15.0f));
        poseStack.m_252880_(-15.5f, -15.5f, 0.0f);
        guiGraphics.m_280218_(SYMBLS, 0, 0, 32 * (symb % 8), 32 * (symb / 8), 32, 32);
        poseStack.m_85849_();
        symb = 8;
        poseStack.m_85836_();
        poseStack.m_252880_((float)(hPos + 230 - 10), (float)(vPos + 10), 0.0f);
        poseStack.m_85841_(2.0f, 2.0f, 1.0f);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(-((float)(System.currentTimeMillis() % 5400L)) / 15.0f));
        poseStack.m_252880_(-15.5f, -15.5f, 0.0f);
        guiGraphics.m_280218_(SYMBLS, 0, 0, 32 * (symb % 8), 32 * (symb / 8), 32, 32);
        poseStack.m_85849_();
        boolean right = this.RIGHT != null && this.PREVIOUS != null && this.RIGHT == this.PREVIOUS && this.transitionStartTime >= 0;
        boolean left = this.LEFT != null && this.PREVIOUS != null && this.LEFT == this.PREVIOUS && this.transitionStartTime >= 0;
        float t = ((float)(this.age - this.transitionStartTime) + partialTick) / 10.0f;
        float o = -0.5f * Mth.m_14089_((float)((float)Math.PI * t)) + 0.5f;
        if (right || left) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)o);
        }
        RenderSystem.enableBlend();
        this.renderBackdrop(guiGraphics);
        RenderSystem.enableBlend();
        if (right || left) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f - o));
        }
        if (right) {
            this.RIGHT.renderBackdrop(guiGraphics);
            poseStack.m_252880_(230.0f * o, 0.0f, 0.0f);
            this.RIGHT.doRender(guiGraphics, mouseX, mouseY, partialTick);
        }
        if (left) {
            this.LEFT.renderBackdrop(guiGraphics);
            poseStack.m_252880_(-230.0f * o, 0.0f, 0.0f);
            this.LEFT.doRender(guiGraphics, mouseX, mouseY, partialTick);
        }
        if (right || left) {
            poseStack.m_252880_(right ? -230.0f : 230.0f, 0.0f, 0.0f);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.doRender(guiGraphics, mouseX, mouseY, partialTick);
        poseStack.m_85849_();
        guiGraphics.m_280618_();
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)((this.shakeAlpha + 1.0f - partialTick) / 100.0f));
        guiGraphics.m_280218_(NOISE, hPos + this.shakeX, vPos + this.shakeY, (int)(Math.random() * 736.0), (int)((double)(414L * (System.currentTimeMillis() % 1000L)) / 1000.0), 230, 130);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderFrame(guiGraphics, mouseX, mouseY, partialTick);
        RenderSystem.disableBlend();
    }

    public void doRender(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.inMonitorRender(guiGraphics, mouseX, mouseY, partialTick);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        ScreenHelper.renderWidthScaledText(this.f_96539_.getString(), guiGraphics, Minecraft.m_91087_().f_91062_, (float)this.f_96543_ / 2.0f, 5.0f + (float)(this.f_96544_ - 130) / 2.0f, Color.LIGHT_GRAY.getRGB(), 300, true);
    }

    public void inMonitorRender(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    public void renderFrame(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int hPos = (this.f_96543_ - 256) / 2;
        int vPos = -13 + (this.f_96544_ - 130) / 2;
        guiGraphics.m_280218_(FRAME, hPos + this.shakeX, vPos + this.shakeY, 0, 0, 256, 180);
    }

    public void m_86600_() {
        super.m_86600_();
        ++this.age;
        if (this.transitionStartTime >= 0 && this.age - this.transitionStartTime >= 10) {
            this.transitionStartTime = -1;
        }
        if (this.f_96541_ == null || this.f_96541_.f_91073_ == null) {
            return;
        }
        boolean isCrashed = TardisClientData.getInstance((ResourceKey<Level>)this.f_96541_.f_91073_.m_46472_()).isCrashing();
        this.shakeAlpha -= 1.0f;
        if (isCrashed) {
            this.shakeAlpha = 50.0f;
        }
        if (this.shakeAlpha < 0.0f) {
            this.shakeAlpha = 0.0f;
        }
        if (this.shakeAlpha > 0.0f) {
            this.shakeX = (int)((double)this.shakeAlpha * (Math.random() - 0.5) * 0.5);
            this.shakeY = (int)((double)this.shakeAlpha * (Math.random() - 0.5) * 0.5);
        }
    }

    public void switchScreenToLeft(MonitorOS next) {
        this.LEFT = next;
        next.PREVIOUS = this;
        next.RIGHT = this;
        next.transition();
        Minecraft.m_91087_().m_91152_((Screen)next);
    }

    public void switchScreenToRight(MonitorOS next) {
        this.RIGHT = next;
        next.PREVIOUS = this;
        next.LEFT = this;
        next.transition();
        Minecraft.m_91087_().m_91152_((Screen)next);
    }

    public void transition() {
        this.transitionStartTime = this.age;
    }

    public void setEvents(MonitorOSRun onSubmit, MonitorOSRun onCancel) {
        this.onSubmit = onSubmit;
        this.onCancel = onCancel;
    }

    public Button addSubmitButton(int x, int y) {
        if (this.onSubmit != null) {
            Button spriteiconbutton = (Button)this.m_142416_((GuiEventListener)CommonTRWidgets.imageButton(20, Component.m_237115_((String)ModMessages.SUBMIT), arg -> this.onSubmit.onPress(), true, BUTTON_LOCATION));
            spriteiconbutton.m_264152_(x, y);
            return spriteiconbutton;
        }
        return null;
    }

    public void addCancelButton(int x, int y) {
        if (this.onCancel != null) {
            Button spriteiconbutton = (Button)this.m_142416_((GuiEventListener)CommonTRWidgets.imageButton(20, Component.m_237115_((String)"Cancel"), arg -> this.onCancel.onPress(), true, BCK_LOCATION));
            spriteiconbutton.m_264152_(x, y);
        }
    }

    public ObjectSelectionList<SelectionListEntry> createSelectionList() {
        return null;
    }

    public boolean m_7043_() {
        return false;
    }

    public static interface MonitorOSRun {
        public void onPress();
    }

    public static class MonitorOSExtension
    extends MonitorOS {
        public static GlobalShellBlockEntity GLOBALSHELL_BLOCKENTITY;
        public static ResourceLocation CURRENTSHELLTHEME;
        public static List<ResourceLocation> THEMELIST;
        public static List<ShellPattern> PATTERNCOLLECTION;

        public MonitorOSExtension(Component title, ResourceLocation currentShellThem) {
            super(title, null);
            CURRENTSHELLTHEME = currentShellThem;
            PATTERNCOLLECTION = ShellPatterns.getPatternCollectionForTheme(CURRENTSHELLTHEME);
            THEMELIST = ShellTheme.SHELL_THEME_DEFERRED_REGISTRY.keySet().stream().toList();
            MonitorOSExtension.generateDummyGlobalShell();
        }

        @Override
        protected void m_7856_() {
            super.m_7856_();
            if (CURRENTSHELLTHEME == null) {
                CURRENTSHELLTHEME = THEMELIST.get(0);
            }
        }

        public void renderShell(GuiGraphics guiGraphics, int x, int y, float scale) {
            ShellPattern pattern = ShellPatterns.getPatternOrDefault(CURRENTSHELLTHEME, this.getPatternForRender());
            ShellModel model = ShellModelCollection.getInstance().getShellEntry(CURRENTSHELLTHEME).getShellModel(pattern);
            model.setDoorPosition(false);
            Lighting.m_166384_();
            PoseStack pose = guiGraphics.m_280168_();
            pose.m_85836_();
            pose.m_252880_((float)x, (float)y, 100.0f);
            pose.m_85841_(-scale, scale, scale);
            pose.m_252781_(Axis.f_252529_.m_252977_(-15.0f));
            pose.m_252781_(Axis.f_252436_.m_252977_((float)(System.currentTimeMillis() % 5400L) / 15.0f));
            VertexConsumer vertexConsumer = guiGraphics.m_280091_().m_6299_(model.m_103119_(model.getShellTexture(pattern, false)));
            model.renderShell(GLOBALSHELL_BLOCKENTITY, false, false, pose, vertexConsumer, 0xF000F0, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            guiGraphics.m_280262_();
            pose.m_85849_();
            Lighting.m_84931_();
        }

        public static void generateDummyGlobalShell() {
            GLOBALSHELL_BLOCKENTITY = new GlobalShellBlockEntity(BlockPos.f_121853_, TRBlockRegistry.GLOBAL_SHELL_BLOCK.get().m_49966_());
            assert (Minecraft.m_91087_().f_91073_ != null);
            GLOBALSHELL_BLOCKENTITY.m_142339_((Level)Minecraft.m_91087_().f_91073_);
            ResourceKey generatedLevelKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("tardis_refined", UUID.randomUUID().toString()));
            GLOBALSHELL_BLOCKENTITY.setTardisId((ResourceKey<Level>)generatedLevelKey);
            GLOBALSHELL_BLOCKENTITY.setShellTheme(ShellTheme.POLICE_BOX.getId());
            GLOBALSHELL_BLOCKENTITY.setPattern(ShellPatterns.DEFAULT);
        }
    }
}

