/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.client.screen.screens;

import java.awt.Color;
import java.util.Collection;
import java.util.Comparator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import whocraft.tardis_refined.client.screen.ScreenHelper;
import whocraft.tardis_refined.client.screen.components.CommonTRWidgets;
import whocraft.tardis_refined.client.screen.components.GenericMonitorSelectionList;
import whocraft.tardis_refined.client.screen.components.SelectionListEntry;
import whocraft.tardis_refined.client.screen.main.MonitorOS;
import whocraft.tardis_refined.client.screen.waypoints.CoordInputType;
import whocraft.tardis_refined.common.network.messages.waypoints.C2SOpenCoordinatesDisplayMessage;
import whocraft.tardis_refined.common.network.messages.waypoints.C2SOpenEditCoordinatesDisplayMessage;
import whocraft.tardis_refined.common.network.messages.waypoints.C2SRemoveWaypointEntry;
import whocraft.tardis_refined.common.network.messages.waypoints.C2STravelToWaypoint;
import whocraft.tardis_refined.common.tardis.TardisWaypoint;
import whocraft.tardis_refined.constants.ModMessages;

public class WaypointListScreen
extends MonitorOS {
    public static final ResourceLocation TRASH_LOCATION = new ResourceLocation("tardis_refined", "textures/gui/sprites/trash.png");
    public static final ResourceLocation OKAY_TEXTURE = new ResourceLocation("tardis_refined", "textures/gui/sprites/okay.png");
    public static final ResourceLocation EDIT_TEXTURE = new ResourceLocation("tardis_refined", "textures/gui/sprites/edit.png");
    private final Component noWaypointsLabel = Component.m_237115_((String)ModMessages.UI_MONITOR_NO_WAYPOINTS);
    private Button loadButton;
    private Button editButton;
    private Button trashButton;
    private final Collection<TardisWaypoint> WAYPOINTS;
    private TardisWaypoint waypoint = null;

    public WaypointListScreen(Collection<TardisWaypoint> waypoints) {
        super((Component)Component.m_237115_((String)ModMessages.UI_MONITOR_MAIN_TITLE), new ResourceLocation("tardis_refined", "textures/gui/monitor/backdrop.png"));
        this.WAYPOINTS = waypoints;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.setEvents(() -> {
            if (this.waypoint != null) {
                new C2STravelToWaypoint(this.waypoint.getId()).send();
            }
        }, () -> {
            if (this.waypoint != null) {
                new C2SRemoveWaypointEntry(this.waypoint.getId()).send();
            }
            this.switchScreenToLeft(this.PREVIOUS);
        });
        Button newWaypointButton = (Button)this.m_142416_((GuiEventListener)CommonTRWidgets.imageButton(20, Component.m_237115_((String)"Submit"), arg -> new C2SOpenCoordinatesDisplayMessage(CoordInputType.WAYPOINT).send(), true, BUTTON_LOCATION));
        newWaypointButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)ModMessages.UI_MONITOR_WAYPOINT_CREATE)));
        newWaypointButton.m_264152_(this.f_96543_ / 2 + 85, this.f_96544_ / 2 - 60);
        int vPos = (this.f_96544_ - 130) / 2;
        this.addCancelButton(this.f_96543_ / 2 - 105, this.f_96544_ - vPos - 25);
        this.loadButton = (Button)this.m_142416_((GuiEventListener)CommonTRWidgets.imageButton(20, Component.m_237115_((String)"Submit"), arg -> {
            if (this.waypoint != null) {
                new C2STravelToWaypoint(this.waypoint.getId()).send();
                Minecraft.m_91087_().m_91152_(null);
            }
        }, true, OKAY_TEXTURE));
        this.loadButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)ModMessages.UI_MONITOR_WAYPOINT_LOAD)));
        this.loadButton.m_264152_(this.f_96543_ / 2 + 85, this.f_96544_ / 2);
        this.loadButton.f_93623_ = false;
        this.editButton = (Button)this.m_142416_((GuiEventListener)CommonTRWidgets.imageButton(20, Component.m_237115_((String)"Edit"), arg -> {
            if (this.waypoint != null) {
                new C2SOpenEditCoordinatesDisplayMessage(this.waypoint.getId()).send();
                Minecraft.m_91087_().m_91152_(null);
            }
        }, true, EDIT_TEXTURE));
        this.editButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)ModMessages.UI_MONITOR_WAYPOINT_EDIT)));
        this.editButton.m_264152_(this.f_96543_ / 2 + 85, this.f_96544_ / 2 - 40);
        this.editButton.f_93623_ = false;
        this.trashButton = (Button)this.m_142416_((GuiEventListener)CommonTRWidgets.imageButton(20, Component.m_237115_((String)"Submit"), arg -> new C2SRemoveWaypointEntry(this.waypoint.getId()).send(), true, TRASH_LOCATION));
        this.trashButton.m_264152_(this.f_96543_ / 2 + 85, this.f_96544_ / 2 - 20);
        this.trashButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)ModMessages.UI_MONITOR_WAYPOINT_DELETE)));
        this.trashButton.f_93623_ = false;
    }

    public GenericMonitorSelectionList<SelectionListEntry> createSelectionList() {
        int vPos = (this.f_96544_ - 130) / 2;
        int leftPos = this.f_96543_ / 2 - 75;
        GenericMonitorSelectionList<SelectionListEntry> selectionList = new GenericMonitorSelectionList<SelectionListEntry>(this.f_96541_, 150, 80, leftPos, vPos + 15, vPos + 130 - 30, 12);
        selectionList.m_93488_(false);
        Collection<TardisWaypoint> values = this.WAYPOINTS;
        values = values.stream().sorted(Comparator.comparing(TardisWaypoint::getName)).toList();
        for (TardisWaypoint waypointEntry : values) {
            selectionList.m_6702_().add(new SelectionListEntry((Component)Component.m_237113_((String)waypointEntry.getLocation().getName()), entry -> {
                entry.setChecked(true);
                this.waypoint = waypointEntry;
                this.loadButton.f_93623_ = true;
                this.editButton.f_93623_ = true;
                this.trashButton.f_93623_ = true;
                for (SelectionListEntry child : selectionList.m_6702_()) {
                    if (child == entry) continue;
                    child.setChecked(false);
                }
            }, leftPos));
        }
        return selectionList;
    }

    @Override
    public void inMonitorRender(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int textOffset = this.f_96544_ / 2 - 60;
        int textScale = 40;
        if (this.WAYPOINTS.isEmpty()) {
            ScreenHelper.renderWidthScaledText(this.noWaypointsLabel.getString(), guiGraphics, Minecraft.m_91087_().f_91062_, (float)this.f_96543_ / 2.0f - 96.0f, textOffset + 15, Color.LIGHT_GRAY.getRGB(), textScale * 2, 1.0f, false);
        }
    }
}

