/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.client.screen.screens;

import java.awt.Color;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import whocraft.tardis_refined.client.screen.ScreenHelper;
import whocraft.tardis_refined.client.screen.main.MonitorOS;
import whocraft.tardis_refined.client.screen.waypoints.CoordInputType;
import whocraft.tardis_refined.common.network.messages.waypoints.C2SEditWaypoint;
import whocraft.tardis_refined.common.network.messages.waypoints.C2SRequestWaypoints;
import whocraft.tardis_refined.common.network.messages.waypoints.C2SUploadWaypoint;
import whocraft.tardis_refined.common.tardis.TardisNavLocation;
import whocraft.tardis_refined.common.tardis.TardisWaypoint;
import whocraft.tardis_refined.common.util.MiscHelper;
import whocraft.tardis_refined.constants.ModMessages;

public class WaypointManageScreen
extends MonitorOS {
    private final CoordInputType coordInputType;
    protected EditBox waypointName;
    private TardisWaypoint preExistingWaypoint = null;
    private final TardisNavLocation tardisNavLocation;
    private Button onSaveWaypoint;

    public WaypointManageScreen(List<ResourceKey<Level>> ignoredWorlds, CoordInputType coordInputType, TardisNavLocation tardisNavLocation) {
        super((Component)Component.m_237115_((String)(coordInputType == CoordInputType.WAYPOINT ? ModMessages.UI_MONITOR_UPLOAD_WAYPOINTS : ModMessages.UI_MONITOR_UPLOAD_COORDS)), new ResourceLocation("tardis_refined", "textures/gui/monitor/backdrop.png"));
        this.coordInputType = coordInputType;
        this.tardisNavLocation = tardisNavLocation;
        tardisNavLocation.setName("Waypoint");
        this.setEvents(() -> {}, () -> new C2SRequestWaypoints().send());
    }

    public WaypointManageScreen(TardisWaypoint waypoint) {
        super((Component)Component.m_237115_((String)"Edit waypoint"), new ResourceLocation("tardis_refined", "textures/gui/monitor/backdrop.png"));
        this.preExistingWaypoint = waypoint;
        this.tardisNavLocation = waypoint.getLocation();
        this.coordInputType = CoordInputType.WAYPOINT;
        this.setEvents(() -> {}, () -> new C2SRequestWaypoints().send());
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        int widgetHeight = 20;
        int waypointNameWidth = 115;
        int waypointNameHeight = this.f_96544_ / 2;
        int yPosition = this.f_96544_ / 2;
        int xPosition = this.f_96543_ / 2 - waypointNameWidth / 2;
        yPosition += 30;
        this.onSaveWaypoint = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)ModMessages.SUBMIT), arg -> {
            if (this.preExistingWaypoint != null) {
                this.tardisNavLocation.setName(this.waypointName.m_94155_());
                this.preExistingWaypoint.setLocation(this.tardisNavLocation);
                new C2SEditWaypoint(this.preExistingWaypoint).send();
                new C2SRequestWaypoints().send();
            } else {
                new C2SUploadWaypoint(this.tardisNavLocation, this.coordInputType).send();
                new C2SRequestWaypoints().send();
            }
        }).m_253136_());
        if (this.coordInputType == CoordInputType.WAYPOINT) {
            this.waypointName = new EditBox(this.f_96547_, xPosition, waypointNameHeight, waypointNameWidth, widgetHeight, this.waypointName, (Component)Component.m_237115_((String)"selectWorld.search"));
            if (this.preExistingWaypoint != null) {
                this.waypointName.m_94144_(this.preExistingWaypoint.getLocation().getName());
            } else {
                this.waypointName.m_94167_(Component.m_237115_((String)"monitor.waypoints.name.placeholder").getString());
            }
            this.waypointName.m_94151_(string -> {
                if (!string.isEmpty()) {
                    this.tardisNavLocation.setName((String)string);
                    this.waypointName.m_94167_("");
                }
            });
            this.m_7787_((GuiEventListener)this.waypointName);
            this.onSaveWaypoint.m_264152_(xPosition, yPosition);
            this.onSaveWaypoint.m_93674_(120);
            this.m_7787_((GuiEventListener)this.onSaveWaypoint);
            int vPos = (this.f_96544_ - 130) / 2;
            this.addCancelButton(this.f_96543_ / 2 - 105, this.f_96544_ - vPos - 25);
        }
    }

    @Override
    public void inMonitorRender(@NotNull GuiGraphics guiGraphics, int i, int j, float f) {
        if (this.coordInputType == CoordInputType.WAYPOINT) {
            this.waypointName.m_88315_(guiGraphics, i, j, f);
        }
        this.onSaveWaypoint.f_93623_ = !this.waypointName.m_94155_().isEmpty();
        this.onSaveWaypoint.m_88315_(guiGraphics, i, j, f);
        int headerHeight = this.f_96544_ / 2 - 43;
        int starterCordHeight = this.f_96544_ / 2 - 43 + 7;
        int centerX = this.f_96543_ / 2;
        String baseDirection = this.tardisNavLocation.getDirection().m_122433_();
        String direction = baseDirection.substring(0, 1).toUpperCase() + baseDirection.substring(1);
        String dimensionName = MiscHelper.getCleanDimensionName(this.tardisNavLocation.getDimensionKey());
        ScreenHelper.renderWidthScaledText(Component.m_237115_((String)"monitor.waypoints.new_waypoint").getString(), guiGraphics, Minecraft.m_91087_().f_91062_, centerX, headerHeight, Color.LIGHT_GRAY.getRGB(), 80, 1.0f, true);
        if (this.preExistingWaypoint == null) {
            ScreenHelper.renderWidthScaledText(Component.m_237115_((String)"monitor.waypoints.taken").getString(), guiGraphics, Minecraft.m_91087_().f_91062_, centerX, headerHeight + 10, Color.LIGHT_GRAY.getRGB(), 80, 1.0f, true);
        }
        ScreenHelper.renderWidthScaledText(this.tardisNavLocation.getPosition().m_123344_(), guiGraphics, Minecraft.m_91087_().f_91062_, centerX, starterCordHeight + 15, Color.white.getRGB(), 80, 1.0f, true);
        ScreenHelper.renderWidthScaledText(direction + ", " + dimensionName, guiGraphics, Minecraft.m_91087_().f_91062_, centerX, starterCordHeight + 25, Color.white.getRGB(), 100, 1.0f, true);
    }

    public boolean m_7933_(int i, int j, int k) {
        return super.m_7933_(i, j, k);
    }

    public boolean m_5534_(char c, int i) {
        return super.m_5534_(c, i);
    }
}

