/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.command.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import whocraft.tardis_refined.common.tardis.TardisDesktops;
import whocraft.tardis_refined.common.tardis.themes.DesktopTheme;
import whocraft.tardis_refined.constants.ModMessages;

public class DesktopArgumentType
implements ArgumentType<ResourceLocation> {
    public static final DynamicCommandExceptionType INVALID_DESKTOP_EXCEPTION = new DynamicCommandExceptionType(desktop -> Component.m_237110_((String)ModMessages.CMD_ARG_DESKTOP_INVALID, (Object[])new Object[]{desktop}));
    private static final Collection<String> EXAMPLES = Stream.of(TardisDesktops.FACTORY_THEME, TardisDesktops.DEFAULT_OVERGROWN_THEME).map(desktop -> desktop != null ? desktop.getIdentifier().toString() : "").collect(Collectors.toList());

    public static DesktopArgumentType desktopArgumentType() {
        return new DesktopArgumentType();
    }

    public static DesktopTheme getDesktop(CommandContext<CommandSourceStack> context, String name) throws CommandSyntaxException {
        ResourceLocation resourcelocation = (ResourceLocation)context.getArgument(name, ResourceLocation.class);
        DesktopTheme desktop = TardisDesktops.getRegistry().get(resourcelocation);
        if (desktop == null) {
            throw INVALID_DESKTOP_EXCEPTION.create((Object)resourcelocation);
        }
        return desktop;
    }

    public ResourceLocation parse(StringReader reader) throws CommandSyntaxException {
        return ResourceLocation.m_135818_((StringReader)reader);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        Set<ResourceLocation> desktops = TardisDesktops.getRegistry().keySet();
        return SharedSuggestionProvider.m_82926_(desktops, (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

