/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.command.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import whocraft.tardis_refined.common.tardis.themes.ShellTheme;
import whocraft.tardis_refined.constants.ModMessages;

public class ShellArgumentType
implements ArgumentType<ResourceLocation> {
    public static final DynamicCommandExceptionType INVALID_SHELL_EXCEPTION = new DynamicCommandExceptionType(shell -> Component.m_237110_((String)ModMessages.CMD_ARG_SHELL_INVALID, (Object[])new Object[]{shell}));
    private static final Collection<String> EXAMPLES = Stream.of(ShellTheme.FACTORY.get(), ShellTheme.POLICE_BOX.get()).map(shell -> shell != null ? ShellTheme.SHELL_THEME_DEFERRED_REGISTRY.getKey((ShellTheme)shell).toString() : "").collect(Collectors.toList());

    public static ShellArgumentType shellArgumentType() {
        return new ShellArgumentType();
    }

    public static ShellTheme getShell(CommandContext<CommandSourceStack> context, String name) throws CommandSyntaxException {
        ResourceLocation resourcelocation = (ResourceLocation)context.getArgument(name, ResourceLocation.class);
        ShellTheme shellTheme = ShellTheme.SHELL_THEME_DEFERRED_REGISTRY.get(resourcelocation);
        if (shellTheme == null) {
            throw INVALID_SHELL_EXCEPTION.create((Object)resourcelocation);
        }
        return shellTheme;
    }

    public static ResourceLocation getShellId(CommandContext<CommandSourceStack> context, String name) throws CommandSyntaxException {
        ResourceLocation resourcelocation = (ResourceLocation)context.getArgument(name, ResourceLocation.class);
        if (ShellTheme.SHELL_THEME_DEFERRED_REGISTRY.get(resourcelocation) == null) {
            throw INVALID_SHELL_EXCEPTION.create((Object)resourcelocation);
        }
        return resourcelocation;
    }

    public ResourceLocation parse(StringReader reader) throws CommandSyntaxException {
        return ResourceLocation.m_135818_((StringReader)reader);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_82926_(ShellTheme.SHELL_THEME_DEFERRED_REGISTRY.keySet(), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

