/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.command.sub;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.capability.tardis.upgrades.UpgradeHandler;
import whocraft.tardis_refined.common.util.CommandHelper;
import whocraft.tardis_refined.common.util.TardisHelper;
import whocraft.tardis_refined.constants.ModMessages;

public class LevelCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"level").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"points").then(Commands.m_82127_((String)"get").then(Commands.m_82129_((String)"tardis", (ArgumentType)DimensionArgument.m_88805_()).suggests(CommandHelper.SUGGEST_TARDISES).executes(LevelCommand::getDimensionPoints)))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"tardis", (ArgumentType)DimensionArgument.m_88805_()).suggests(CommandHelper.SUGGEST_TARDISES).executes(LevelCommand::setDimensionPoints))))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"tardis", (ArgumentType)DimensionArgument.m_88805_()).suggests(CommandHelper.SUGGEST_TARDISES).executes(LevelCommand::addDimensionPoints)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"xp").then(Commands.m_82127_((String)"get").then(Commands.m_82129_((String)"tardis", (ArgumentType)DimensionArgument.m_88805_()).suggests(CommandHelper.SUGGEST_TARDISES).executes(LevelCommand::getDimensionXp)))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"tardis", (ArgumentType)DimensionArgument.m_88805_()).suggests(CommandHelper.SUGGEST_TARDISES).executes(LevelCommand::setDimensionXp))))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"tardis", (ArgumentType)DimensionArgument.m_88805_()).suggests(CommandHelper.SUGGEST_TARDISES).executes(LevelCommand::addDimensionXp)))));
    }

    private static int getDimensionPoints(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerLevel dimension = DimensionArgument.m_88808_(context, (String)"tardis");
        MutableComponent tardisId = TardisHelper.createTardisIdComponent(dimension.m_46472_().m_135782_());
        TardisLevelOperator.get(dimension).ifPresent(tardisLevelOperator -> {
            int points = tardisLevelOperator.getUpgradeHandler().getUpgradePoints();
            ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237110_((String)ModMessages.CMD_LEVEL_POINT_GET, (Object[])new Object[]{tardisId, points}));
        });
        return 1;
    }

    private static int setDimensionPoints(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        ServerLevel dimension = DimensionArgument.m_88808_(context, (String)"tardis");
        MutableComponent tardisId = TardisHelper.createTardisIdComponent(dimension.m_46472_().m_135782_());
        TardisLevelOperator.get(dimension).ifPresent(tardisLevelOperator -> {
            UpgradeHandler upgradeHandler = tardisLevelOperator.getUpgradeHandler();
            upgradeHandler.setUpgradePoints(amount);
            int points = upgradeHandler.getUpgradePoints();
            ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237110_((String)ModMessages.CMD_LEVEL_POINT_SET, (Object[])new Object[]{tardisId, points}));
        });
        return 1;
    }

    private static int addDimensionPoints(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        ServerLevel dimension = DimensionArgument.m_88808_(context, (String)"tardis");
        MutableComponent tardisId = TardisHelper.createTardisIdComponent(dimension.m_46472_().m_135782_());
        TardisLevelOperator.get(dimension).ifPresent(tardisLevelOperator -> {
            UpgradeHandler upgradeHandler = tardisLevelOperator.getUpgradeHandler();
            upgradeHandler.setUpgradePoints(upgradeHandler.getUpgradePoints() + amount);
            int points = upgradeHandler.getUpgradePoints();
            ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237110_((String)ModMessages.CMD_LEVEL_POINT_ADD, (Object[])new Object[]{amount, tardisId, points}));
        });
        return 1;
    }

    private static int addDimensionXp(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        ServerLevel dimension = DimensionArgument.m_88808_(context, (String)"tardis");
        MutableComponent tardisId = TardisHelper.createTardisIdComponent(dimension.m_46472_().m_135782_());
        TardisLevelOperator.get(dimension).ifPresent(tardisLevelOperator -> {
            UpgradeHandler upgradeHandler = tardisLevelOperator.getUpgradeHandler();
            upgradeHandler.setUpgradeXP(upgradeHandler.getUpgradeXP() + amount);
            int xp = upgradeHandler.getUpgradeXP();
            ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237110_((String)ModMessages.CMD_LEVEL_XP_ADD, (Object[])new Object[]{amount, tardisId, xp}));
        });
        return 1;
    }

    private static int getDimensionXp(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerLevel dimension = DimensionArgument.m_88808_(context, (String)"tardis");
        MutableComponent tardisId = TardisHelper.createTardisIdComponent(dimension.m_46472_().m_135782_());
        TardisLevelOperator.get(dimension).ifPresent(tardisLevelOperator -> {
            int xp = tardisLevelOperator.getUpgradeHandler().getUpgradeXP();
            ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237110_((String)ModMessages.CMD_LEVEL_XP_GET, (Object[])new Object[]{tardisId, xp}));
        });
        return 1;
    }

    private static int setDimensionXp(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        ServerLevel dimension = DimensionArgument.m_88808_(context, (String)"tardis");
        MutableComponent tardisId = TardisHelper.createTardisIdComponent(dimension.m_46472_().m_135782_());
        TardisLevelOperator.get(dimension).ifPresent(tardisLevelOperator -> {
            tardisLevelOperator.getUpgradeHandler().setUpgradeXP(amount);
            int xp = tardisLevelOperator.getUpgradeHandler().getUpgradeXP();
            ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237110_((String)ModMessages.CMD_LEVEL_XP_SET, (Object[])new Object[]{tardisId, xp}));
        });
        return 1;
    }
}

