/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.command.sub.export;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.nio.file.Path;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ComponentArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.storage.LevelResource;
import whocraft.tardis_refined.common.tardis.themes.DesktopTheme;
import whocraft.tardis_refined.common.util.CommandHelper;
import whocraft.tardis_refined.common.util.DatapackHelper;
import whocraft.tardis_refined.common.util.PlayerUtil;
import whocraft.tardis_refined.constants.ModMessages;
import whocraft.tardis_refined.mixin.MinecraftServerStorageAccessor;

public class ExportDesktopCommand
implements Command<CommandSourceStack> {
    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return Commands.m_82127_((String)"desktop").then(Commands.m_82129_((String)"pos1", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"pos2", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"include_entities", (ArgumentType)BoolArgumentType.bool()).then(Commands.m_82129_((String)"namespace", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"desktop_id", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"datapack_name", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"desktop_display_name", (ArgumentType)ComponentArgument.m_87114_()).executes(context -> ExportDesktopCommand.exportDesktop((CommandContext<CommandSourceStack>)context, BlockPosArgument.m_174395_((CommandContext)context, (String)"pos1"), BlockPosArgument.m_174395_((CommandContext)context, (String)"pos2"), BoolArgumentType.getBool((CommandContext)context, (String)"include_entities"), StringArgumentType.getString((CommandContext)context, (String)"namespace").toLowerCase(), StringArgumentType.getString((CommandContext)context, (String)"desktop_id").toLowerCase(), StringArgumentType.getString((CommandContext)context, (String)"datapack_name").toLowerCase(), ComponentArgument.m_87117_((CommandContext)context, (String)"desktop_display_name"))))))))));
    }

    private static int exportDesktop(CommandContext<CommandSourceStack> context, BlockPos bottomCorner, BlockPos topCorner, boolean includeEntities, String namespace, String desktopId, String datapackName, Component displayName) {
        ResourceLocation loc = new ResourceLocation(namespace, desktopId);
        DesktopTheme theme = new DesktopTheme(loc, loc, Component.Serializer.m_130703_((Component)displayName));
        ServerPlayer sender = ((CommandSourceStack)context.getSource()).m_230896_();
        MinecraftServerStorageAccessor accessor = (MinecraftServerStorageAccessor)((CommandSourceStack)context.getSource()).m_81377_();
        Path rootDir = accessor.getStorageSource().m_78283_(LevelResource.f_78180_).normalize();
        Path datapackRoot = rootDir.resolve(datapackName);
        PlayerUtil.sendMessage((LivingEntity)sender, (Component)Component.m_237110_((String)ModMessages.CMD_EXPORT_DESKTOP_IN_PROGRESS, (Object[])new Object[]{loc}), false);
        boolean exported = DatapackHelper.writeDesktopToFile(((CommandSourceStack)context.getSource()).m_81372_(), bottomCorner, topCorner, includeEntities, loc, theme, datapackName);
        if (exported) {
            MutableComponent path = CommandHelper.createComponentOpenFile(datapackName, datapackRoot.toString());
            MutableComponent reloadCommandSuggestion = CommandHelper.createComponentSuggestCommand("/reload", "/reload");
            MutableComponent githubReleasePage = CommandHelper.createComponentOpenUrl("Tardis Refined Github Release Page", ModMessages.GITHUB_RELEASE_PAGE);
            PlayerUtil.sendMessage((LivingEntity)sender, (Component)Component.m_237110_((String)ModMessages.CMD_EXPORT_DESKTOP_SUCCESS, (Object[])new Object[]{loc, path, reloadCommandSuggestion}), false);
            PlayerUtil.sendMessage((LivingEntity)sender, (Component)Component.m_237110_((String)ModMessages.CMD_EXPORT_DESKTOP_RESOURCE_PACK, (Object[])new Object[]{githubReleasePage}), false);
            return 1;
        }
        PlayerUtil.sendMessage((LivingEntity)sender, (Component)Component.m_237110_((String)ModMessages.CMD_EXPORT_DESKTOP_FAIL, (Object[])new Object[]{loc}), false);
        return 0;
    }

    public int run(CommandContext<CommandSourceStack> context) {
        return 0;
    }
}

