/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.blockentity.device;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import whocraft.tardis_refined.common.block.device.AstralManipulatorBlock;
import whocraft.tardis_refined.common.crafting.astral_manipulator.ManipulatorBlockResult;
import whocraft.tardis_refined.common.crafting.astral_manipulator.ManipulatorCraftingIngredient;
import whocraft.tardis_refined.common.crafting.astral_manipulator.ManipulatorCraftingRecipe;
import whocraft.tardis_refined.common.crafting.astral_manipulator.ManipulatorCraftingResult;
import whocraft.tardis_refined.common.crafting.astral_manipulator.ManipulatorItemResult;
import whocraft.tardis_refined.common.items.ScrewdriverItem;
import whocraft.tardis_refined.common.items.ScrewdriverMode;
import whocraft.tardis_refined.common.util.PlayerUtil;
import whocraft.tardis_refined.constants.ModMessages;
import whocraft.tardis_refined.registry.TRBlockEntityRegistry;
import whocraft.tardis_refined.registry.TRSoundRegistry;

public class AstralManipulatorBlockEntity
extends BlockEntity {
    public static final String MAN_POINT_A = "man_point_a";
    public static final String MAN_POINT_B = "man_point_b";
    public static final String SHOULD_DISPLAY = "should_display";
    private boolean shouldDisplay = false;
    private BlockPos pointABlockPos;
    private BlockPos pointBBlockPos;

    public AstralManipulatorBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(TRBlockEntityRegistry.ASTRAL_MANIPULATOR.get(), blockPos, blockState);
    }

    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        compoundTag.m_128379_(SHOULD_DISPLAY, this.shouldDisplay);
        if (this.pointABlockPos != null) {
            compoundTag.m_128365_(MAN_POINT_A, (Tag)NbtUtils.m_129224_((BlockPos)this.pointABlockPos));
        }
        if (this.pointBBlockPos != null) {
            compoundTag.m_128365_(MAN_POINT_B, (Tag)NbtUtils.m_129224_((BlockPos)this.pointBBlockPos));
        }
    }

    public BlockPos getPointABlockPos() {
        return this.pointABlockPos;
    }

    public BlockPos getPointBBlockPos() {
        return this.pointBBlockPos;
    }

    public void setShouldDisplay(boolean display) {
        this.shouldDisplay = display;
        this.pointABlockPos = this.m_58899_();
        this.pointBBlockPos = this.m_58899_();
        BlockState blockState = this.f_58857_.m_8055_(this.m_58899_());
        if (blockState.m_60734_() instanceof AstralManipulatorBlock) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)blockState.m_61124_((Property)AstralManipulatorBlock.POWERED, (Comparable)Boolean.valueOf(display)), 3);
        }
        this.sendUpdates();
    }

    public boolean shouldDisplay() {
        return this.shouldDisplay;
    }

    public void clearDisplay() {
        this.setShouldDisplay(false);
        this.pointABlockPos = this.m_58899_();
        this.pointBBlockPos = this.m_58899_();
        this.sendUpdates();
    }

    public void m_142466_(CompoundTag tag) {
        if (tag.m_128441_(MAN_POINT_A)) {
            this.pointABlockPos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_(MAN_POINT_A));
        }
        if (tag.m_128441_(MAN_POINT_B)) {
            this.pointBBlockPos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_(MAN_POINT_B));
        }
        if (tag.m_128441_(SHOULD_DISPLAY)) {
            this.shouldDisplay = tag.m_128471_(SHOULD_DISPLAY);
        }
        super.m_142466_(tag);
    }

    public void onRightClick(ItemStack itemStack, Player player) {
        Item item = itemStack.m_41720_();
        if (item instanceof ScrewdriverItem) {
            ScrewdriverItem screwdriverItem = (ScrewdriverItem)item;
            if (!screwdriverItem.isScrewdriverMode(itemStack, ScrewdriverMode.DRAWING)) {
                screwdriverItem.setScrewdriverMode(player, itemStack, ScrewdriverMode.DRAWING, this.m_58899_(), null);
                this.setShouldDisplay(true);
                PlayerUtil.sendMessage((LivingEntity)player, (Component)Component.m_237115_((String)ModMessages.ASTRAL_MANIPULATOR_ENGAGED), true);
                Level level = this.m_58904_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    screwdriverItem.playScrewdriverSound(serverLevel, this.m_58899_(), TRSoundRegistry.SCREWDRIVER_CONNECT.get());
                }
            } else {
                List<BlockPos> points = screwdriverItem.getScrewdriverPoint(itemStack);
                screwdriverItem.setScrewdriverMode(player, itemStack, ScrewdriverMode.DISABLED, this.m_58899_(), null);
                if (points.size() == 2) {
                    BlockPos pointB;
                    BlockPos pointA = points.get(0);
                    if (this.attemptToBuild(pointA, pointB = points.get(1))) {
                        this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_12275_, SoundSource.BLOCKS, 1.0f, 1.25f);
                    } else {
                        this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_215675_, SoundSource.BLOCKS, 1.0f, 0.3f);
                    }
                    screwdriverItem.clearBlockPosFromScrewdriver(itemStack);
                    this.clearDisplay();
                }
                this.clearDisplay();
            }
        }
    }

    public boolean setProjectionBlockPos(BlockPos pos, boolean isPointA) {
        if (!this.shouldDisplay) {
            return false;
        }
        if (isPointA) {
            this.pointABlockPos = pos;
        } else {
            this.pointBBlockPos = pos;
        }
        if (this.checkIfDistanceIsTooGreat(pos)) {
            this.clearDisplay();
            this.sendUpdates();
            return false;
        }
        this.sendUpdates();
        return true;
    }

    private boolean checkIfDistanceIsTooGreat(BlockPos pos) {
        int distance = pos.m_123333_((Vec3i)this.m_58899_());
        return distance > 25;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void sendUpdates() {
        this.f_58857_.m_7260_(this.m_58899_(), this.f_58857_.m_8055_(this.m_58899_()), this.f_58857_.m_8055_(this.m_58899_()), 2);
        this.m_6596_();
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    private boolean attemptToBuild(BlockPos pointA, BlockPos pointB) {
        ArrayList<ManipulatorCraftingIngredient> submittedBlocks = new ArrayList<ManipulatorCraftingIngredient>();
        float xDiff = Math.abs(pointA.m_123341_() - pointB.m_123341_());
        float yDiff = Math.abs(pointA.m_123342_() - pointB.m_123342_());
        float zDiff = Math.abs(pointA.m_123343_() - pointB.m_123343_());
        int smallestPointX = Math.min(pointA.m_123341_(), pointB.m_123341_());
        int smallestPointY = Math.min(pointA.m_123342_(), pointB.m_123342_());
        int smallestPointZ = Math.min(pointA.m_123343_(), pointB.m_123343_());
        BlockPos minPoint = new BlockPos(smallestPointX, smallestPointY, smallestPointZ);
        int y = 0;
        while ((float)y < yDiff + 1.0f) {
            int x2 = 0;
            while ((float)x2 < xDiff + 1.0f) {
                int z = 0;
                while ((float)z < zDiff + 1.0f) {
                    BlockPos blockPosInWorld = new BlockPos(minPoint.m_123341_() + x2, minPoint.m_123342_() + y, minPoint.m_123343_() + z);
                    submittedBlocks.add(new ManipulatorCraftingIngredient(new BlockPos(x2, y, z), this.f_58857_.m_8055_(blockPosInWorld)));
                    ++z;
                }
                ++x2;
            }
            ++y;
        }
        Optional<ManipulatorCraftingIngredient> firstBlock = submittedBlocks.stream().filter(x -> x.relativeBlockPos().m_123341_() == 0 && x.relativeBlockPos().m_123342_() == 0 && x.relativeBlockPos().m_123343_() == 0).findFirst();
        if (firstBlock.isEmpty()) {
            return false;
        }
        ArrayList<ManipulatorCraftingRecipe> possibleRecipes = new ArrayList<ManipulatorCraftingRecipe>();
        for (ManipulatorCraftingRecipe recipe : ManipulatorCraftingRecipe.getAllRecipes(this.m_58904_())) {
            Optional<ManipulatorCraftingIngredient> zeroPos = recipe.ingredients().stream().filter(x -> x.relativeBlockPos().m_123341_() == 0 && x.relativeBlockPos().m_123342_() == 0 && x.relativeBlockPos().m_123343_() == 0).findFirst();
            if (!zeroPos.isPresent() || zeroPos.get().inputBlockState().m_60734_() != firstBlock.get().inputBlockState().m_60734_()) continue;
            possibleRecipes.add(recipe);
        }
        if (possibleRecipes.isEmpty()) {
            return false;
        }
        for (ManipulatorCraftingRecipe recipe : possibleRecipes) {
            if (!recipe.hasSameItems(submittedBlocks)) continue;
            for (BlockPos blockPos : BlockPos.m_121940_((BlockPos)pointA, (BlockPos)pointB)) {
                this.f_58857_.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 3);
            }
            List droppedItems = this.m_58904_().m_45976_(ItemEntity.class, new AABB(this.pointABlockPos, this.pointBBlockPos).m_82400_(1.0));
            droppedItems.forEach(Entity::m_146870_);
            ManipulatorCraftingResult manipulatorCraftingResult = recipe.result();
            if (manipulatorCraftingResult instanceof ManipulatorBlockResult) {
                ManipulatorBlockResult blockResult = (ManipulatorBlockResult)manipulatorCraftingResult;
                BlockState blockState = blockResult.recipeOutput();
                if (blockState != null) {
                    Vec3 centerVector = new AABB(this.pointABlockPos, this.pointBBlockPos).m_82399_();
                    int min = Math.min(this.pointABlockPos.m_123342_(), this.pointBBlockPos.m_123342_());
                    BlockPos centerPos = new BlockPos((int)centerVector.f_82479_, min, (int)centerVector.f_82481_);
                    this.f_58857_.m_7731_(centerPos, blockState, 3);
                }
            } else {
                ManipulatorItemResult itemResult;
                ItemStack itemStack;
                ManipulatorCraftingResult centerVector = recipe.result();
                if (centerVector instanceof ManipulatorItemResult && (itemStack = (itemResult = (ManipulatorItemResult)centerVector).recipeOutput()) != null) {
                    ItemEntity item = new ItemEntity(this.f_58857_, (double)((float)this.m_58899_().m_123341_() + 0.5f), (double)(this.m_58899_().m_123342_() + 1), (double)((float)this.m_58899_().m_123343_() + 0.5f), itemStack);
                    this.f_58857_.m_7967_((Entity)item);
                }
            }
            return true;
        }
        return false;
    }
}

