/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.blockentity.device;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import whocraft.tardis_refined.common.dimension.TardisTeleportData;
import whocraft.tardis_refined.common.tardis.manager.TardisInteriorManager;
import whocraft.tardis_refined.registry.TRBlockEntityRegistry;
import whocraft.tardis_refined.registry.TRDimensionTypes;
import whocraft.tardis_refined.registry.TRSoundRegistry;

public class CorridorTeleporterBlockEntity
extends BlockEntity
implements BlockEntityTicker<CorridorTeleporterBlockEntity> {
    private static int TICKS_FOR_COOLDOWN = 100;
    private static int TICKS_TO_TRIGGER_TELEPORT = 160;
    private int timeSinceTriggeredTicks = 0;
    private int cooldownTicks = 0;

    public CorridorTeleporterBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(TRBlockEntityRegistry.CORRIDOR_TELEPORTER.get(), blockPos, blockState);
    }

    public void startTeleporterTimer() {
        if (this.cooldownTicks == 0 && this.timeSinceTriggeredTicks == 0) {
            ++this.timeSinceTriggeredTicks;
            this.f_58857_.m_5594_(null, this.m_58899_(), TRSoundRegistry.CORRIDOR_TELEPORTER.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState, CorridorTeleporterBlockEntity blockEntity) {
        if (this.timeSinceTriggeredTicks > 0 && this.cooldownTicks == 0) {
            ++this.timeSinceTriggeredTicks;
        }
        if (this.cooldownTicks > 0) {
            --this.cooldownTicks;
        }
        if (this.timeSinceTriggeredTicks == TICKS_TO_TRIGGER_TELEPORT) {
            this.timeSinceTriggeredTicks = 0;
            this.cooldownTicks = TICKS_FOR_COOLDOWN;
            if (level.m_220362_() != TRDimensionTypes.TARDIS) {
                level.m_5594_(null, this.m_58899_(), SoundEvents.f_11703_, SoundSource.BLOCKS, 1.0f, 0.5f);
                return;
            }
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                AABB box = new AABB(blockPos).m_82377_(0.25, 1.0, 0.25);
                List entities = serverLevel.m_45976_(Entity.class, box);
                BlockPos corridorAirlock = TardisInteriorManager.STATIC_CORRIDOR_POSITION;
                for (Entity entity : entities) {
                    TardisTeleportData.scheduleEntityTeleport(entity, (ResourceKey<Level>)serverLevel.m_46472_(), (float)corridorAirlock.m_123341_() + 0.5f, corridorAirlock.m_123342_(), (float)corridorAirlock.m_123343_() + 0.5f, 0.0f, 0.0f);
                }
                if (entities.stream().count() > 0L) {
                    level.m_5594_(null, this.m_58899_(), TRSoundRegistry.CORRIDOR_TELEPORTER_SUCCESS.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    level.m_5594_(null, corridorAirlock, TRSoundRegistry.CORRIDOR_TELEPORTER_SUCCESS.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            }
        }
    }
}

