/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.capability.tardis;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import whocraft.tardis_refined.api.event.ShellChangeSource;
import whocraft.tardis_refined.api.event.ShellChangeSources;
import whocraft.tardis_refined.api.event.TardisCommonEvents;
import whocraft.tardis_refined.client.TardisClientData;
import whocraft.tardis_refined.common.block.shell.GlobalShellBlock;
import whocraft.tardis_refined.common.block.shell.ShellBaseBlock;
import whocraft.tardis_refined.common.blockentity.door.RootShellDoorBlockEntity;
import whocraft.tardis_refined.common.blockentity.door.TardisInternalDoor;
import whocraft.tardis_refined.common.blockentity.shell.ExteriorShell;
import whocraft.tardis_refined.common.blockentity.shell.GlobalShellBlockEntity;
import whocraft.tardis_refined.common.capability.player.TardisPlayerInfo;
import whocraft.tardis_refined.common.capability.tardis.forge.TardisLevelOperatorImpl;
import whocraft.tardis_refined.common.capability.tardis.upgrades.UpgradeHandler;
import whocraft.tardis_refined.common.network.messages.screens.MonitorPositionDataMessage;
import whocraft.tardis_refined.common.soundscape.hum.TardisHums;
import whocraft.tardis_refined.common.tardis.TardisArchitectureHandler;
import whocraft.tardis_refined.common.tardis.TardisDesktops;
import whocraft.tardis_refined.common.tardis.TardisNavLocation;
import whocraft.tardis_refined.common.tardis.manager.AestheticHandler;
import whocraft.tardis_refined.common.tardis.manager.FlightDanceManager;
import whocraft.tardis_refined.common.tardis.manager.ProgressionManager;
import whocraft.tardis_refined.common.tardis.manager.TardisExteriorManager;
import whocraft.tardis_refined.common.tardis.manager.TardisInteriorManager;
import whocraft.tardis_refined.common.tardis.manager.TardisPilotingManager;
import whocraft.tardis_refined.common.tardis.manager.TardisWaypointManager;
import whocraft.tardis_refined.common.tardis.themes.ShellTheme;
import whocraft.tardis_refined.common.util.TardisHelper;
import whocraft.tardis_refined.compat.ModCompatChecker;
import whocraft.tardis_refined.compat.portals.ImmersivePortals;
import whocraft.tardis_refined.compat.valkyrienskies.VSHelper;
import whocraft.tardis_refined.patterns.ShellPattern;
import whocraft.tardis_refined.patterns.ShellPatterns;
import whocraft.tardis_refined.registry.TRBlockRegistry;
import whocraft.tardis_refined.registry.TRDimensionTypes;

public class TardisLevelOperator {
    public static final int STATE_CAVE = 0;
    public static final int STATE_TERRAFORMED_NO_EYE = 1;
    public static final int STATE_EYE_OF_HARMONY = 2;
    private final Level level;
    private final ResourceKey<Level> levelKey;
    private final TardisExteriorManager exteriorManager;
    private final TardisInteriorManager interiorManager;
    private final TardisPilotingManager pilotingManager;
    private final TardisWaypointManager tardisWaypointManager;
    private final FlightDanceManager flightDanceManager;
    private final TardisClientData tardisClientData;
    private final UpgradeHandler upgradeHandler;
    private final AestheticHandler aestheticHandler;
    private final ProgressionManager progressionManager;
    private boolean hasInitiallyGenerated = false;
    private TardisInternalDoor internalDoor = null;
    private int tardisState = 0;
    public HashSet<ServerPlayer> updatingMonitors = new HashSet();

    public TardisLevelOperator(Level level) {
        this.level = level;
        this.levelKey = level.m_46472_();
        this.exteriorManager = new TardisExteriorManager(this);
        this.interiorManager = new TardisInteriorManager(this);
        this.pilotingManager = new TardisPilotingManager(this);
        this.tardisWaypointManager = new TardisWaypointManager(this);
        this.tardisClientData = new TardisClientData((ResourceKey<Level>)level.m_46472_());
        this.upgradeHandler = new UpgradeHandler(this);
        this.aestheticHandler = new AestheticHandler(this);
        this.flightDanceManager = new FlightDanceManager(this);
        this.progressionManager = new ProgressionManager();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Optional<TardisLevelOperator> get(ServerLevel level) {
        return TardisLevelOperatorImpl.get(level);
    }

    public UpgradeHandler getUpgradeHandler() {
        return this.upgradeHandler;
    }

    public TardisClientData tardisClientData() {
        return this.tardisClientData;
    }

    public AestheticHandler getAestheticHandler() {
        return this.aestheticHandler;
    }

    public FlightDanceManager getFlightDanceManager() {
        return this.flightDanceManager;
    }

    public CompoundTag serializeNBT() {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128379_("has_setup", this.hasInitiallyGenerated);
        if (this.internalDoor != null) {
            compoundTag.m_128359_("internal_door_id", this.internalDoor.getID());
            compoundTag.m_128365_("internal_door_pos", (Tag)NbtUtils.m_129224_((BlockPos)this.internalDoor.getDoorPosition()));
        }
        compoundTag = this.exteriorManager.saveData(compoundTag);
        compoundTag = this.interiorManager.saveData(compoundTag);
        compoundTag = this.pilotingManager.saveData(compoundTag);
        compoundTag = this.tardisWaypointManager.saveData(compoundTag);
        compoundTag = this.upgradeHandler.saveData(compoundTag);
        compoundTag = this.aestheticHandler.saveData(compoundTag);
        compoundTag = this.flightDanceManager.saveData(compoundTag);
        compoundTag = this.progressionManager.saveData(compoundTag);
        compoundTag.m_128405_("tardis_state", this.tardisState);
        return compoundTag;
    }

    public void deserializeNBT(CompoundTag tag) {
        BlockEntity blockEntity;
        this.hasInitiallyGenerated = tag.m_128471_("has_setup");
        CompoundTag doorPos = tag.m_128469_("internal_door_pos");
        if (doorPos != null && (blockEntity = this.level.m_7702_(NbtUtils.m_129239_((CompoundTag)doorPos))) instanceof TardisInternalDoor) {
            TardisInternalDoor door;
            this.internalDoor = door = (TardisInternalDoor)blockEntity;
            this.internalDoor.setID(tag.m_128461_("internal_door_id"));
        }
        this.exteriorManager.loadData(tag);
        this.interiorManager.loadData(tag);
        this.pilotingManager.loadData(tag);
        this.tardisWaypointManager.loadData(tag);
        this.upgradeHandler.loadData(tag);
        this.aestheticHandler.loadData(tag);
        this.flightDanceManager.loadData(tag);
        this.progressionManager.loadData(tag);
        this.tardisState = tag.m_128451_("tardis_state");
        this.tardisClientData.sync();
    }

    public Level getLevel() {
        return this.level;
    }

    public ResourceKey<Level> getLevelKey() {
        return this.levelKey;
    }

    public void tick(ServerLevel level) {
        boolean shouldSync;
        if (this.interiorManager != null) {
            this.interiorManager.tick(level);
        }
        if (this.pilotingManager != null) {
            this.pilotingManager.tick(level);
        }
        if (this.flightDanceManager != null) {
            this.flightDanceManager.tick(level);
        }
        level.m_7654_().m_6846_().m_11314_().forEach(serverPlayer -> TardisPlayerInfo.get((LivingEntity)serverPlayer).ifPresent(tardisPlayerInfo -> tardisPlayerInfo.tick(this, (ServerPlayer)serverPlayer)));
        boolean bl = shouldSync = level.m_46467_() % 40L == 0L;
        if (shouldSync) {
            this.tardisClientData.setIsOnCooldown(this.pilotingManager.isInRecovery());
            this.tardisClientData.setShellTheme(this.aestheticHandler.getShellTheme());
            this.tardisClientData.setShellPattern(this.aestheticHandler.shellPattern().id());
            this.tardisClientData.setHumEntry(this.interiorManager.getHumEntry());
            this.tardisClientData.setFuel(this.pilotingManager.getFuel());
            this.tardisClientData.setMaximumFuel(this.pilotingManager.getMaximumFuel());
            this.tardisClientData.setTardisState(this.tardisState);
            this.tardisClientData.setRecoveryProgress(this.pilotingManager.getCrashRecoveryTicks());
            this.tardisClientData.setFlying(this.pilotingManager.isInFlight());
            this.tardisClientData.setIsLanding(this.exteriorManager.isLanding());
            this.tardisClientData.setIsTakingOff(this.exteriorManager.isTakingOff());
            this.tardisClientData.setIsCrashing(this.pilotingManager.isCrashing());
            this.tardisClientData.setVortex(this.aestheticHandler.getVortex());
            float percentageCompleted = this.getPilotingManager().getFlightPercentageCovered() * 100.0f;
            if (percentageCompleted > 100.0f) {
                percentageCompleted = 100.0f;
            }
            this.tardisClientData.setJourneyProgress(percentageCompleted);
            this.tardisClientData.sync();
        } else {
            this.tardisClientData.setIsCrashing(this.pilotingManager.isCrashing());
            this.tardisClientData.setRecoveryProgress(this.pilotingManager.getCrashRecoveryTicks());
            this.tardisClientData.setFlying(this.pilotingManager.isInFlight());
            this.tardisClientData.setIsLanding(this.exteriorManager.isLanding());
            this.tardisClientData.setIsTakingOff(this.exteriorManager.isTakingOff());
            this.tardisClientData.setThrottleStage(this.pilotingManager.getThrottleStage());
            this.tardisClientData.setHandbrakeEngaged(this.pilotingManager.isHandbrakeOn());
            this.tardisClientData.setVortex(this.aestheticHandler.getVortex());
            this.tardisClientData.sync();
        }
        Iterator<ServerPlayer> updatingMonitorsIterator = this.updatingMonitors.iterator();
        while (updatingMonitorsIterator.hasNext()) {
            ServerPlayer player = updatingMonitorsIterator.next();
            if (player.m_213877_()) {
                updatingMonitorsIterator.remove();
                continue;
            }
            TardisNavLocation location = this.pilotingManager.getCurrentLocation().copy();
            if (ModCompatChecker.valkyrienSkies()) {
                location = VSHelper.toWorldLocation(location);
            }
            new MonitorPositionDataMessage(location).send(player);
        }
    }

    public boolean hasInitiallyGenerated() {
        return this.hasInitiallyGenerated;
    }

    public void setInitiallyGenerated(boolean hasInitiallyGenerated) {
        this.hasInitiallyGenerated = hasInitiallyGenerated;
    }

    public ProgressionManager getProgressionManager() {
        return this.progressionManager;
    }

    public boolean enterTardis(Entity entity, BlockPos externalShellPos, ServerLevel shellLevel, Direction shellDirection) {
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel targetServerLevel = (ServerLevel)level;
        BlockPos targetPosition = this.internalDoor != null ? this.internalDoor.getTeleportPosition() : TardisArchitectureHandler.DESKTOP_CENTER_POS.m_7494_();
        Direction targetDirection = this.internalDoor != null ? this.internalDoor.getTeleportRotation() : entity.m_6350_();
        TardisNavLocation sourceLocation = new TardisNavLocation(externalShellPos, shellDirection, shellLevel);
        TardisNavLocation targetLocation = new TardisNavLocation(targetPosition, targetDirection, targetServerLevel);
        this.pilotingManager.setCurrentLocation(new TardisNavLocation(externalShellPos, shellDirection.m_122424_(), shellLevel));
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            TardisPlayerInfo.get((LivingEntity)serverPlayer).ifPresent(tardisPlayerInfo -> {
                if (!tardisPlayerInfo.isViewingTardis()) {
                    TardisHelper.teleportEntityTardis(this, entity, sourceLocation, targetLocation, true);
                }
            });
        } else {
            TardisHelper.teleportEntityTardis(this, entity, sourceLocation, targetLocation, true);
        }
        return true;
    }

    public boolean isTardisReady() {
        return !this.getInteriorManager().isGeneratingDesktop();
    }

    public boolean exitTardis(Entity entity, ServerLevel doorLevel, BlockPos doorPos, Direction doorDirection, boolean ignoreDoor) {
        if (!ignoreDoor && !this.internalDoor.isOpen()) {
            return false;
        }
        if (this.aestheticHandler == null || this.pilotingManager == null) {
            return false;
        }
        if (this.aestheticHandler.getShellTheme() != null) {
            ResourceLocation theme = this.aestheticHandler.getShellTheme();
            if (ModCompatChecker.immersivePortals() && !(this.internalDoor instanceof RootShellDoorBlockEntity) && !ignoreDoor && this.level.m_220362_() == TRDimensionTypes.TARDIS && ImmersivePortals.isShellThemeSupported(theme) && ImmersivePortals.doPortalsExistForTardis(UUID.fromString(doorLevel.m_46472_().m_135782_().m_135815_()))) {
                return false;
            }
        }
        if (this.pilotingManager.getCurrentLocation() != null) {
            TardisNavLocation currentLocation = this.pilotingManager.getCurrentLocation();
            BlockPos exteriorPos = currentLocation.getPosition();
            ServerLevel targetLevel = currentLocation.getLevel();
            Direction targetDirection = currentLocation.getDirection().m_122424_();
            BlockPos teleportPos = exteriorPos;
            BlockEntity blockEntity = targetLevel.m_7702_(exteriorPos);
            if (blockEntity instanceof ExteriorShell) {
                ExteriorShell exteriorShell = (ExteriorShell)blockEntity;
                teleportPos = exteriorShell.getTeleportPosition();
                targetDirection = exteriorShell.getTeleportRotation();
            }
            TardisNavLocation sourceLocation = new TardisNavLocation(doorPos, doorDirection, doorLevel);
            TardisNavLocation destinationLocation = new TardisNavLocation(teleportPos, targetDirection, targetLevel);
            TardisHelper.teleportEntityTardis(this, entity, sourceLocation, destinationLocation, false);
            return true;
        }
        return false;
    }

    public void forceEjectAllPlayers() {
        for (Player player : this.level.m_6907_()) {
            if (!(player instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.forceEjectPlayer(serverPlayer);
        }
    }

    public boolean forceEjectPlayer(ServerPlayer player) {
        if (player != null) {
            TardisNavLocation location = this.getPilotingManager().getCurrentLocation();
            return this.exitTardis((Entity)player, location.getLevel(), location.getPosition(), location.getDirection(), true);
        }
        return false;
    }

    public boolean triggerRegenState(boolean startRegen) {
        TardisPilotingManager pilotingManager = this.getPilotingManager();
        if (pilotingManager == null) {
            return false;
        }
        TardisNavLocation currentPosition = this.getPilotingManager().getCurrentLocation();
        if (currentPosition == null) {
            return false;
        }
        BlockPos currentBlockPos = currentPosition.getPosition();
        ServerLevel currentLevel = currentPosition.getLevel();
        BlockState state = currentLevel.m_8055_(currentBlockPos);
        if (currentLevel == null) {
            return false;
        }
        Block block = state.m_60734_();
        if (block instanceof ShellBaseBlock) {
            ShellBaseBlock shellBaseBlock = (ShellBaseBlock)block;
            if (state.m_61138_((Property)ShellBaseBlock.REGEN)) {
                if (startRegen) {
                    this.setDoorClosed(true);
                }
                this.setDoorLocked(startRegen);
                BlockState blockStateAfterDoorUpdates = currentLevel.m_8055_(currentBlockPos);
                if (blockStateAfterDoorUpdates.m_61138_((Property)ShellBaseBlock.REGEN)) {
                    BlockState updatedBlockState = (BlockState)blockStateAfterDoorUpdates.m_61124_((Property)ShellBaseBlock.REGEN, (Comparable)Boolean.valueOf(startRegen));
                    if (this.getTardisState() == 0 || this.getTardisState() == 1) {
                        this.setOrUpdateExteriorBlock(currentPosition, Optional.of(updatedBlockState), startRegen, ShellChangeSources.ROOT_TO_TARDIS);
                    } else {
                        this.setOrUpdateExteriorBlock(currentPosition, Optional.of(updatedBlockState), startRegen, ShellChangeSources.REGEN_EXISTING_TARDIS);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public void setOrUpdateExteriorBlock(TardisNavLocation location, Optional<BlockState> targetBlockState) {
        this.setOrUpdateExteriorBlock(location, targetBlockState, false, ShellChangeSources.GENERIC_UPDATE);
    }

    public void setOrUpdateExteriorBlock(TardisNavLocation location, Optional<BlockState> overridingBlockState, boolean startingRegen, ShellChangeSource shellChangeSource) {
        AestheticHandler aestheticHandler = this.getAestheticHandler();
        ResourceLocation theme = aestheticHandler.getShellTheme() != null ? aestheticHandler.getShellTheme() : ShellTheme.HALF_BAKED.getId();
        ShellTheme shellTheme = ShellTheme.getShellTheme(theme);
        ShellPattern shellPattern = aestheticHandler.getShellTheme() != null ? aestheticHandler.shellPattern() : null;
        ServerLevel targetLevel = location.getLevel();
        BlockPos targetLocation = location.getPosition();
        BlockState newExteriorBlock = (BlockState)((BlockState)((BlockState)TRBlockRegistry.GLOBAL_SHELL_BLOCK.get().m_49966_().m_61124_((Property)ShellBaseBlock.FACING, (Comparable)location.getDirection().m_122424_())).m_61124_((Property)ShellBaseBlock.REGEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ShellBaseBlock.WATERLOGGED, (Comparable)Boolean.valueOf(location.getLevel().m_8055_(targetLocation).m_60819_().m_76152_() == Fluids.f_76193_));
        BlockState selectedBlockState = shellChangeSource == ShellChangeSources.ROOT_TO_TARDIS ? (startingRegen ? overridingBlockState.orElse(newExteriorBlock) : newExteriorBlock) : overridingBlockState.orElse(newExteriorBlock);
        BlockState updatedBlockState = (BlockState)((BlockState)selectedBlockState.m_61124_((Property)ShellBaseBlock.FACING, (Comparable)location.getDirection().m_122424_())).m_61124_((Property)ShellBaseBlock.WATERLOGGED, (Comparable)Boolean.valueOf(location.getLevel().m_8055_(targetLocation).m_60819_().m_76152_() == Fluids.f_76193_));
        if (updatedBlockState.m_61138_((Property)GlobalShellBlock.LIT) && shellTheme != null) {
            updatedBlockState.m_61124_((Property)GlobalShellBlock.LIT, (Comparable)Boolean.valueOf(shellTheme.producesLight()));
        }
        targetLevel.m_7731_(targetLocation, updatedBlockState, 3);
        BlockEntity blockEntity = targetLevel.m_7702_(targetLocation);
        if (blockEntity instanceof GlobalShellBlockEntity) {
            GlobalShellBlockEntity globalShellBlockEntity = (GlobalShellBlockEntity)blockEntity;
            globalShellBlockEntity.setTardisId(this.levelKey);
            globalShellBlockEntity.setPattern(shellPattern);
            globalShellBlockEntity.sendUpdates();
        }
        if (theme != null && shellPattern != null) {
            this.setShellTheme(theme, shellPattern.id(), shellChangeSource);
        }
        targetLevel.m_7260_(targetLocation, updatedBlockState, updatedBlockState, 2);
    }

    public void setDoorClosed(boolean closeDoor) {
        TardisInternalDoor intDoor = this.getInternalDoor();
        if (intDoor != null) {
            intDoor.setClosed(closeDoor);
        }
        if (this.pilotingManager != null && this.pilotingManager.getCurrentLocation() != null) {
            this.exteriorManager.setDoorClosed(closeDoor);
        }
        if (closeDoor) {
            TardisCommonEvents.DOOR_CLOSED_EVENT.invoker().onDoorClosed(this);
        } else {
            TardisCommonEvents.DOOR_OPENED_EVENT.invoker().onDoorOpen(this);
        }
    }

    public void setDoorLocked(boolean lockDoor) {
        TardisInternalDoor intDoor = this.getInternalDoor();
        if (intDoor != null) {
            intDoor.setLocked(lockDoor);
        }
        if (this.pilotingManager != null && this.pilotingManager.getCurrentLocation() != null && this.exteriorManager != null) {
            this.exteriorManager.setLocked(lockDoor);
        }
        if (lockDoor) {
            TardisCommonEvents.DOOR_LOCKED_EVENT.invoker().onDoorLocked(this);
        } else {
            TardisCommonEvents.DOOR_UNLOCKED_EVENT.invoker().onDoorUnlocked(this);
        }
    }

    public void setShellTheme(ResourceLocation shellTheme, ResourceLocation shellPattern, ShellChangeSource shellChangeSource) {
        this.aestheticHandler.setShellTheme(shellTheme, shellPattern, this.getPilotingManager().getCurrentLocation());
        this.aestheticHandler.setShellPattern(ShellPatterns.getPatternOrDefault(shellTheme, shellPattern));
        this.tardisClientData.setShellTheme(shellTheme);
        this.tardisClientData.setShellPattern(this.aestheticHandler.shellPattern().id());
        this.tardisClientData.sync();
        TardisCommonEvents.SHELL_CHANGE_EVENT.invoker().onShellChange(this, shellTheme, shellChangeSource);
    }

    public void setupInitialCave(ServerLevel shellServerLevel, BlockState shellBlockState, BlockPos shellBlockPos) {
        this.interiorManager.generateDesktop(TardisDesktops.DEFAULT_OVERGROWN_THEME);
        Direction direction = ((Direction)shellBlockState.m_61143_((Property)ShellBaseBlock.FACING)).m_122424_();
        TardisNavLocation navLocation = new TardisNavLocation(shellBlockPos, direction, shellServerLevel);
        this.pilotingManager.setCurrentLocation(navLocation);
        this.pilotingManager.setTargetLocation(navLocation);
        this.setInitiallyGenerated(true);
        this.setTardisState(0);
        this.interiorManager.setHumEntry(TardisHums.CAVE);
    }

    public TardisExteriorManager getExteriorManager() {
        return this.exteriorManager;
    }

    public TardisInternalDoor getInternalDoor() {
        return this.internalDoor;
    }

    public void setInternalDoor(TardisInternalDoor door) {
        if (this.internalDoor != null) {
            this.internalDoor.onSetMainDoor(false);
        }
        this.internalDoor = door;
        if (door != null) {
            this.internalDoor.onSetMainDoor(true);
        }
    }

    public TardisInteriorManager getInteriorManager() {
        return this.interiorManager;
    }

    public TardisPilotingManager getPilotingManager() {
        return this.pilotingManager;
    }

    public TardisWaypointManager getTardisWaypointManager() {
        return this.tardisWaypointManager;
    }

    public int getTardisState() {
        return this.tardisState;
    }

    public void setTardisState(int state) {
        this.tardisState = state;
    }
}

