/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.capability.tardis.upgrades;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import whocraft.tardis_refined.api.event.TardisCommonEvents;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.capability.tardis.upgrades.Upgrade;
import whocraft.tardis_refined.common.tardis.TardisArchitectureHandler;
import whocraft.tardis_refined.registry.TRUpgrades;

public class UpgradeHandler {
    public static final int XP_PER_UPGRADE_POINT = 50;
    @NotNull
    private TardisLevelOperator tardisLevelOperator;
    private final List<Upgrade> unlockedUpgrades = new ArrayList<Upgrade>();
    private int upgradeXP = 0;
    private int upgradePoints = 0;
    private int overallTardisPoints = 0;

    public UpgradeHandler(@NotNull TardisLevelOperator tardisLevelOperator) {
        this.tardisLevelOperator = tardisLevelOperator;
    }

    public UpgradeHandler() {
    }

    public double calculateProgress() {
        int totalUpgrades = TRUpgrades.UPGRADE_DEFERRED_REGISTRY.entrySet().size();
        int unlockedCount = this.unlockedUpgrades.size();
        if (totalUpgrades == 0) {
            return 0.0;
        }
        return (double)unlockedCount / (double)totalUpgrades * 100.0;
    }

    public String getProgressLevel() {
        double progress = this.calculateProgress();
        if (progress >= 80.0) {
            return "five";
        }
        if (progress >= 60.0) {
            return "four";
        }
        if (progress >= 40.0) {
            return "three";
        }
        if (progress >= 20.0) {
            return "two";
        }
        return "one";
    }

    public String toString() {
        return "UpgradeHandler{tardisLevelOperator=" + this.tardisLevelOperator + ", upgradeXP=" + this.upgradeXP + ", upgradePoints=" + this.upgradePoints + ", unlockedUpgrades=" + this.unlockedUpgrades + "}";
    }

    public List<Upgrade> getUnlockedUpgrades() {
        return this.unlockedUpgrades;
    }

    public int getUpgradeXP() {
        return this.upgradeXP;
    }

    public void setUpgradeXP(int upgradeXP) {
        this.upgradeXP = Mth.m_14045_((int)upgradeXP, (int)0, (int)49);
    }

    public void addUpgradeXP(int upgradeXP) {
        this.upgradeXP += upgradeXP;
        while (this.upgradeXP >= 50) {
            ++this.upgradePoints;
            ++this.overallTardisPoints;
            this.upgradeXP -= 50;
        }
        while (this.upgradeXP <= -50) {
            --this.upgradePoints;
            this.upgradeXP += 50;
        }
        if (this.upgradeXP < 0) {
            --this.upgradePoints;
            this.upgradeXP = 50 - Mth.m_14040_((int)this.upgradeXP);
        }
        this.upgradePoints = Mth.m_14045_((int)this.upgradePoints, (int)0, (int)Integer.MAX_VALUE);
    }

    public int getNeededXPForNextPoint() {
        return 50 - this.upgradeXP;
    }

    public int getUpgradePoints() {
        return this.upgradePoints;
    }

    public void setUpgradePoints(int upgradePoints) {
        this.upgradePoints = Mth.m_14045_((int)upgradePoints, (int)0, (int)Integer.MAX_VALUE);
    }

    public int getOverallTardisPoints() {
        return this.overallTardisPoints;
    }

    public void addUpgradePoints(int upgradePoints) {
        this.setUpgradePoints(this.getUpgradePoints() + upgradePoints);
    }

    public boolean isUpgradeUnlocked(Upgrade upgrade) {
        for (Upgrade s = upgrade; s != null; s = s.getParent()) {
            if (this.unlockedUpgrades.contains(upgrade)) continue;
            return false;
        }
        return true;
    }

    public void unlockUpgrade(Upgrade upgrade) {
        if (!this.isUpgradeUnlocked(upgrade)) {
            for (Upgrade parent = upgrade.getParent(); parent != null && !this.isUpgradeUnlocked(parent); parent = parent.getParent()) {
                this.unlockedUpgrades.add(parent);
                parent.onUnlocked(this.tardisLevelOperator, this);
            }
            this.unlockedUpgrades.add(upgrade);
            upgrade.onUnlocked(this.tardisLevelOperator, this);
            Level level = this.tardisLevelOperator.getLevel();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                TardisArchitectureHandler.generateArsTree(this.tardisLevelOperator, serverLevel);
            }
            TardisCommonEvents.UPGRADE_UNLOCKED.invoker().onUpgradeUnlock(this.tardisLevelOperator, upgrade);
        }
    }

    public void lockUpgrade(Upgrade upgrade) {
        if (this.unlockedUpgrades.contains(upgrade)) {
            this.unlockedUpgrades.remove(upgrade);
            upgrade.onLocked(this.tardisLevelOperator, this);
            for (Upgrade child : upgrade.getDirectChildren()) {
                this.lockUpgrade(child);
            }
        }
    }

    public CompoundTag saveData(CompoundTag compoundTag) {
        CompoundTag updateTag = new CompoundTag();
        updateTag.m_128405_("UpgradeXP", this.upgradeXP);
        updateTag.m_128405_("UpgradePoints", this.upgradePoints);
        updateTag.m_128405_("OverallPoints", this.overallTardisPoints);
        ListTag unlockedUpgradesTag = new ListTag();
        for (Upgrade upgrade : this.unlockedUpgrades) {
            if (TRUpgrades.UPGRADE_DEFERRED_REGISTRY.getKey(upgrade) == null) continue;
            unlockedUpgradesTag.add((Object)StringTag.m_129297_((String)Objects.requireNonNull(TRUpgrades.UPGRADE_DEFERRED_REGISTRY.getKey(upgrade)).toString()));
        }
        updateTag.m_128365_("UnlockedUpgrades", (Tag)unlockedUpgradesTag);
        compoundTag.m_128365_("upgrades", (Tag)updateTag);
        return compoundTag;
    }

    public void loadData(CompoundTag compoundTag) {
        CompoundTag nbt = (CompoundTag)compoundTag.m_128423_("upgrades");
        this.upgradeXP = nbt.m_128451_("UpgradeXP");
        this.upgradePoints = nbt.m_128451_("UpgradePoints");
        this.overallTardisPoints = nbt.m_128451_("OverallPoints");
        this.unlockedUpgrades.clear();
        for (Tag upgrade : nbt.m_128437_("UnlockedUpgrades", 8)) {
            this.unlockedUpgrades.add(TRUpgrades.UPGRADE_DEFERRED_REGISTRY.get(new ResourceLocation(upgrade.m_7916_())));
        }
    }
}

