/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.crafting.astral_manipulator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import whocraft.tardis_refined.common.crafting.astral_manipulator.ManipulatorBlockResult;
import whocraft.tardis_refined.common.crafting.astral_manipulator.ManipulatorCraftingIngredient;
import whocraft.tardis_refined.common.crafting.astral_manipulator.ManipulatorCraftingResult;
import whocraft.tardis_refined.common.crafting.astral_manipulator.ManipulatorItemResult;
import whocraft.tardis_refined.registry.TRCraftingRecipeSerializers;
import whocraft.tardis_refined.registry.TRCraftingRecipeTypes;

public class ManipulatorCraftingRecipe
implements CraftingRecipe {
    public static final Codec<ManipulatorCraftingRecipe> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ManipulatorCraftingIngredient.CODEC.listOf().fieldOf("ingredients").forGetter(ManipulatorCraftingRecipe::ingredients), (App)ManipulatorCraftingResult.RESULT_CODEC.fieldOf("result").forGetter(ManipulatorCraftingRecipe::result)).apply((Applicative)builder, ManipulatorCraftingRecipe::new));
    private List<ManipulatorCraftingIngredient> ingredients;
    private ManipulatorCraftingResult result;
    private ResourceLocation id;

    public ManipulatorCraftingRecipe(List<ManipulatorCraftingIngredient> itemList, ManipulatorCraftingResult recipeOutput) {
        this.ingredients = itemList;
        this.result = recipeOutput;
    }

    public ManipulatorCraftingRecipe(List<ManipulatorCraftingIngredient> ingredients, ItemStack recipeOutput) {
        this(ingredients, new ManipulatorItemResult(recipeOutput));
    }

    public ManipulatorCraftingRecipe(List<ManipulatorCraftingIngredient> ingredients, BlockState recipeOutput) {
        this(ingredients, new ManipulatorBlockResult(recipeOutput));
    }

    public static List<ManipulatorCraftingRecipe> getAllRecipes(Level level) {
        List recipeHolders = level.m_7465_().m_44013_(TRCraftingRecipeTypes.ASTRAL_MANIPULATOR_RECIPE.get());
        ArrayList<ManipulatorCraftingRecipe> recipeList = new ArrayList<ManipulatorCraftingRecipe>();
        recipeHolders.forEach(recipeHolder -> recipeList.add(recipeHolder.setRegistryId(recipeHolder.id)));
        return recipeList;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public ManipulatorCraftingRecipe setRegistryId(ResourceLocation id) {
        this.id = id;
        return this;
    }

    public boolean hasSameItems(List<ManipulatorCraftingIngredient> comparedItemList) {
        if (this.ingredients.size() != comparedItemList.size()) {
            return false;
        }
        ArrayList<ManipulatorCraftingIngredient> sortedIngredients = new ArrayList<ManipulatorCraftingIngredient>(this.ingredients);
        sortedIngredients.sort(Comparator.comparing(a -> a.relativeBlockPos()));
        ArrayList<ManipulatorCraftingIngredient> sortedCompareList = new ArrayList<ManipulatorCraftingIngredient>(comparedItemList);
        sortedCompareList.sort(Comparator.comparing(a -> a.relativeBlockPos()));
        for (int i = 0; i < sortedIngredients.size(); ++i) {
            if (((ManipulatorCraftingIngredient)sortedIngredients.get(i)).IsSameAs((ManipulatorCraftingIngredient)sortedCompareList.get(i))) continue;
            return false;
        }
        return true;
    }

    public ManipulatorCraftingResult result() {
        return this.result;
    }

    public List<ManipulatorCraftingIngredient> ingredients() {
        return this.ingredients;
    }

    public CraftingBookCategory m_245232_() {
        return CraftingBookCategory.MISC;
    }

    public boolean matches(CraftingContainer container, Level level) {
        return false;
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        Codec<? extends ManipulatorCraftingResult> codec = this.result.type();
        if (codec instanceof ManipulatorItemResult) {
            ManipulatorItemResult manipulatorItemResult = (ManipulatorItemResult)codec;
            return manipulatorItemResult.recipeOutput();
        }
        codec = this.result.type();
        if (codec instanceof ManipulatorBlockResult) {
            ManipulatorBlockResult manipulatorBlockResult = (ManipulatorBlockResult)codec;
            return new ItemStack((ItemLike)manipulatorBlockResult.recipeOutput().m_60734_().m_5456_());
        }
        return ItemStack.f_41583_;
    }

    public RecipeSerializer<?> m_7707_() {
        return TRCraftingRecipeSerializers.ASTRAL_MANIPULATOR.get();
    }

    public RecipeType<?> m_6671_() {
        return TRCraftingRecipeTypes.ASTRAL_MANIPULATOR_RECIPE.get();
    }
}

