/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.data;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import whocraft.tardis_refined.TardisRefined;
import whocraft.tardis_refined.patterns.ConsolePattern;
import whocraft.tardis_refined.patterns.ConsolePatternCollection;
import whocraft.tardis_refined.patterns.ConsolePatterns;

public class ConsolePatternProvider
implements DataProvider {
    protected final DataGenerator generator;
    private final boolean addDefaults;
    protected Map<ResourceLocation, ConsolePatternCollection> data = new HashMap<ResourceLocation, ConsolePatternCollection>();

    public ConsolePatternProvider(DataGenerator generator) {
        this(generator, true);
    }

    public ConsolePatternProvider(DataGenerator generator, boolean addDefaults) {
        Preconditions.checkNotNull((Object)generator);
        this.generator = generator;
        this.addDefaults = addDefaults;
    }

    protected void addPatterns() {
    }

    public CompletableFuture<?> m_213708_(CachedOutput arg) {
        this.data.clear();
        ArrayList futures = new ArrayList();
        if (this.addDefaults) {
            ConsolePatterns.registerDefaultPatterns();
            this.data.putAll(ConsolePatterns.getDefaultPatternsDatagen());
        }
        this.addPatterns();
        if (!this.data.isEmpty()) {
            this.data.entrySet().forEach(entry -> {
                try {
                    ConsolePatternCollection patternCollection = (ConsolePatternCollection)entry.getValue();
                    JsonObject currentPatternCollection = ((JsonElement)ConsolePatternCollection.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)patternCollection).get().ifRight(right -> TardisRefined.LOGGER.error(right.message())).orThrow()).getAsJsonObject();
                    Path output = this.getPath(patternCollection.themeId());
                    futures.add(DataProvider.m_253162_((CachedOutput)arg, (JsonElement)currentPatternCollection, (Path)output));
                }
                catch (Exception exception) {
                    TardisRefined.LOGGER.error("Issue writing ConsolePatternCollection {}! Error: {}", (Object)((ConsolePatternCollection)entry.getValue()).themeId(), (Object)exception.getMessage());
                }
            });
        }
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    protected ConsolePattern addPatternToDatagen(ResourceLocation themeId, ConsolePattern consolePattern) {
        ConsolePattern pattern = (ConsolePattern)consolePattern.setThemeId(themeId);
        if (this.data.containsKey(themeId)) {
            ConsolePatternCollection collection = this.data.get(themeId);
            ArrayList<Object> currentList = new ArrayList<Object>();
            currentList.addAll(collection.patterns());
            currentList.add(pattern);
            collection.setPatterns(currentList);
            this.data.replace(themeId, collection);
        } else {
            ConsolePatternCollection collection = (ConsolePatternCollection)new ConsolePatternCollection(List.of(pattern)).setThemeId(themeId);
            this.data.put(themeId, collection);
        }
        TardisRefined.LOGGER.info("Adding ConsolePattern {} for {}", (Object)pattern.id(), (Object)themeId);
        return pattern;
    }

    protected ResourceLocation createConsolePatternLocation(ResourceLocation path) {
        return new ResourceLocation(path.m_135827_(), "textures/blockentity/console/" + path + ".png");
    }

    private ResourceLocation createConsolePatternLocation(String path) {
        return new ResourceLocation("tardis_refined", "textures/blockentity/console/" + path + ".png");
    }

    protected Path getPath(ResourceLocation themeId) {
        return this.generator.getPackOutput().m_245114_().resolve("data/tardis_refined/tardis_refined/patterns/console/" + themeId.m_135815_() + ".json");
    }

    public String m_6055_() {
        return "Console Patterns";
    }
}

