/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.data;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import whocraft.tardis_refined.TardisRefined;
import whocraft.tardis_refined.common.tardis.TardisDesktops;
import whocraft.tardis_refined.common.tardis.themes.DesktopTheme;

public class DesktopProvider
implements DataProvider {
    protected final DataGenerator generator;
    private final boolean addDefaults;
    protected Map<ResourceLocation, DesktopTheme> data = new HashMap<ResourceLocation, DesktopTheme>();

    public DesktopProvider(DataGenerator generator) {
        this(generator, true);
    }

    public DesktopProvider(DataGenerator generator, boolean addDefaults) {
        Preconditions.checkNotNull((Object)generator);
        this.generator = generator;
        this.addDefaults = addDefaults;
    }

    protected void addDesktops() {
    }

    public CompletableFuture<?> m_213708_(CachedOutput arg) {
        this.data.clear();
        ArrayList futures = new ArrayList();
        if (this.addDefaults) {
            TardisDesktops.registerDefaultDesktops();
            this.data.putAll(TardisDesktops.getDefaultDesktops());
        }
        this.addDesktops();
        if (!this.data.isEmpty()) {
            this.data.entrySet().forEach(entry -> {
                try {
                    DesktopTheme desktop = (DesktopTheme)entry.getValue();
                    JsonObject currentDesktop = ((JsonElement)DesktopTheme.getCodec().encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)desktop).get().ifRight(right -> TardisRefined.LOGGER.error(right.message())).orThrow()).getAsJsonObject();
                    String outputPath = "data/" + desktop.getIdentifier().m_135827_() + "/" + TardisDesktops.getReloadListener().getFolderName() + "/" + desktop.getIdentifier().m_135815_().replace("/", "_") + ".json";
                    futures.add(DataProvider.m_253162_((CachedOutput)arg, (JsonElement)currentDesktop, (Path)this.generator.getPackOutput().m_245114_().resolve(outputPath)));
                }
                catch (Exception exception) {
                    TardisRefined.LOGGER.error("Issue writing Desktop {}! Error: {}", (Object)((DesktopTheme)entry.getValue()).getIdentifier(), (Object)exception.getMessage());
                }
            });
        }
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    public String m_6055_() {
        return "Desktops";
    }

    protected void addDesktop(DesktopTheme theme) {
        TardisRefined.LOGGER.info("Adding Desktop to datagen {}", (Object)theme.getIdentifier());
        this.data.put(theme.getIdentifier(), theme);
    }
}

