/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.data;

import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.LanguageProvider;
import whocraft.tardis_refined.common.VortexRegistry;
import whocraft.tardis_refined.common.capability.tardis.upgrades.Upgrade;
import whocraft.tardis_refined.common.data.SoundProvider;
import whocraft.tardis_refined.common.soundscape.hum.HumEntry;
import whocraft.tardis_refined.common.soundscape.hum.TardisHums;
import whocraft.tardis_refined.common.tardis.control.Control;
import whocraft.tardis_refined.common.tardis.themes.ShellTheme;
import whocraft.tardis_refined.constants.ModMessages;
import whocraft.tardis_refined.registry.TRBlockRegistry;
import whocraft.tardis_refined.registry.TRControlRegistry;
import whocraft.tardis_refined.registry.TRDamageSources;
import whocraft.tardis_refined.registry.TREntityRegistry;
import whocraft.tardis_refined.registry.TRItemRegistry;
import whocraft.tardis_refined.registry.TRSoundRegistry;
import whocraft.tardis_refined.registry.TRUpgrades;

public class LangProviderEnglish
extends LanguageProvider {
    public LangProviderEnglish(DataGenerator gen) {
        super(gen.getPackOutput(), "tardis_refined", "en_us");
    }

    protected void addTranslations() {
        this.add(VortexRegistry.CLOUDS.get().getTranslationKey(), "Clouds");
        this.add(VortexRegistry.FLOW.get().getTranslationKey(), "Flow");
        this.add(VortexRegistry.SPACE.get().getTranslationKey(), "Space");
        this.add(VortexRegistry.WAVES.get().getTranslationKey(), "Waves");
        this.add(VortexRegistry.STARS.get().getTranslationKey(), "Stars");
        this.add(VortexRegistry.TWILIGHT_GLOW.get().getTranslationKey(), "Twilight Glow");
        this.add(VortexRegistry.AURORA_DREAMS.get().getTranslationKey(), "Aurora Dreams");
        this.add(VortexRegistry.DESERT_MIRAGE.get().getTranslationKey(), "Desert Mirage");
        this.add(VortexRegistry.NEON_PULSE.get().getTranslationKey(), "Neon Pulse");
        this.add(VortexRegistry.OCEAN_BREEZE.get().getTranslationKey(), "Ocean Breeze");
        this.add(VortexRegistry.SOLAR_FLARE.get().getTranslationKey(), "Solar Flare");
        this.add(VortexRegistry.CRYSTAL_LAGOON.get().getTranslationKey(), "Crystal Lagoon");
        this.add(VortexRegistry.VELVET_NIGHT.get().getTranslationKey(), "Velvet Night");
        this.add(VortexRegistry.CANDY_POP.get().getTranslationKey(), "Candy Pop");
        this.add(VortexRegistry.EMERALD_FOREST.get().getTranslationKey(), "Emerald Forest");
        this.add(VortexRegistry.LGBT_RAINBOW.get().getTranslationKey(), "LGBT Rainbow");
        this.add(VortexRegistry.TRANSGENDER_FLAG.get().getTranslationKey(), "Transgender Flag");
        this.add(VortexRegistry.BISEXUAL_FLAG.get().getTranslationKey(), "Bisexual Flag");
        this.add(VortexRegistry.LESBIAN_FLAG.get().getTranslationKey(), "Lesbian Flag");
        this.add(VortexRegistry.NON_BINARY_FLAG.get().getTranslationKey(), "Non-Binary Flag");
        this.add(VortexRegistry.AGENDER_FLAG.get().getTranslationKey(), "Agender Flag");
        this.add(VortexRegistry.GAY_FLAG.get().getTranslationKey(), "Gay Flag");
        this.addSound(TRSoundRegistry.TARDIS_LAND.get(), "TARDIS lands");
        this.addSound(TRSoundRegistry.TARDIS_SINGLE_FLY.get(), "TARDIS flies");
        this.addSound(TRSoundRegistry.TARDIS_TAKEOFF.get(), "TARDIS takes off");
        this.addSound(TRSoundRegistry.TARDIS_CRASH_LAND.get(), "TARDIS crash lands");
        this.addSound(TRSoundRegistry.STATIC.get(), "Screen display static");
        this.addSound(TRSoundRegistry.PATTERN_MANIPULATOR.get(), "Pattern Manipulator activates");
        this.addSound(TRSoundRegistry.TARDIS_MISC_SPARKLE.get(), "TARDIS arriving");
        this.addSound(TRSoundRegistry.TIME_BLAST.get(), "Time Vortex blast");
        this.addSound(TRSoundRegistry.DESTINATION_DING.get(), "TARDIS reaches destination");
        this.addSound(TRSoundRegistry.ARS_HUM.get(), "ARS Tree Hum");
        this.addSound(TRSoundRegistry.FLIGHT_FAIL_START.get(), "Failing TARDIS groans");
        this.addSound(TRSoundRegistry.CONSOLE_POWER_ON.get(), "Console power on");
        this.addSound(TRSoundRegistry.INTERIOR_VOICE.get(), "...?");
        this.addSound(TRSoundRegistry.ARTRON_PILLAR_ACTIVE.get(), "Artron pillar activated");
        this.addSound(TRSoundRegistry.CORRIDOR_TELEPORTER.get(), "Teleporter building up");
        this.addSound(TRSoundRegistry.CORRIDOR_TELEPORTER_SUCCESS.get(), "Teleporter used");
        this.addSound(TRSoundRegistry.SCREWDRIVER_CONNECT.get(), "Screwdriver connected position");
        this.addSound(TRSoundRegistry.SCREWDRIVER_SHORT.get(), "Screwdriver used");
        this.addSound(TRSoundRegistry.INTERIOR_CREAKS.get(), "Creaks");
        this.addSound(TRSoundRegistry.SCREWDRIVER_DISCARD.get(), "Screwdriver discard data");
        this.addSound(TRSoundRegistry.GRAVITY_TUNNEL.get(), "Gravity tunnel winds");
        this.addSound(TRSoundRegistry.LOW_FUEL.get(), "Low fuel warning");
        this.addSound(TRSoundRegistry.CLOISTER_BELL.get(), "Cloister Bell");
        this.addSound(TRSoundRegistry.MALLET.get(), "Mallet Hit");
        this.addSound(TRSoundRegistry.ALARM.get(), "Alarm");
        TardisHums.registerDefaultHums();
        for (Map.Entry<ResourceLocation, HumEntry> entry : TardisHums.getDefaultHums().entrySet()) {
            this.addSound(entry.getValue().getSoundEventId(), "TARDIS hums");
        }
        this.add((Block)TRBlockRegistry.ARS_EGG.get(), "ARS Egg");
        this.add(TRBlockRegistry.ARS_LEAVES.get(), "ARS Leaves");
        this.add((Block)TRBlockRegistry.ARS_LEAVES_FENCE.get(), "ARS Fence");
        this.add((Block)TRBlockRegistry.ARS_LEAVES_SLAB.get(), "ARS Slab");
        this.add((Block)TRBlockRegistry.BULK_HEAD_DOOR.get(), "Bulk Head Door");
        this.add((Block)TRBlockRegistry.ROOT_PLANT_BLOCK.get(), "Root Plant");
        this.add((Block)TRBlockRegistry.ROOT_SHELL_BLOCK.get(), "Root Shell");
        this.add(TRBlockRegistry.TERRAFORMER_BLOCK.get(), "Terraformer");
        this.add((Block)TRBlockRegistry.GLOBAL_CONSOLE_BLOCK.get(), "Console");
        this.add((Block)TRBlockRegistry.GLOBAL_DOOR_BLOCK.get(), "Tardis Door");
        this.add((Block)TRBlockRegistry.ROOT_SHELL_DOOR.get(), "Root Door");
        this.add(TRBlockRegistry.AIR_LOCK_GENERATION_BLOCK.get(), "Air Lock Generator");
        this.add((Block)TRBlockRegistry.CONSOLE_CONFIGURATION_BLOCK.get(), "Console Configurator");
        this.add(TRBlockRegistry.LANDING_PAD.get(), "Landing Pad");
        this.add(TRBlockRegistry.FOOLS_STONE.get(), "Fool's Stone");
        this.add((Block)TRBlockRegistry.FLIGHT_DETECTOR.get(), "Flight Detector");
        this.add((Block)TRBlockRegistry.GLOBAL_SHELL_BLOCK.get(), "TARDIS");
        this.add(TRBlockRegistry.ASTRAL_MANIPULATOR_BLOCK.get(), "Astral Manipulator");
        this.add(TRBlockRegistry.ZEITON_FUSED_IRON_BLOCK.get(), "Zeiton Fused Iron Block");
        this.add(TRBlockRegistry.ZEITON_FUSED_COPPER_BLOCK.get(), "Zeiton Fused Copper Block");
        this.add(TRBlockRegistry.ZEITON_ORE.get(), "Zeiton Ore");
        this.add(TRBlockRegistry.ZEITON_ORE_DEEPSLATE.get(), "Deepslate Zeiton Ore");
        this.add(TRBlockRegistry.ZEITON_BLOCK.get(), "Block of Zeiton");
        this.add(TRBlockRegistry.GRAVITY_WELL.get(), "Gravity Well");
        this.add((Block)TRBlockRegistry.ZEITON_LANTERN.get(), "Zeiton Lantern");
        this.add((Block)TRBlockRegistry.ARTRON_PILLAR.get(), "Artron Pillar");
        this.add(TRBlockRegistry.ARTRON_PILLAR_PORT.get(), "Artron Pillar Port");
        this.add(TRBlockRegistry.CORRIDOR_TELEPORTER.get(), "Corridor Teleporter");
        this.add(TRItemRegistry.PATTERN_MANIPULATOR.get(), "Pattern Manipulator");
        this.add(TRItemRegistry.KEY.get(), "Tardis Key");
        this.add(TRItemRegistry.DRILL.get(), "Growth Drill");
        this.add(ModMessages.ITEM_KEYCHAIN, "Tardis Keyset");
        this.add(ModMessages.ITEM_GROUP, "Tardis Refined");
        this.add(TRItemRegistry.SCREWDRIVER.get(), "Amethyst Screwdriver");
        this.add(ModMessages.TOOLTIP_SCREWDRIVER_DESCRIPTION, "An amethyst frequency manipulator");
        this.add(TRItemRegistry.ZEITON_INGOT.get(), "Zeiton Ingot");
        this.add(TRItemRegistry.RAW_ZEITON.get(), "Raw Zeiton");
        this.add(TRItemRegistry.GLASSES.get(), "AR Glasses");
        this.add(TRItemRegistry.ZEITON_NUGGET.get(), "Zeiton Nugget");
        this.add(TRItemRegistry.MALLET.get(), "Mallet");
        this.add(TRItemRegistry.TEST_TUBE.get(), "Test Tube");
        this.add(TRDamageSources.EYE_OF_HARMONY, "%s was fried by time winds.");
        this.add(TRDamageSources.CHOKE, "%s was overwhelmed by toxic fumes");
        this.add(TREntityRegistry.CONTROL_ENTITY.get(), "Generic Control");
        this.addControl(TRControlRegistry.DOOR_TOGGLE.get(), "Door Toggle");
        this.addControl(TRControlRegistry.X.get(), "X");
        this.addControl(TRControlRegistry.Y.get(), "Y");
        this.addControl(TRControlRegistry.Z.get(), "Z");
        this.addControl(TRControlRegistry.INCREMENT.get(), "Increment");
        this.addControl(TRControlRegistry.ROTATE.get(), "Direction");
        this.addControl(TRControlRegistry.RANDOM.get(), "Randomizer");
        this.addControl(TRControlRegistry.THROTTLE.get(), "Throttle");
        this.addControl(TRControlRegistry.MONITOR.get(), "Computer Bank");
        this.addControl(TRControlRegistry.FAST_RETURN.get(), "Fast Return");
        this.addControl(TRControlRegistry.DIMENSION.get(), "Dimension");
        this.addControl(TRControlRegistry.HANDBRAKE.get(), "Handbrake");
        this.addControl(TRControlRegistry.GENERIC_NO_SHOW.get(), "Switch");
        this.addControl(TRControlRegistry.FUEL.get(), "Fuel");
        this.addControl(TRControlRegistry.READOUT.get(), "GPS");
        this.addControl(TRControlRegistry.EXTERIOR_DISPLAY.get(), "Exterior Display");
        String errorPrefix = ChatFormatting.BOLD + ChatFormatting.RED.toString() + "[ERROR] " + ChatFormatting.RESET;
        this.add(ModMessages.MSG_EXTERIOR_COOLDOWN, "You must wait %s seconds");
        this.add(ModMessages.MSG_KEY_BOUND, "Key Bound to %s");
        this.add(ModMessages.MSG_KEY_CYCLED, "Main: %s");
        this.add(ModMessages.CONSOLE_CONFIGURATION_NOT_IN_FLIGHT, errorPrefix + "Cannot update console block whilst in flight");
        this.add(ModMessages.HARDWARE_OFFLINE, errorPrefix + "Insufficient Power!");
        this.add(ModMessages.NO_FLIGHT_TRANSITIVE, "Cannot change handbrake state whilst in transitive flight");
        this.add(ModMessages.HANDBRAKE_WARNING, "Ship is in flight. Left click the handbrake to engage");
        this.add(ModMessages.CONSOLE_NOT_IN_FLIGHT, "Cannot change consoles whilst in flight");
        this.add(ModMessages.NO_END_DRAGON_PREVENTS, "A dragon prevents you from progressing to The End");
        this.add(ModMessages.TARDIS_IS_ON_THE_WAY, "TARDIS has been summoned and is on the way");
        this.add(ModMessages.LANDING_PAD_NOT_UNLOCKED, errorPrefix + "Specified TARDIS rejected landing pad signal");
        this.add(ModMessages.LANDING_PAD_TRANSIENT, errorPrefix + "Cannot summon TARDIS at this time!");
        this.add(ModMessages.LANDING_PAD_BANNED_DIM, errorPrefix + "You cannot summon the TARDIS to this Dimension!");
        this.add(ModMessages.REFUEL, "Enabled refuelling");
        this.add(ModMessages.STOP_REFUEL, "Stopped refuelling");
        this.add(ModMessages.NO_DESKTOP_NO_FUEL, errorPrefix + "Not enough fuel to start the reconfiguration process");
        this.add(ModMessages.ASTRAL_MANIPULATOR_ENGAGED, "Please make your selection. Right click again to confirm");
        this.add(ModMessages.ROOT_PLANT_CUT_OPEN, "Roots cover the entrance");
        this.add(ModMessages.FUEL, "Fuel: %s");
        this.add(ModMessages.FUEL_OFFLINE, errorPrefix + "Fuel offline");
        this.add(ModMessages.WAYPOINT_LOADED, "Preloaded waypoint: %s");
        this.add(ModMessages.HANDBRAKE_ENGAGED, "Handbrake engaged");
        this.add(ModMessages.HANDBRAKE_DISENGAGED, "Handbrake disengaged");
        this.add(ModMessages.CURRENT, "CURRENT");
        this.add(ModMessages.DESTINATION, "DESTINATION");
        this.add(ModMessages.DOOR_LOCKED, "Door locked");
        this.add(ModMessages.DOOR_UNLOCKED, "Door unlocked");
        this.add(ModMessages.RECOVERY_PROGRESS, "Recovery Progress: %s");
        this.add(ModMessages.SUBMIT, "Submit");
        this.add(ModMessages.VILLAGER_CAN_FLY, "Pilot?");
        this.add(ModMessages.PILOT_TIME, "You've still got %s with your pilot. Make the most of it!");
        this.add(ModMessages.DEMANDS_PAYMENT, "Demands payment");
        this.add(ModMessages.TARDIS_SLEEP_END, "The hums of the ship make you toss and turn. Your spawnpoint could not be set here.");
        this.add(ModMessages.CMD_DIM_NOT_A_TARDIS, ChatFormatting.RED + "%s is not a TARDIS Dimension!");
        this.add(ModMessages.CMD_NO_INTERNAL_DOOR, ChatFormatting.RED + "No Internal Door found in dimension %s! Consider using the default teleport command %s");
        this.add(ModMessages.CMD_EXPORT_DESKTOP_IN_PROGRESS, "Generating datapack for desktop %s, this may take some time depending on the structure's size...");
        this.add(ModMessages.CMD_EXPORT_DESKTOP_SUCCESS, ChatFormatting.GREEN + "Successfully exported desktop %s to datapack %s! Use the %s command to see changes.");
        this.add(ModMessages.CMD_EXPORT_DESKTOP_RESOURCE_PACK, ChatFormatting.BLUE + "To define the Desktop's preview image, please create a Resource Pack. See some example Resource Packs at: %s");
        this.add(ModMessages.CMD_EXPORT_DESKTOP_FAIL, ChatFormatting.RED + "Failed to export desktop %s!");
        this.add(ModMessages.CMD_LEVEL_POINT_GET, "%s has %s upgrade points");
        this.add(ModMessages.CMD_LEVEL_POINT_SET, "Set upgrade points for %s to %s");
        this.add(ModMessages.CMD_LEVEL_POINT_ADD, "Added %s points for %s, total points are now %s");
        this.add(ModMessages.CMD_LEVEL_XP_GET, "%s has %s XP");
        this.add(ModMessages.CMD_LEVEL_XP_SET, "Set XP for %s to %s");
        this.add(ModMessages.CMD_LEVEL_XP_ADD, "Added %s XP for %s, total XP is now %s");
        this.add(ModMessages.CMD_UPGRADE_LOCK, "Locked upgrade %s for %s");
        this.add(ModMessages.CMD_UPGRADE_UNLOCK, "Unlocked upgrade %s for %s");
        this.add(ModMessages.CMD_CREATE_TARDIS_IN_PROGRESS, "Attempting to create Tardis %s, generation in progress");
        this.add(ModMessages.CMD_CREATE_TARDIS_SUCCESS, "Successfully created Tardis with id %s");
        this.add(ModMessages.CMD_ARG_UPGRADE_INVALID, "Invalid Upgrade of ID %s");
        this.add(ModMessages.CMD_ARG_DESKTOP_INVALID, "Invalid Desktop of ID %s");
        this.add(ModMessages.CMD_ARG_SHELL_INVALID, "Invalid Shell of ID %s");
        this.add(ModMessages.UI_MONITOR_MAIN_TITLE, "COMPUTER BANK");
        this.add(ModMessages.UI_MONITOR_WAYPOINTS, "WAYPOINTS");
        this.add(ModMessages.UI_MONITOR_UPLOAD_WAYPOINTS, "WAYPOINT NAVIGATION");
        this.add(ModMessages.UI_MONITOR_UPLOAD_COORDS, "COORD NAVIGATION");
        this.add(ModMessages.UI_MONITOR_SELECT_HUM, "SOUNDSCAPE");
        this.add(ModMessages.UI_MONITOR_GPS, "GPS");
        this.add(ModMessages.UI_MONITOR_VORTEX, "VORTEX");
        this.add(ModMessages.UI_MONITOR_DESTINATION, "Destination");
        this.add(ModMessages.UI_LIST_SELECTION, "Currently selected: &s");
        this.add(ModMessages.UI_EXTERNAL_SHELL, "SHELL CONFIGURATION");
        this.add(ModMessages.UI_MONITOR_SHELL_VIEW, "SHELL VIEW");
        this.add(ModMessages.UI_DESKTOP_CONFIGURATION, "DESKTOP");
        this.add(ModMessages.UI_DESKTOP_CANCEL_TITLE, "OPERATION IN PROGRESS");
        this.add(ModMessages.UI_DESKTOP_CANCEL_DESCRIPTION, "Systems disabled as a Desktop reconfiguration has been scheduled.");
        this.add(ModMessages.UI_DESKTOP_CANCEL_DESKTOP, "Would you like to cancel the upcoming reconfiguration?");
        this.add(ModMessages.UI_DESKTOP_CANCEL, "Cancel Desktop Reconfiguration");
        this.add(ModMessages.UI_MONITOR_NO_WAYPOINTS, "No Waypoints Saved!");
        this.add(ModMessages.UI_MONITOR_WAYPOINT_UPLOAD, "Upload");
        this.add(ModMessages.UI_MONITOR_ISSUES, "Issues:");
        this.add(ModMessages.UI_MONITOR_WAYPOINT_ISSUE_NAME, "Invalid waypoint name");
        this.add(ModMessages.UI_MONITOR_WAYPOINT_ISSUE_X, "Invalid X value");
        this.add(ModMessages.UI_MONITOR_WAYPOINT_ISSUE_Y, "Invalid Y value");
        this.add(ModMessages.UI_MONITOR_WAYPOINT_ISSUE_Z, "Invalid Z value");
        this.add(ModMessages.UI_MONITOR_WAYPOINT_NAME, "Waypoint Name:");
        this.add(ModMessages.UI_UPGRADES, "Tardis Upgrades");
        this.add(ModMessages.UI_UPGRADES_BUY, "Purchase upgrade?");
        this.add(ModMessages.UI_NO_INSTALLED_SUBSYSTEMS, "No available sub-systems");
        this.add("monitor.waypoints.name.placeholder", "Waypoint name");
        this.add("monitor.waypoints.new_waypoint", "New Waypoint");
        this.add("monitor.waypoints.taken", "Data retrieved from destination values");
        this.add(ModMessages.UI_MONITOR_WAYPOINT_LOAD, "Send to console");
        this.add(ModMessages.UI_MONITOR_WAYPOINT_CREATE, "New waypoint");
        this.add(ModMessages.UI_MONITOR_WAYPOINT_EDIT, "Edit waypoint");
        this.add(ModMessages.UI_MONITOR_WAYPOINT_DELETE, "Delete waypoint");
        this.add(ModMessages.CANNOT_START_NO_FUEL, "Not enough fuel to start");
        this.add(ModMessages.UI_MONITOR_EJECT, "EMERGENCY EJECT");
        this.add(ModMessages.UI_EJECT_CANNOT_IN_FLIGHT, "Cannot eject whilst in flight");
        this.add(ModMessages.DIM_NOT_ALLOWED, "This dimension cannot be sampled");
        this.add(ModMessages.DIM_ALREADY_SAVED, "Already contains a sample");
        this.add(ModMessages.DIM_POTENTIAL, "Sampled %s");
        this.add(ModMessages.DIM_ADDED_TO_TARDIS, "Added %s to Data Banks");
        this.add(ModMessages.DOOR_STATUS, "Door: %s");
        this.add(ModMessages.LOCK_STATUS, "Locked: %s");
        this.add(ModMessages.POSITION, "Position: %s");
        this.add(ModMessages.IN_FLIGHT, "Flight: %s");
        this.add(ModMessages.DIRECTION, "Direction: %s");
        this.add(ModMessages.DIMENSION, "Dimension: %s");
        this.add(ModMessages.createDisplaySource("fuel"), "Fuel");
        this.add(ModMessages.createDisplaySource("gps"), "GPS");
        this.add(ModMessages.createDisplaySource("destination"), "GPS Destination");
        this.add(ModMessages.createDisplaySource("tardis_bigdata"), "Tardis Summary");
        this.add(ModMessages.createDisplaySource("door"), "Door Status");
        this.add(ModMessages.createDisplaySource("locked"), "Lock Status");
        this.add("curios.identifier.timelord_sight", "AR Glasses");
        this.addShell(ShellTheme.FACTORY.getId(), "Factory");
        this.addShell(ShellTheme.POLICE_BOX.getId(), "Police Box");
        this.addShell(ShellTheme.PHONE_BOOTH.getId(), "Phone Booth");
        this.addShell(ShellTheme.MYSTIC.getId(), "Mystic");
        this.addShell(ShellTheme.DRIFTER.getId(), "Drifter");
        this.addShell(ShellTheme.PRESENT.getId(), "Present");
        this.addShell(ShellTheme.BRIEFCASE.getId(), "Briefcase");
        this.addShell(ShellTheme.GROENING.getId(), "Groening");
        this.addShell(ShellTheme.VENDING.getId(), "Vending Machine");
        this.addShell(ShellTheme.BIG_BEN.getId(), "Big Ben");
        this.addShell(ShellTheme.NUKA.getId(), "Nuka");
        this.addShell(ShellTheme.GROWTH.getId(), "Growth");
        this.addShell(ShellTheme.PORTALOO.getId(), "Portaloo");
        this.addShell(ShellTheme.PAGODA.getId(), "Pagoda");
        this.addShell(ShellTheme.LIFT.getId(), "Lift");
        this.addShell(ShellTheme.HIEROGLYPH.getId(), "Hieroglyph");
        this.addShell(ShellTheme.CASTLE.getId(), "Castle");
        this.addShell(ShellTheme.PATHFINDER.getId(), "Pathfinder");
        this.addShell(ShellTheme.HALF_BAKED.getId(), "Half Baked");
        this.addShell(ShellTheme.SHULKER.getId(), "Shulker Box");
        this.add(ModMessages.TOOLTIP_TARDIS_LIST_TITLE, ChatFormatting.YELLOW + "< " + ChatFormatting.GOLD + "Key Set:" + ChatFormatting.YELLOW + " >");
        this.add(ModMessages.TOOLTIP_DIM_PROGRESS, ChatFormatting.GREEN + "Decoding Sample: %s");
        this.add(ModMessages.TOOLTIP_DIM_SAVED, ChatFormatting.GOLD + "Saved Sample: %s");
        this.add(ModMessages.TOOLTIP_NO_DIM_SAVED, ChatFormatting.GRAY + "No Dimension Sample");
        this.add(ModMessages.CONTROL_DIMENSION_SELECTED, "Selected: %s");
        this.add(ModMessages.CONFIG_IP_COMPAT, "Immersive Portals Compatibility?");
        this.add(ModMessages.CONFIG_CONTROL_NAMES, "Render control names?");
        this.add(ModMessages.CONFIG_BANNED_DIMENSIONS, "Banned Dimensions");
        this.add(ModMessages.CONFIG_IDLE_CONSOLE_ANIMS, "Play idle console animations");
        this.add(ModMessages.CONFIG_RENDER_VORTEX_IN_DOOR, "Render Vortex within interior door");
        this.add(ModMessages.CONFIG_CUSTOM_SHADERS, "Use Custom Shaders");
        this.add(ModMessages.ASCEND_KEY, "Ascend: %s");
        this.add(ModMessages.DESCEND_KEY, "Descend: %s");
        this.add(ModMessages.EXIT_EXTERNAL_VIEW, "Exit Shell View: ");
        this.addUpgrade(TRUpgrades.CHAMELEON_CIRCUIT_SYSTEM.get(), "Chameleon Circuit", "Allows the TARDIS to change it's shape");
        this.addUpgrade(TRUpgrades.DEFENSE_SYSTEM.get(), "Defense System", "Enables Defense Protocols");
        this.addUpgrade(TRUpgrades.WAYPOINTS.get(), "Waypoints", "Allows the Pilot to create saved locations");
        this.addUpgrade(TRUpgrades.NAVIGATION_SYSTEM.get(), "Navigation System", "Allows upgrades to the TARDIS Navigation System");
        this.addUpgrade(TRUpgrades.TARDIS_XP.get(), "System Upgrades", "Allows upgrades to the TARDIS");
        this.addUpgrade(TRUpgrades.MATERIALIZE_AROUND.get(), "Materialize Around", "Allows the TARDIS to have entities enter while materalizing");
        this.addUpgrade(TRUpgrades.ARCHITECTURE_SYSTEM.get(), "Architecture", "Enables TARDIS Architecture Upgrades");
        this.addUpgrade(TRUpgrades.INSIDE_ARCHITECTURE.get(), "Desktop Reconfiguration", "Allows the Pilot to change the appearance of the TARDIS Desktop");
        this.addUpgrade(TRUpgrades.EXPLORER.get(), "Explorer I", "x1000 Increment");
        this.addUpgrade(TRUpgrades.EXPLORER_II.get(), "Explorer II", "x2500 Increment");
        this.addUpgrade(TRUpgrades.EXPLORER_III.get(), "Explorer III", "x5000 Increment");
        this.addUpgrade(TRUpgrades.DIMENSION_TRAVEL.get(), "Inter-Dimensional Travel", "Allows the TARDIS to move between dimensions");
        this.addUpgrade(TRUpgrades.LANDING_PAD.get(), "Landing Pad", "Allows the TARDIS to be summoned to a landing pad");
        this.addUpgrade(TRUpgrades.IMPROVED_GENERATION_TIME_I.get(), "Improved Generation I", "Lowers desktop wait times to 120 seconds");
        this.addUpgrade(TRUpgrades.IMPROVED_GENERATION_TIME_II.get(), "Improved Generation II", "Lowers desktop wait times to 60 seconds");
        this.addUpgrade(TRUpgrades.IMPROVED_GENERATION_TIME_III.get(), "Improved Generation III", "Lowers desktop wait times to 10 seconds");
        this.addUpgrade(TRUpgrades.FLIGHT_SYSTEM.get(), "Flight System", "Allows upgrades to the TARDIS Flight System");
        this.addUpgrade(TRUpgrades.SPEED_I.get(), "Speed I", "Flight speed is 5x faster");
        this.addUpgrade(TRUpgrades.SPEED_II.get(), "Speed II", "Flight speed is 10x faster");
        this.addUpgrade(TRUpgrades.SPEED_III.get(), "Speed III", "Flight speed is 25x faster");
        this.addUpgrade(TRUpgrades.SPEED_IV.get(), "Speed IV", "Flight speed is 50x faster");
        this.add(ModMessages.KEYBIND_EXIT_VIEW, "Exit Shell View");
        this.add(ModMessages.KEYBIND_TOGGLE_INFO_EXTERIOR_VIEW, "(Shell View) Toggle Info");
    }

    public void addControl(Control control, String name) {
        this.add(control.getTranslationKey(), name);
    }

    public void addShell(ResourceLocation theme, String name) {
        this.add(ModMessages.shell(theme.m_135815_()), name);
    }

    public void addUpgrade(Upgrade upgrade, String title, String description) {
        this.add(Util.m_137492_((String)"upgrade", (ResourceLocation)TRUpgrades.UPGRADE_DEFERRED_REGISTRY.getKey(upgrade)), title);
        this.add(Util.m_137492_((String)"upgrade", (ResourceLocation)TRUpgrades.UPGRADE_DEFERRED_REGISTRY.getKey(upgrade)) + ".description", description);
    }

    public void addSound(SoundEvent soundEvent, String lang) {
        String subtitleKey = SoundProvider.createSubtitle(soundEvent.m_11660_().m_135815_());
        this.add(subtitleKey, lang);
    }

    public void addSound(ResourceLocation soundId, String lang) {
        String subtitleKey = SoundProvider.createSubtitle(soundId.m_135815_());
        this.add(subtitleKey, lang);
    }

    public void add(ResourceKey<DamageType> damageSource, String message) {
        this.add("death.attack." + damageSource.m_135782_().m_135815_(), message);
        this.add("death.attack." + damageSource.m_135782_().m_135815_() + ".player", message);
    }
}

