/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.data;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import whocraft.tardis_refined.TardisRefined;
import whocraft.tardis_refined.common.crafting.astral_manipulator.ManipulatorCraftingRecipe;
import whocraft.tardis_refined.common.crafting.astral_manipulator.ManipulatorCraftingRecipeSerializer;
import whocraft.tardis_refined.common.crafting.astral_manipulator.ManipulatorRecipes;

public class ManipulatorRecipeProvider
implements DataProvider {
    protected final DataGenerator generator;
    private final boolean addDefaults;
    private final String modid;
    protected Map<ResourceLocation, ManipulatorCraftingRecipe> data = new HashMap<ResourceLocation, ManipulatorCraftingRecipe>();

    public ManipulatorRecipeProvider(DataGenerator generator, String modid) {
        this(generator, modid, true);
    }

    public ManipulatorRecipeProvider(DataGenerator generator, String modid, boolean addDefaults) {
        Preconditions.checkNotNull((Object)generator);
        this.generator = generator;
        this.modid = modid;
        this.addDefaults = addDefaults;
    }

    protected void addRecipes() {
    }

    public CompletableFuture<?> m_213708_(CachedOutput arg) {
        this.data.clear();
        ArrayList futures = new ArrayList();
        if (this.addDefaults) {
            ManipulatorRecipes.registerRecipes();
            this.data.putAll(ManipulatorRecipes.MANIPULATOR_CRAFTING_RECIPES);
        }
        this.addRecipes();
        if (!this.data.isEmpty()) {
            this.data.entrySet().forEach(entry -> {
                try {
                    ManipulatorCraftingRecipe recipe = (ManipulatorCraftingRecipe)entry.getValue();
                    JsonObject currentRecipe = ((JsonElement)ManipulatorCraftingRecipe.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)recipe).get().ifLeft(element -> {
                        JsonObject json = element.getAsJsonObject();
                        json.addProperty("type", ManipulatorCraftingRecipeSerializer.SERIALIZER_ID.toString());
                    }).ifRight(right -> TardisRefined.LOGGER.error(right.message())).orThrow()).getAsJsonObject();
                    String outputPath = "data/" + recipe.m_6423_().m_135827_() + "/recipes/astral_manipulator/" + recipe.m_6423_().m_135815_().replace("/", "_") + ".json";
                    futures.add(DataProvider.m_253162_((CachedOutput)arg, (JsonElement)currentRecipe, (Path)this.generator.getPackOutput().m_245114_().resolve(outputPath)));
                }
                catch (Exception exception) {
                    TardisRefined.LOGGER.error("Issue writing ManipulatorRecipe {}! Error: {}", (Object)((ManipulatorCraftingRecipe)entry.getValue()).m_6423_(), (Object)exception.getMessage());
                }
            });
        }
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    public String m_6055_() {
        return "AstralManipulatorRecipes";
    }

    protected void addRecipe(ResourceLocation id, ManipulatorCraftingRecipe recipe) {
        TardisRefined.LOGGER.info("Adding astral manipulator recipe to datagen {}", (Object)id);
        this.data.put(id, recipe.setRegistryId(id));
    }
}

