/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.data;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import whocraft.tardis_refined.patterns.ShellPattern;
import whocraft.tardis_refined.patterns.ShellPatternCollection;
import whocraft.tardis_refined.patterns.ShellPatterns;

public class ShellPatternProvider
implements DataProvider {
    protected final DataGenerator generator;
    private final boolean addDefaults;
    private final String modid;
    protected Map<ResourceLocation, ShellPatternCollection> data = new HashMap<ResourceLocation, ShellPatternCollection>();
    public static Logger LOGGER = LogManager.getLogger((String)"TardisRefined/ShellPatternProvider");

    public ShellPatternProvider(DataGenerator generator, String modid) {
        this(generator, modid, true);
    }

    public ShellPatternProvider(DataGenerator generator, String modid, boolean addDefaults) {
        Preconditions.checkNotNull((Object)generator);
        this.generator = generator;
        this.addDefaults = addDefaults;
        this.modid = modid;
    }

    protected void addPatterns() {
    }

    public CompletableFuture<?> m_213708_(CachedOutput arg) {
        this.data.clear();
        ArrayList futures = new ArrayList();
        if (this.addDefaults) {
            ShellPatterns.registerDefaultPatterns();
            this.data.putAll(ShellPatterns.getDefaultPatternsDatagen());
        }
        this.addPatterns();
        if (!this.data.isEmpty()) {
            this.data.forEach((key, patternCollection) -> {
                try {
                    JsonObject currentPatternCollection = ((JsonElement)ShellPatternCollection.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, patternCollection).get().ifRight(right -> LOGGER.error(right.message())).orThrow()).getAsJsonObject();
                    Path output = this.getPath(patternCollection.themeId());
                    futures.add(DataProvider.m_253162_((CachedOutput)arg, (JsonElement)currentPatternCollection, (Path)output));
                }
                catch (Exception exception) {
                    LOGGER.error("Issue writing ShellPatternCollection {}! Error: {}", (Object)patternCollection.themeId(), (Object)exception.getMessage());
                }
            });
        }
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    public ShellPattern addPattern(ResourceLocation themeId, ShellPattern shellPattern) {
        ShellPattern pattern = (ShellPattern)shellPattern.setThemeId(themeId);
        if (this.data.containsKey(themeId)) {
            ShellPatternCollection collection = this.data.get(themeId);
            ArrayList currentList = new ArrayList(collection.patterns());
            currentList.add(pattern);
            collection.setPatterns(currentList);
            this.data.replace(themeId, collection);
        } else {
            ShellPatternCollection collection = (ShellPatternCollection)new ShellPatternCollection(List.of(pattern)).setThemeId(themeId);
            this.data.put(themeId, collection);
        }
        LOGGER.info("Adding ShellPattern {} for {}", (Object)pattern.id(), (Object)themeId);
        return pattern;
    }

    public ResourceLocation exteriorTextureLocation(ResourceLocation themeId) {
        return new ResourceLocation(themeId.m_135827_(), "textures/blockentity/shell/" + themeId.m_135815_() + "/" + themeId.m_135815_() + ".png");
    }

    public ResourceLocation interiorTextureLocation(ResourceLocation themeId) {
        return new ResourceLocation(themeId.m_135827_(), "textures/blockentity/shell/" + themeId.m_135815_() + "/" + themeId.m_135815_() + "_interior.png");
    }

    protected Path getPath(ResourceLocation themeId) {
        return this.generator.getPackOutput().m_245114_().resolve("data/" + this.modid + "/tardis_refined/patterns/shell/" + themeId.m_135815_() + ".json");
    }

    public String m_6055_() {
        return "Shell Patterns";
    }
}

