/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.network.messages;

import java.util.Optional;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.network.MessageC2S;
import whocraft.tardis_refined.common.network.MessageContext;
import whocraft.tardis_refined.common.network.MessageType;
import whocraft.tardis_refined.common.network.TardisNetwork;

public class C2SChangeVortex
extends MessageC2S {
    private final ResourceKey<Level> resourceKey;
    private final ResourceLocation vortex;

    public C2SChangeVortex(ResourceKey<Level> tardisLevel, ResourceLocation theme) {
        this.resourceKey = tardisLevel;
        this.vortex = theme;
    }

    public C2SChangeVortex(FriendlyByteBuf buffer) {
        this.resourceKey = buffer.m_236801_(Registries.f_256858_);
        this.vortex = buffer.m_130281_();
    }

    @Override
    @NotNull
    public MessageType getType() {
        return TardisNetwork.CHANGE_VORTEX;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_236858_(this.resourceKey);
        buf.m_130085_(this.vortex);
    }

    @Override
    public void handle(MessageContext context) {
        Optional<ServerLevel> level = Optional.ofNullable((ServerLevel)context.getPlayer().m_20194_().f_129762_.get(this.resourceKey));
        level.flatMap(TardisLevelOperator::get).ifPresent(y -> y.getAestheticHandler().setVortex(this.vortex));
    }
}

