/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.network.messages.hums;

import java.util.Optional;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import whocraft.tardis_refined.client.TardisClientData;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.network.MessageC2S;
import whocraft.tardis_refined.common.network.MessageContext;
import whocraft.tardis_refined.common.network.MessageType;
import whocraft.tardis_refined.common.network.TardisNetwork;
import whocraft.tardis_refined.common.soundscape.hum.HumEntry;
import whocraft.tardis_refined.common.soundscape.hum.TardisHums;
import whocraft.tardis_refined.common.tardis.manager.TardisInteriorManager;

public class C2SChangeHum
extends MessageC2S {
    private final ResourceKey<Level> resourceKey;
    private final HumEntry humEntry;

    public C2SChangeHum(ResourceKey<Level> tardisLevel, HumEntry humEntry) {
        this.resourceKey = tardisLevel;
        this.humEntry = humEntry;
    }

    public C2SChangeHum(FriendlyByteBuf buffer) {
        this.resourceKey = buffer.m_236801_(Registries.f_256858_);
        this.humEntry = TardisHums.getHumById(buffer.m_130281_());
    }

    @Override
    @NotNull
    public MessageType getType() {
        return TardisNetwork.CHANGE_HUM;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_236858_(this.resourceKey);
        buf.m_130085_(this.humEntry.getIdentifier());
    }

    @Override
    public void handle(MessageContext context) {
        Optional<ServerLevel> level = Optional.ofNullable((ServerLevel)context.getPlayer().m_20194_().f_129762_.get(this.resourceKey));
        level.ifPresent(x -> TardisLevelOperator.get(x).ifPresent(operator -> {
            TardisInteriorManager tardisInteriorManager = operator.getInteriorManager();
            TardisClientData tardisClientData = operator.tardisClientData();
            tardisInteriorManager.setHumEntry(this.humEntry);
            tardisClientData.setHumEntry(this.humEntry);
            tardisClientData.sync();
        }));
    }
}

