/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.network.messages.upgrades;

import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import org.jetbrains.annotations.NotNull;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.capability.tardis.upgrades.Upgrade;
import whocraft.tardis_refined.common.capability.tardis.upgrades.UpgradeHandler;
import whocraft.tardis_refined.common.network.MessageC2S;
import whocraft.tardis_refined.common.network.MessageContext;
import whocraft.tardis_refined.common.network.MessageType;
import whocraft.tardis_refined.common.network.TardisNetwork;
import whocraft.tardis_refined.common.network.messages.upgrades.S2CDisplayUpgradeScreen;
import whocraft.tardis_refined.registry.TRUpgrades;

public class C2SUnlockUpgrade
extends MessageC2S {
    private final Upgrade upgrade;

    public C2SUnlockUpgrade(Upgrade upgrade) {
        this.upgrade = upgrade;
    }

    public C2SUnlockUpgrade(FriendlyByteBuf buf) {
        this.upgrade = TRUpgrades.UPGRADE_DEFERRED_REGISTRY.get(buf.m_130281_());
    }

    @Override
    @NotNull
    public MessageType getType() {
        return TardisNetwork.UNLOCK_UPGRADE;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130085_(Objects.requireNonNull(TRUpgrades.UPGRADE_DEFERRED_REGISTRY.getKey(this.upgrade)));
    }

    @Override
    public void handle(MessageContext context) {
        ServerLevel serverLevel = context.getPlayer().m_284548_();
        TardisLevelOperator.get(serverLevel).ifPresent(tardisLevelOperator -> {
            boolean available;
            UpgradeHandler upgradeHandler = tardisLevelOperator.getUpgradeHandler();
            boolean bl = available = !upgradeHandler.isUpgradeUnlocked(this.upgrade) && upgradeHandler.getUpgradePoints() >= this.upgrade.getSkillPointsRequired();
            if (available) {
                upgradeHandler.setUpgradePoints(upgradeHandler.getUpgradePoints() - this.upgrade.getSkillPointsRequired());
                upgradeHandler.unlockUpgrade(this.upgrade);
                CompoundTag nbt = upgradeHandler.saveData(new CompoundTag());
                new S2CDisplayUpgradeScreen(nbt).send(context.getPlayer());
            }
        });
    }
}

