/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.network.messages.waypoints;

import java.util.ArrayList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import whocraft.tardis_refined.client.screen.waypoints.CoordInputType;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.network.MessageC2S;
import whocraft.tardis_refined.common.network.MessageContext;
import whocraft.tardis_refined.common.network.MessageType;
import whocraft.tardis_refined.common.network.TardisNetwork;
import whocraft.tardis_refined.common.network.messages.waypoints.S2COpenCoordinatesDisplayMessage;
import whocraft.tardis_refined.common.tardis.TardisNavLocation;
import whocraft.tardis_refined.common.tardis.manager.TardisPilotingManager;

public class C2SOpenCoordinatesDisplayMessage
extends MessageC2S {
    private CoordInputType coordInput;

    public C2SOpenCoordinatesDisplayMessage(CoordInputType coordInputType) {
        this.coordInput = coordInputType;
    }

    public C2SOpenCoordinatesDisplayMessage(FriendlyByteBuf friendlyByteBuf) {
        this.coordInput = CoordInputType.valueOf(friendlyByteBuf.m_130277_());
    }

    @Override
    @NotNull
    public MessageType getType() {
        return TardisNetwork.CLIENT_OPEN_COORDS_DISPLAY;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130070_(this.coordInput.name());
    }

    @Override
    public void handle(MessageContext context) {
        ServerPlayer serverPlayer = context.getPlayer();
        ServerLevel level = serverPlayer.m_284548_();
        TardisLevelOperator.get(level).ifPresent(tardisLevelOperator -> {
            ArrayList<ResourceKey<Level>> dimensions = tardisLevelOperator.getProgressionManager().getDiscoveredLevels();
            TardisPilotingManager pilotManager = tardisLevelOperator.getPilotingManager();
            TardisNavLocation tardisTarget = pilotManager.getTargetLocation() == null ? TardisNavLocation.ORIGIN : pilotManager.getTargetLocation();
            new S2COpenCoordinatesDisplayMessage(dimensions, this.coordInput, tardisTarget).send(serverPlayer);
        });
    }
}

