/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.network.messages.waypoints;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import whocraft.tardis_refined.client.ScreenHandler;
import whocraft.tardis_refined.client.screen.waypoints.CoordInputType;
import whocraft.tardis_refined.common.network.MessageContext;
import whocraft.tardis_refined.common.network.MessageS2C;
import whocraft.tardis_refined.common.network.MessageType;
import whocraft.tardis_refined.common.network.TardisNetwork;
import whocraft.tardis_refined.common.tardis.TardisNavLocation;

public class S2COpenCoordinatesDisplayMessage
extends MessageS2C {
    CoordInputType coordInputType;
    private TardisNavLocation tardisNavLocation;
    private List<ResourceKey<Level>> levels;

    public S2COpenCoordinatesDisplayMessage(List<ResourceKey<Level>> waypoints, CoordInputType coordInputType, TardisNavLocation tardisNavLocation) {
        this.levels = waypoints;
        this.coordInputType = coordInputType;
        this.tardisNavLocation = tardisNavLocation;
    }

    public S2COpenCoordinatesDisplayMessage(FriendlyByteBuf friendlyByteBuf) {
        CompoundTag tardisNav = friendlyByteBuf.m_130260_();
        this.tardisNavLocation = TardisNavLocation.deserialize(tardisNav);
        this.coordInputType = CoordInputType.valueOf(friendlyByteBuf.m_130277_());
        this.levels = new ArrayList<ResourceKey<Level>>();
        int size = friendlyByteBuf.readInt();
        for (int i = 0; i < size; ++i) {
            ResourceKey levelResourceKey = friendlyByteBuf.m_236801_(Registries.f_256858_);
            this.levels.add((ResourceKey<Level>)levelResourceKey);
        }
    }

    @Override
    @NotNull
    public MessageType getType() {
        return TardisNetwork.SERVER_OPEN_COORDS_DISPLAY;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130079_(this.tardisNavLocation.serialise());
        buf.m_130070_(this.coordInputType.name());
        buf.writeInt(this.levels.size());
        for (ResourceKey<Level> levelResourceKey : this.levels) {
            buf.m_236858_(levelResourceKey);
        }
    }

    @Override
    public void handle(MessageContext context) {
        this.handleDisplay();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleDisplay() {
        ScreenHandler.openCoordinatesScreen(this.levels, this.coordInputType, this.tardisNavLocation);
    }
}

