/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.soundscape.hum;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import whocraft.tardis_refined.TardisRefined;
import whocraft.tardis_refined.common.util.MiscHelper;
import whocraft.tardis_refined.common.util.RegistryHelper;

public class HumEntry {
    private static final Codec<HumEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("id").forGetter(HumEntry::getIdentifier), (App)ResourceLocation.f_135803_.fieldOf("hum_sound").forGetter(HumEntry::getSoundEventId), (App)Codec.list((Codec)ResourceLocation.f_135803_).fieldOf("ambient_sounds").forGetter(HumEntry::getAmbientSounds), (App)Codec.STRING.orElse((Object)"Placeholder").fieldOf("name_component").forGetter(HumEntry::getNameComponent)).apply((Applicative)instance, HumEntry::new));
    private final ResourceLocation identifier;
    private ResourceLocation soundEventId;
    private List<ResourceLocation> ambientSounds;
    private String nameComponent;

    public HumEntry(ResourceLocation identifier, ResourceLocation soundEventId, List<ResourceLocation> ambientSounds, String nameComponent) {
        this.identifier = identifier;
        this.soundEventId = soundEventId;
        this.ambientSounds = ambientSounds;
        this.nameComponent = nameComponent;
    }

    public HumEntry(ResourceLocation identifier, ResourceLocation soundEventId, List<ResourceLocation> ambientSounds) {
        this(identifier, soundEventId, ambientSounds, TardisRefined.GSON.toJson((Object)Component.m_237113_((String)MiscHelper.getCleanName(identifier.m_135815_())).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD))));
    }

    public HumEntry(String identifier, ResourceLocation soundEventId, List<ResourceLocation> ambientSounds) {
        this(RegistryHelper.makeKey(identifier), soundEventId, ambientSounds);
    }

    public HumEntry(String identifier, ResourceLocation soundEventId) {
        this(identifier, soundEventId, new ArrayList<ResourceLocation>());
    }

    public static Codec<HumEntry> codec() {
        return CODEC;
    }

    public ResourceLocation getSoundEventId() {
        return this.soundEventId;
    }

    public HumEntry setSoundEventId(ResourceLocation soundEventId) {
        this.soundEventId = soundEventId;
        return this;
    }

    public ResourceLocation getIdentifier() {
        return this.identifier;
    }

    public List<ResourceLocation> getAmbientSounds() {
        return this.ambientSounds;
    }

    public HumEntry setAmbientSounds(List<ResourceLocation> ambientSounds) {
        this.ambientSounds = ambientSounds;
        return this;
    }

    public String getNameComponent() {
        return this.nameComponent;
    }

    public void setNameComponent(String nameComponent) {
        this.nameComponent = nameComponent;
    }
}

