/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.tardis;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.InkSacItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import whocraft.tardis_refined.common.util.Platform;
import whocraft.tardis_refined.common.util.PlayerUtil;
import whocraft.tardis_refined.registry.TRBlockRegistry;

public class CorridorGenerator {
    private static int TEMPLATE_SIZE = 8;
    private static int PLACEMENT_OFFSET = 6;

    public static void onAttemptToUse(ServerLevel level, ItemStack itemStack, BlockPos blockPos, Player player) {
        if (!Platform.isProduction()) {
            if (itemStack.m_41720_() == Items.f_42657_) {
                String name = "gs_r" + level.m_213780_().m_188503_(1000);
                StructureTemplateManager manager = level.m_7654_().m_236738_();
                StructureTemplate template = manager.m_230359_(new ResourceLocation(name));
                template.m_163802_((Level)level, blockPos.m_7494_(), (Vec3i)new BlockPos(48, 28, 48), false, Blocks.f_50454_);
                template.m_74612_("");
                manager.m_230416_(new ResourceLocation(name));
                PlayerUtil.sendMessage((LivingEntity)player, (Component)Component.m_237115_((String)("Generated structure at: " + name)), false);
            }
            if (itemStack.m_41720_() instanceof InkSacItem) {
                PlayerUtil.sendMessage((LivingEntity)player, (Component)Component.m_237115_((String)"Attempting to generate structure."), false);
                CorridorGenerator.generateFromPosition((Level)level, blockPos, blockPos);
            }
        }
    }

    public static void generateFromPosition(Level level, BlockPos corner, BlockPos resultLocation) {
        BlockState[][] hasBlockVector = new BlockState[8][8];
        for (int x = 0; x < TEMPLATE_SIZE; ++x) {
            for (int z = 0; z < TEMPLATE_SIZE; ++z) {
                hasBlockVector[x][z] = level.m_8055_(new BlockPos(corner.m_123341_() + 1 + x, corner.m_123342_(), corner.m_123343_() + 1 + z));
            }
        }
        for (BlockPos blockPos : BlockPos.m_121940_((BlockPos)corner.m_6630_(9), (BlockPos)new BlockPos(corner.m_6630_(9).m_123341_() + 48, corner.m_6630_(9).m_123342_() + 28, corner.m_6630_(9).m_123343_() + 48))) {
            level.m_7731_(blockPos, Blocks.f_50454_.m_49966_(), 3);
        }
        for (int x = 0; x < TEMPLATE_SIZE; ++x) {
            for (int z = 0; z < TEMPLATE_SIZE; ++z) {
                BlockState currentBlockState = hasBlockVector[x][z];
                if (currentBlockState.m_60795_()) continue;
                BlockState[] directionBlockStates = new BlockState[]{CorridorGenerator.getBlockStateAtGridPos(hasBlockVector, x, z - 1), CorridorGenerator.getBlockStateAtGridPos(hasBlockVector, x, z + 1), CorridorGenerator.getBlockStateAtGridPos(hasBlockVector, x + 1, z), CorridorGenerator.getBlockStateAtGridPos(hasBlockVector, x - 1, z)};
                int finalX = x;
                int finalZ = z;
                level.m_7654_().m_236738_().m_230407_(CorridorGenerator.getStructureResourceLocationByType(currentBlockState, directionBlockStates)).ifPresent(structure -> {
                    BlockPos position = new BlockPos(corner.m_123341_() + finalX * PLACEMENT_OFFSET, corner.m_123342_() + 10, corner.m_123343_() + finalZ * PLACEMENT_OFFSET);
                    StructurePlaceSettings settings = new StructurePlaceSettings();
                    ServerLevel slevel = (ServerLevel)level;
                    structure.m_230328_((ServerLevelAccessor)slevel, position, position, settings, level.m_213780_(), 3);
                });
            }
        }
        level.m_46597_(corner.m_6630_(9), TRBlockRegistry.ASTRAL_MANIPULATOR_BLOCK.get().m_49966_());
    }

    private static ResourceLocation getStructureResourceLocationByType(BlockState blockState, BlockState[] results) {
        if (blockState == Blocks.f_50141_.m_49966_()) {
            return CorridorGenerator.getRoomPieceResourceLocation(results);
        }
        if (blockState == Blocks.f_50330_.m_49966_()) {
            return CorridorGenerator.getRoomPieceConnectionResourceLocation(results);
        }
        return CorridorGenerator.getCorridorPieceResourceLocation(results);
    }

    private static BlockState getBlockStateAtGridPos(BlockState[][] states, int x, int z) {
        if (x < 0 || x >= TEMPLATE_SIZE || z < 0 || z >= TEMPLATE_SIZE) {
            return Blocks.f_50069_.m_49966_();
        }
        return states[x][z];
    }

    private static ResourceLocation getRoomPieceConnectionResourceLocation(BlockState[] results) {
        if (CorridorGenerator.doesBlockExist(results[0]) && CorridorGenerator.doesBlockExist(results[1]) && !CorridorGenerator.doesBlockExist(results[2]) && !CorridorGenerator.doesBlockExist(results[3])) {
            return CorridorGenerator.createResourceLocation("room_entry_ns");
        }
        if (!CorridorGenerator.doesBlockExist(results[0]) && !CorridorGenerator.doesBlockExist(results[1]) && CorridorGenerator.doesBlockExist(results[2]) && CorridorGenerator.doesBlockExist(results[3])) {
            return CorridorGenerator.createResourceLocation("room_entry_ew");
        }
        return new ResourceLocation("");
    }

    private static ResourceLocation getRoomPieceResourceLocation(BlockState[] results) {
        if (CorridorGenerator.doesBlockExist(results[0]) && CorridorGenerator.doesBlockExist(results[1]) && CorridorGenerator.doesBlockExist(results[2]) && CorridorGenerator.doesBlockExist(results[3])) {
            if (CorridorGenerator.isBlockRoomConnection(results[0])) {
                return CorridorGenerator.createResourceLocation("room_door_n");
            }
            if (CorridorGenerator.isBlockRoomConnection(results[1])) {
                return CorridorGenerator.createResourceLocation("room_door_s");
            }
            if (CorridorGenerator.isBlockRoomConnection(results[2])) {
                return CorridorGenerator.createResourceLocation("room_door_e");
            }
            if (CorridorGenerator.isBlockRoomConnection(results[3])) {
                return CorridorGenerator.createResourceLocation("room_door_w");
            }
            return CorridorGenerator.createResourceLocation("room_center");
        }
        if (CorridorGenerator.doesBlockExist(results[0]) && !CorridorGenerator.doesBlockExist(results[1]) && CorridorGenerator.doesBlockExist(results[2]) && !CorridorGenerator.doesBlockExist(results[3])) {
            return CorridorGenerator.createResourceLocation("room_wall_ne");
        }
        if (CorridorGenerator.doesBlockExist(results[0]) && !CorridorGenerator.doesBlockExist(results[1]) && !CorridorGenerator.doesBlockExist(results[2]) && CorridorGenerator.doesBlockExist(results[3])) {
            return CorridorGenerator.createResourceLocation("room_wall_nw");
        }
        if (!CorridorGenerator.doesBlockExist(results[0]) && CorridorGenerator.doesBlockExist(results[1]) && CorridorGenerator.doesBlockExist(results[2]) && !CorridorGenerator.doesBlockExist(results[3])) {
            return CorridorGenerator.createResourceLocation("room_wall_se");
        }
        if (!CorridorGenerator.doesBlockExist(results[0]) && CorridorGenerator.doesBlockExist(results[1]) && !CorridorGenerator.doesBlockExist(results[2]) && CorridorGenerator.doesBlockExist(results[3])) {
            return CorridorGenerator.createResourceLocation("room_wall_sw");
        }
        if (CorridorGenerator.doesBlockExist(results[0]) && !CorridorGenerator.doesBlockExist(results[1]) && CorridorGenerator.doesBlockExist(results[2]) && CorridorGenerator.doesBlockExist(results[3])) {
            if (CorridorGenerator.isBlockRoomConnection(results[1])) {
                return CorridorGenerator.createResourceLocation("room_door_s");
            }
            return CorridorGenerator.createResourceLocation("room_wall_nwe");
        }
        if (CorridorGenerator.doesBlockExist(results[0]) && CorridorGenerator.doesBlockExist(results[1]) && CorridorGenerator.doesBlockExist(results[2]) && !CorridorGenerator.doesBlockExist(results[3])) {
            if (CorridorGenerator.isBlockRoomConnection(results[3])) {
                return CorridorGenerator.createResourceLocation("room_door_w");
            }
            return CorridorGenerator.createResourceLocation("room_wall_nse");
        }
        if (!CorridorGenerator.doesBlockExist(results[0]) && CorridorGenerator.doesBlockExist(results[1]) && CorridorGenerator.doesBlockExist(results[2]) && CorridorGenerator.doesBlockExist(results[3])) {
            if (CorridorGenerator.isBlockRoomConnection(results[0])) {
                return CorridorGenerator.createResourceLocation("room_door_n");
            }
            return CorridorGenerator.createResourceLocation("room_wall_sew");
        }
        if (CorridorGenerator.doesBlockExist(results[0]) && CorridorGenerator.doesBlockExist(results[1]) && !CorridorGenerator.doesBlockExist(results[2]) && CorridorGenerator.doesBlockExist(results[3])) {
            if (CorridorGenerator.isBlockRoomConnection(results[2])) {
                return CorridorGenerator.createResourceLocation("room_door_e");
            }
            return CorridorGenerator.createResourceLocation("room_wall_nsw");
        }
        return new ResourceLocation("");
    }

    private static boolean doesBlockExist(BlockState blockState) {
        return !blockState.m_60795_();
    }

    private static boolean isBlockRoomConnection(BlockState blockState) {
        return blockState == Blocks.f_50330_.m_49966_();
    }

    private static ResourceLocation getCorridorPieceResourceLocation(BlockState[] results) {
        if (CorridorGenerator.doesBlockExist(results[0]) && CorridorGenerator.doesBlockExist(results[1]) && !CorridorGenerator.doesBlockExist(results[2]) && !CorridorGenerator.doesBlockExist(results[3])) {
            return CorridorGenerator.createResourceLocation("corridor_piece_ns");
        }
        if (!CorridorGenerator.doesBlockExist(results[0]) && !CorridorGenerator.doesBlockExist(results[1]) && CorridorGenerator.doesBlockExist(results[2]) && CorridorGenerator.doesBlockExist(results[3])) {
            return CorridorGenerator.createResourceLocation("corridor_piece_ew");
        }
        if (CorridorGenerator.doesBlockExist(results[0]) && CorridorGenerator.doesBlockExist(results[1]) && CorridorGenerator.doesBlockExist(results[2]) && CorridorGenerator.doesBlockExist(results[3])) {
            return CorridorGenerator.createResourceLocation("corridor_piece_cross");
        }
        if (CorridorGenerator.doesBlockExist(results[0]) && !CorridorGenerator.doesBlockExist(results[1]) && CorridorGenerator.doesBlockExist(results[2]) && !CorridorGenerator.doesBlockExist(results[3])) {
            return CorridorGenerator.createResourceLocation("corridor_piece_ne");
        }
        if (CorridorGenerator.doesBlockExist(results[0]) && !CorridorGenerator.doesBlockExist(results[1]) && !CorridorGenerator.doesBlockExist(results[2]) && CorridorGenerator.doesBlockExist(results[3])) {
            return CorridorGenerator.createResourceLocation("corridor_piece_nw");
        }
        if (!CorridorGenerator.doesBlockExist(results[0]) && CorridorGenerator.doesBlockExist(results[1]) && CorridorGenerator.doesBlockExist(results[2]) && !CorridorGenerator.doesBlockExist(results[3])) {
            return CorridorGenerator.createResourceLocation("corridor_piece_se");
        }
        if (!CorridorGenerator.doesBlockExist(results[0]) && CorridorGenerator.doesBlockExist(results[1]) && !CorridorGenerator.doesBlockExist(results[2]) && CorridorGenerator.doesBlockExist(results[3])) {
            return CorridorGenerator.createResourceLocation("corridor_piece_sw");
        }
        if (CorridorGenerator.doesBlockExist(results[0]) && !CorridorGenerator.doesBlockExist(results[1]) && CorridorGenerator.doesBlockExist(results[2]) && CorridorGenerator.doesBlockExist(results[3])) {
            return CorridorGenerator.createResourceLocation("corridor_piece_new");
        }
        if (CorridorGenerator.doesBlockExist(results[0]) && CorridorGenerator.doesBlockExist(results[1]) && CorridorGenerator.doesBlockExist(results[2]) && !CorridorGenerator.doesBlockExist(results[3])) {
            return CorridorGenerator.createResourceLocation("corridor_piece_nse");
        }
        if (!CorridorGenerator.doesBlockExist(results[0]) && CorridorGenerator.doesBlockExist(results[1]) && CorridorGenerator.doesBlockExist(results[2]) && CorridorGenerator.doesBlockExist(results[3])) {
            return CorridorGenerator.createResourceLocation("corridor_piece_sew");
        }
        if (CorridorGenerator.doesBlockExist(results[0]) && CorridorGenerator.doesBlockExist(results[1]) && !CorridorGenerator.doesBlockExist(results[2]) && CorridorGenerator.doesBlockExist(results[3])) {
            return CorridorGenerator.createResourceLocation("corridor_piece_nsw");
        }
        return new ResourceLocation("");
    }

    private static ResourceLocation createResourceLocation(String id) {
        return new ResourceLocation("tardis_refined", "corridor_template/" + id);
    }
}

