/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.tardis.themes;

import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import whocraft.tardis_refined.common.tardis.control.ControlSpecification;
import whocraft.tardis_refined.common.tardis.themes.Theme;
import whocraft.tardis_refined.common.tardis.themes.console.ConsoleThemeDetails;
import whocraft.tardis_refined.common.tardis.themes.console.CopperConsoleTheme;
import whocraft.tardis_refined.common.tardis.themes.console.CoralConsoleTheme;
import whocraft.tardis_refined.common.tardis.themes.console.CrystalConsoleTheme;
import whocraft.tardis_refined.common.tardis.themes.console.FactoryConsoleTheme;
import whocraft.tardis_refined.common.tardis.themes.console.InitiativeConsoleTheme;
import whocraft.tardis_refined.common.tardis.themes.console.MystConsoleTheme;
import whocraft.tardis_refined.common.tardis.themes.console.NukaConsoleTheme;
import whocraft.tardis_refined.common.tardis.themes.console.RefurbishedConsoleTheme;
import whocraft.tardis_refined.common.tardis.themes.console.ToyotaConsoleTheme;
import whocraft.tardis_refined.common.tardis.themes.console.VictorianConsoleTheme;
import whocraft.tardis_refined.registry.DeferredRegistry;
import whocraft.tardis_refined.registry.RegistrySupplier;

public class ConsoleTheme
implements Theme {
    public static final ResourceKey<Registry<ConsoleTheme>> CONSOLE_THEME_REGISTRY_KEY = ResourceKey.m_135788_((ResourceLocation)new ResourceLocation("tardis_refined", "console_theme"));
    public static final DeferredRegistry<ConsoleTheme> CONSOLE_THEME_DEFERRED_REGISTRY = DeferredRegistry.createCustom("tardis_refined", CONSOLE_THEME_REGISTRY_KEY, true);
    public static final RegistrySupplier<ConsoleTheme> FACTORY = ConsoleTheme.registerConsoleTheme("factory", new FactoryConsoleTheme());
    public static final RegistrySupplier<ConsoleTheme> CRYSTAL = ConsoleTheme.registerConsoleTheme("crystal", new CrystalConsoleTheme());
    public static final RegistrySupplier<ConsoleTheme> COPPER = ConsoleTheme.registerConsoleTheme("copper", new CopperConsoleTheme());
    public static final RegistrySupplier<ConsoleTheme> CORAL = ConsoleTheme.registerConsoleTheme("coral", new CoralConsoleTheme());
    public static final RegistrySupplier<ConsoleTheme> TOYOTA = ConsoleTheme.registerConsoleTheme("toyota", new ToyotaConsoleTheme());
    public static final RegistrySupplier<ConsoleTheme> VICTORIAN = ConsoleTheme.registerConsoleTheme("victorian", new VictorianConsoleTheme());
    public static final RegistrySupplier<ConsoleTheme> MYST = ConsoleTheme.registerConsoleTheme("myst", new MystConsoleTheme());
    public static final RegistrySupplier<ConsoleTheme> NUKA = ConsoleTheme.registerConsoleTheme("nuka", new NukaConsoleTheme());
    public static final RegistrySupplier<ConsoleTheme> INITIATIVE = ConsoleTheme.registerConsoleTheme("initiative", new InitiativeConsoleTheme());
    public static final RegistrySupplier<ConsoleTheme> REFURBISHED = ConsoleTheme.registerConsoleTheme("refurbished", new RefurbishedConsoleTheme());
    private ResourceLocation translationKey;
    private final ConsoleThemeDetails consoleThemeDetails;

    public ConsoleTheme(ResourceLocation translationKey, ConsoleThemeDetails consoleThemeDetails) {
        this.translationKey = translationKey;
        this.consoleThemeDetails = consoleThemeDetails;
    }

    public ControlSpecification[] getControlSpecificationList() {
        return this.consoleThemeDetails.getControlSpecification();
    }

    private static RegistrySupplier<ConsoleTheme> registerConsoleTheme(String id, ConsoleThemeDetails themeDetails) {
        return CONSOLE_THEME_DEFERRED_REGISTRY.register(id, () -> new ConsoleTheme(new ResourceLocation("tardis_refined", id), themeDetails));
    }

    @Override
    public String getTranslationKey() {
        return Util.m_137492_((String)"console", (ResourceLocation)this.translationKey);
    }

    @Override
    public Component getDisplayName() {
        return Component.m_237115_((String)this.getTranslationKey());
    }
}

