/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.util;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundChangeDifficultyPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ClientboundSetExperiencePacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import whocraft.tardis_refined.compat.ModCompatChecker;
import whocraft.tardis_refined.compat.portals.ImmersivePortals;
import whocraft.tardis_refined.registry.TRTagKeys;

public class TRTeleporter {
    public static Logger LOGGER = LogManager.getLogger((String)"TardisRefined/TRTeleporter");

    public static boolean simpleTeleport(Entity pEntity, ServerLevel pLevel, double pX, double pY, double pZ, float pYaw, float pPitch) {
        return TRTeleporter.performTeleport(pEntity, pLevel, pX, pY, pZ, pYaw, pPitch, false, new HashSet<Entity>());
    }

    public static boolean fullTeleport(Entity pEntity, ServerLevel pLevel, double pX, double pY, double pZ, float pYaw, float pPitch, Set<Entity> teleportedEntities) {
        return TRTeleporter.performTeleport(pEntity, pLevel, pX, pY, pZ, pYaw, pPitch, false, teleportedEntities);
    }

    private static boolean performTeleport(Entity pEntity, ServerLevel destination, double pX, double pY, double pZ, float pYaw, float pPitch, boolean safeBlockCheck, Set<Entity> teleportedEntities) {
        Entity teleportedEntity;
        Preconditions.checkNotNull((Object)destination, (Object)"A target level must be provided for teleportation");
        Preconditions.checkState((!pEntity.m_9236_().m_5776_() ? 1 : 0) != 0, (Object)"Entities can only be teleported on the server side");
        float updatedYRot = Mth.m_14177_((float)pYaw);
        float updatedXRot = Mth.m_14177_((float)pPitch);
        if (ModCompatChecker.immersivePortals()) {
            pEntity.m_146922_(updatedYRot);
            pEntity.m_146926_(updatedXRot);
            ImmersivePortals.teleportViaIp(pEntity, destination, pX, pY, pZ);
            return true;
        }
        if (!pEntity.m_9236_().m_5776_() && TRTeleporter.safetyCheck(pEntity, destination, pX, pY, pZ, safeBlockCheck, teleportedEntities) && (teleportedEntity = TRTeleporter.teleportLogicCommon(pEntity, destination, pX, pY, pZ, updatedYRot, updatedXRot)) != null) {
            if (!teleportedEntities.contains(pEntity)) {
                teleportedEntities.add(pEntity);
            }
            return true;
        }
        return false;
    }

    private static Entity teleportLogicCommon(Entity pEntity, ServerLevel destination, double pX, double pY, double pZ, float pYaw, float pPitch) {
        Entity teleportedEntity;
        pEntity.m_20256_(Vec3.f_82478_);
        if (pEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)pEntity;
            teleportedEntity = TRTeleporter.teleportPlayer(serverPlayer, destination, pX, pY, pZ, pYaw, pPitch);
        } else {
            teleportedEntity = TRTeleporter.teleportNonPlayerEntity(pEntity, destination, pX, pY, pZ, pYaw, pPitch);
        }
        if (teleportedEntity != null) {
            return teleportedEntity;
        }
        return null;
    }

    private static Entity postTeleportCommon(Entity teleportedEntity, ServerLevel destination, double pX, double pY, double pZ) {
        LivingEntity livingEntity;
        ChunkPos chunkpos = new ChunkPos(BlockPos.m_274561_((double)pX, (double)pY, (double)pZ));
        destination.m_7726_().m_8387_(TicketType.f_9448_, chunkpos, 1, (Object)teleportedEntity.m_19879_());
        if (teleportedEntity instanceof LivingEntity && !(livingEntity = (LivingEntity)teleportedEntity).m_21255_()) {
            teleportedEntity.m_6853_(true);
        }
        if (teleportedEntity instanceof PathfinderMob) {
            ((PathfinderMob)teleportedEntity).m_21573_().m_26573_();
        }
        if (teleportedEntity instanceof LivingEntity) {
            livingEntity = (LivingEntity)teleportedEntity;
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                for (MobEffectInstance effectInstance : new ArrayList(livingEntity.m_21220_())) {
                    serverPlayer.f_8906_.m_9829_((Packet)new ClientboundUpdateMobEffectPacket(serverPlayer.m_19879_(), effectInstance));
                }
            } else {
                TRTeleporter.reAddStatusEffectTempFix(livingEntity);
            }
        }
        ((ServerLevel)teleportedEntity.m_9236_()).m_8886_();
        destination.m_8886_();
        return teleportedEntity;
    }

    private static ServerPlayer teleportPlayer(ServerPlayer serverPlayer, ServerLevel destination, double pX, double pY, double pZ, float updatedYRot, float updatedXRot) {
        if (serverPlayer.m_5803_()) {
            serverPlayer.m_6145_(true, true);
        }
        Entity vehicle = serverPlayer.m_20202_();
        serverPlayer.m_20256_(Vec3.f_82478_);
        if (destination == serverPlayer.m_9236_()) {
            serverPlayer.f_8906_.m_9774_(pX, pY, pZ, updatedYRot, updatedXRot);
        } else {
            serverPlayer = TRTeleporter.teleportPlayerOtherDimension(serverPlayer, destination, pX, pY, pZ, updatedYRot, updatedXRot);
        }
        if (vehicle != null) {
            Entity teleportedVehicle;
            ServerPlayer teleportedPlayer = serverPlayer;
            double vehicleOffset = teleportedPlayer.m_6049_();
            teleportedPlayer.m_8127_();
            Vec3 vehicleOffsetVec = new Vec3(0.0, vehicleOffset, 0.0);
            Vec3 newVehiclePos = teleportedPlayer.m_20182_().m_82549_(vehicleOffsetVec);
            Vec3 newVehicleLastTickPos = TRTeleporter.lastTickPosOf((Entity)teleportedPlayer).m_82549_(vehicleOffsetVec);
            if (vehicle instanceof ServerPlayer) {
                ServerPlayer vehiclePlayer = (ServerPlayer)vehicle;
                vehiclePlayer.m_8999_(destination, pX, pY, pZ, updatedYRot, updatedXRot);
                teleportedVehicle = vehiclePlayer;
            } else {
                teleportedVehicle = TRTeleporter.teleportNonPlayerEntity(vehicle, destination, pX, pY, pZ, vehicle.m_146908_(), vehicle.m_146909_());
                if (teleportedVehicle != null) {
                    TRTeleporter.updatePosAndLastTickPos(teleportedVehicle, newVehiclePos, newVehicleLastTickPos);
                }
            }
            destination.m_7654_().m_6937_((Runnable)new TickTask(10, () -> teleportedPlayer.m_7998_(teleportedVehicle, true)));
            TRTeleporter.reSyncVehicleToPassengerPos((Entity)serverPlayer);
        }
        TRTeleporter.reSyncVehicleToPassengerPos((Entity)serverPlayer);
        serverPlayer.f_8906_.m_9953_();
        serverPlayer.m_20091_();
        serverPlayer.m_5616_(updatedYRot);
        serverPlayer.m_5618_(updatedYRot);
        serverPlayer.m_6885_();
        serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetExperiencePacket(serverPlayer.f_36080_, serverPlayer.f_36079_, serverPlayer.f_36078_));
        serverPlayer.f_8906_.m_9829_((Packet)new ClientboundPlayerAbilitiesPacket(serverPlayer.m_150110_()));
        serverPlayer.f_8906_.m_9829_((Packet)new ClientboundChangeDifficultyPacket(serverPlayer.m_9236_().m_46791_(), serverPlayer.m_9236_().m_6106_().m_5474_()));
        TRTeleporter.postTeleportCommon((Entity)serverPlayer, destination, pX, pY, pZ);
        return (ServerPlayer)destination.m_46003_(serverPlayer.m_20148_());
    }

    private static ServerPlayer teleportPlayerOtherDimension(ServerPlayer serverPlayer, ServerLevel destination, double pX, double pY, double pZ, float updatedYRot, float updatedXRot) {
        serverPlayer.m_8999_(destination, pX, pY, pZ, updatedYRot, updatedXRot);
        return serverPlayer;
    }

    private static Entity teleportNonPlayerEntity(Entity pEntity, ServerLevel destination, double pX, double pY, double pZ, float yRot, float xRot) {
        float adjustedXRot = Mth.m_14036_((float)xRot, (float)-90.0f, (float)90.0f);
        Entity teleportedEntity = null;
        if (!TRTeleporter.safetyCheck(pEntity, destination, pX, pY, pZ, false, null)) {
            return null;
        }
        boolean handlePassengerTeleport = false;
        if (pEntity.m_20160_() || TRTeleporter.doesVehicleContainPlayer(pEntity)) {
            handlePassengerTeleport = true;
        }
        List passengers = pEntity.m_20197_();
        if (handlePassengerTeleport) {
            if (!passengers.isEmpty()) {
                pEntity.m_19877_();
                Entity finalTeleportedEntity = teleportedEntity = TRTeleporter.teleportNonPlayerEntityRegular(pEntity, destination, pX, pY, pZ, yRot, adjustedXRot);
                passengers.stream().map(passenger -> TRTeleporter.teleportPassengerForNonEntityDimensionTeleport(passenger, destination, pX, pY, pZ, yRot, adjustedXRot)).collect(Collectors.toList()).forEach(teleportedPassenger -> {
                    if (teleportedPassenger != null) {
                        destination.m_7654_().m_6937_((Runnable)new TickTask(10, () -> teleportedPassenger.m_7998_(finalTeleportedEntity, true)));
                    }
                });
            }
        } else {
            teleportedEntity = TRTeleporter.teleportNonPlayerEntityRegular(pEntity, destination, pX, pY, pZ, yRot, adjustedXRot);
        }
        return teleportedEntity;
    }

    private static Entity teleportNonPlayerEntityRegular(Entity pEntity, ServerLevel destination, double pX, double pY, double pZ, float yRot, float xRot) {
        Preconditions.checkState((!pEntity.m_9236_().m_5776_() ? 1 : 0) != 0, (Object)"Entities can only be teleported on the server side");
        pEntity.m_20256_(Vec3.f_82478_);
        Entity teleportedEntity = destination == pEntity.m_9236_() ? TRTeleporter.teleportNonPlayerEntitySameDimension(pEntity, pX, pY, pZ, yRot, xRot) : TRTeleporter.teleportNonPlayerEntityOtherDimension(pEntity, destination, pX, pY, pZ, yRot, xRot);
        teleportedEntity = TRTeleporter.postTeleportCommon(teleportedEntity, destination, pX, pY, pZ);
        return teleportedEntity;
    }

    private static Entity teleportPassengerForNonEntityDimensionTeleport(Entity passenger, ServerLevel destination, double pX, double pY, double pZ, float yRot, float xRot) {
        Entity teleportedPassenger;
        if (passenger instanceof ServerPlayer) {
            ServerPlayer serverPlayerPassenger = (ServerPlayer)passenger;
            teleportedPassenger = TRTeleporter.teleportPlayer(serverPlayerPassenger, destination, pX, pY, pZ, yRot, xRot);
        } else {
            teleportedPassenger = TRTeleporter.teleportNonPlayerEntity(passenger, destination, pX, pY, pZ, yRot, xRot);
        }
        return teleportedPassenger;
    }

    private static Entity teleportNonPlayerEntitySameDimension(Entity pEntity, double pX, double pY, double pZ, float yRot, float xRot) {
        pEntity.m_7678_(pX, pY, pZ, yRot, xRot);
        pEntity.m_5616_(yRot);
        pEntity.m_5618_(yRot);
        pEntity.m_20091_();
        return pEntity;
    }

    private static Entity teleportNonPlayerEntityOtherDimension(Entity pEntity, ServerLevel destination, double pX, double pY, double pZ, float yRot, float xRot) {
        Entity newEntity = pEntity;
        if ((newEntity = newEntity.m_6095_().m_20615_((Level)destination)) == null) {
            return null;
        }
        newEntity.m_20361_(pEntity);
        newEntity.m_7678_(pX, pY, pZ, yRot, xRot);
        newEntity.m_5616_(yRot);
        newEntity.m_20091_();
        pEntity.m_142687_(Entity.RemovalReason.CHANGED_DIMENSION);
        destination.m_143334_(newEntity);
        return newEntity;
    }

    public static boolean teleportIfCollided(ServerLevel serverLevel, BlockPos blockPos, Entity entity, AABB teleportAABB) {
        AABB entityBoundingBox = TRTeleporter.getBoundingBoxWithMovement(entity);
        double insideBlockExpansion = 1.0E-7;
        AABB inflatedEntityBoundingBox = entityBoundingBox.m_82400_(insideBlockExpansion);
        AABB inflatedTeleportBoundingBox = teleportAABB.m_82400_(insideBlockExpansion);
        return inflatedTeleportBoundingBox.m_82381_(inflatedEntityBoundingBox);
    }

    private static void reAddStatusEffectTempFix(LivingEntity livingEntity) {
        ArrayList effectInstanceList = new ArrayList(livingEntity.m_21220_());
        for (int i = effectInstanceList.size() - 1; i >= 0; --i) {
            MobEffectInstance effectInstance = (MobEffectInstance)effectInstanceList.get(i);
            if (effectInstance == null) continue;
            livingEntity.m_21195_(effectInstance.m_19544_());
            livingEntity.m_7292_(new MobEffectInstance(effectInstance.m_19544_(), effectInstance.m_19557_(), effectInstance.m_19564_(), effectInstance.m_19571_(), effectInstance.m_19572_(), effectInstance.m_19575_()));
        }
    }

    public static AABB getBoundingBoxWithMovement(Entity entity) {
        Vec3 backwardExpand = TRTeleporter.lastTickPosOf(entity).m_82546_(entity.m_20182_());
        Vec3 forwardExpand = entity.m_20184_();
        AABB box = entity.m_20191_().m_82369_(forwardExpand.m_82490_(1.2)).m_82369_(backwardExpand);
        return box;
    }

    private static boolean reSyncVehicleToPassengerPos(Entity entity) {
        Entity vehicle = entity.m_20202_();
        if (vehicle == null) {
            return false;
        }
        double vehicleOffset = entity.m_6049_();
        Vec3 oldMotion = vehicle.m_20184_();
        Vec3 vehicleOffsetVec = new Vec3(0.0, vehicleOffset, 0.0);
        Vec3 newVehiclePos = entity.m_20182_().m_82549_(vehicleOffsetVec);
        Vec3 newVehicleLastTickPos = TRTeleporter.lastTickPosOf(entity).m_82549_(vehicleOffsetVec);
        vehicle.m_6034_(newVehiclePos.m_7096_(), newVehiclePos.m_7098_(), newVehiclePos.m_7094_());
        vehicle.m_6453_(newVehiclePos.m_7096_(), newVehiclePos.m_7098_(), newVehiclePos.m_7094_(), vehicle.m_146908_(), vehicle.m_146909_(), 0, false);
        TRTeleporter.updatePosAndLastTickPos(vehicle, newVehiclePos, newVehicleLastTickPos);
        vehicle.m_20256_(oldMotion);
        return true;
    }

    private static Vec3 lastTickPosOf(Entity entity) {
        return new Vec3(entity.f_19854_, entity.f_19855_, entity.f_19856_);
    }

    private static void updatePosAndLastTickPos(Entity entity, Vec3 updatedPos, Vec3 lastTickPos) {
        entity.m_146884_(updatedPos);
        entity.f_19790_ = lastTickPos.f_82479_;
        entity.f_19791_ = lastTickPos.f_82480_;
        entity.f_19792_ = lastTickPos.f_82481_;
        entity.f_19854_ = lastTickPos.f_82479_;
        entity.f_19855_ = lastTickPos.f_82480_;
        entity.f_19856_ = lastTickPos.f_82481_;
    }

    private static boolean doesVehicleContainPlayer(Entity vehicle) {
        if (vehicle instanceof Player) {
            return true;
        }
        List passengerList = vehicle.m_20197_();
        if (passengerList.isEmpty()) {
            return false;
        }
        return passengerList.stream().anyMatch(passenger -> passenger instanceof Player);
    }

    public static boolean canTeleportTo(BlockPos pPos, Level level, Entity entity) {
        BlockPathTypes blockpathtypes = WalkNodeEvaluator.m_77604_((BlockGetter)level, (BlockPos.MutableBlockPos)pPos.m_122032_());
        if (blockpathtypes != BlockPathTypes.WALKABLE) {
            return false;
        }
        BlockPos blockpos = pPos.m_121996_((Vec3i)entity.m_20183_());
        return level.m_45756_(entity, entity.m_20191_().m_82338_(blockpos));
    }

    private static boolean safetyCheck(Entity pEntity, ServerLevel destination, double pX, double pY, double pZ, boolean safeBlockCheck, Set<Entity> teleportedEntities) {
        int xRound = (int)pX;
        int yRound = (int)pY;
        int zRound = (int)pZ;
        BlockPos blockpos = new BlockPos(xRound, yRound, zRound);
        if (teleportedEntities != null && !teleportedEntities.isEmpty() && teleportedEntities.contains(pEntity)) {
            LOGGER.warn("Failed to teleport entity type as it has already been teleported: {}", (Object)pEntity.m_6095_());
            return false;
        }
        if (pEntity.m_6095_().m_204039_(TRTagKeys.TARDIS_TELEPORT_BLACKLIST)) {
            LOGGER.warn("Failed to teleport entity type due to it being blacklisted: {}", (Object)pEntity.m_6095_());
            return false;
        }
        if (safeBlockCheck && !TRTeleporter.canTeleportTo(blockpos, (Level)destination, pEntity)) {
            LOGGER.warn("Failed to teleport entity type due to destination location being unsafe: {}", (Object)pEntity.m_6095_());
            return false;
        }
        return Level.m_46741_((BlockPos)blockpos);
    }
}

