/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.util.forge;

import com.mojang.serialization.Codec;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.OnDatapackSyncEvent;
import whocraft.tardis_refined.common.network.MessageS2C;
import whocraft.tardis_refined.common.network.NetworkManager;
import whocraft.tardis_refined.common.util.CodecJsonReloadListener;

public class CodecJsonReloadListenerImpl {
    public static <T> CodecJsonReloadListener<T> create(String folderName, Codec<T> codec) {
        return new Impl<T>(folderName, codec);
    }

    public static class Impl<T>
    extends CodecJsonReloadListener<T> {
        public Impl(String folderName, Codec<T> codec) {
            super(folderName, codec);
        }

        @Override
        public CodecJsonReloadListener setSyncPacket(NetworkManager networkManager, Function packetFactory) {
            MinecraftForge.EVENT_BUS.addListener(this.getDatapackSyncListener(networkManager, packetFactory));
            return this;
        }

        private Consumer<OnDatapackSyncEvent> getDatapackSyncListener(NetworkManager networkManager, Function<Map<ResourceLocation, T>, MessageS2C> packetFactory) {
            return event -> this.handleSyncPacket(event.getPlayer(), networkManager, packetFactory);
        }
    }
}

