/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.compat.create;

import com.simibubi.create.api.behaviour.display.DisplaySource;
import com.simibubi.create.api.registry.CreateRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import whocraft.tardis_refined.TardisRefined;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.tardis.TardisNavLocation;
import whocraft.tardis_refined.compat.ModCompatChecker;
import whocraft.tardis_refined.compat.create.QuickOneLineDisplaySource;
import whocraft.tardis_refined.compat.create.TardisDisplaySource;
import whocraft.tardis_refined.compat.create.TardisNavLocationDisplaySource;
import whocraft.tardis_refined.compat.valkyrienskies.VSHelper;
import whocraft.tardis_refined.constants.ModMessages;
import whocraft.tardis_refined.registry.DeferredRegistry;
import whocraft.tardis_refined.registry.RegistrySupplier;
import whocraft.tardis_refined.registry.TRBlockRegistry;

public class CreateIntergrationsForge {
    public static final DeferredRegistry<DisplaySource> DISPLAY_SOURCE_DEFERRED_REGISTRY = DeferredRegistry.create("tardis_refined", CreateRegistries.DISPLAY_SOURCE);
    public static final RegistrySupplier<DisplaySource> BIG_DATA = DISPLAY_SOURCE_DEFERRED_REGISTRY.register("tardis_bigdata", TardisDisplaySource::new);
    public static final RegistrySupplier<DisplaySource> FUEL = DISPLAY_SOURCE_DEFERRED_REGISTRY.register("fuel", () -> new QuickOneLineDisplaySource(new QuickOneLineDisplaySource.TardisInfo(){

        @Override
        public MutableComponent provideInfo(TardisLevelOperator tardis) {
            return Component.m_237110_((String)ModMessages.FUEL, (Object[])new Object[]{String.valueOf(Math.round(tardis.getPilotingManager().getFuelPercentage() * 100.0f))}).m_130946_("%");
        }

        @Override
        public ResourceLocation getId() {
            return new ResourceLocation("tardis_refined", "fuel");
        }
    }));
    public static final RegistrySupplier<DisplaySource> DOOR_STATUS = DISPLAY_SOURCE_DEFERRED_REGISTRY.register("door", () -> new QuickOneLineDisplaySource(new QuickOneLineDisplaySource.TardisInfo(){

        @Override
        public MutableComponent provideInfo(TardisLevelOperator tardis) {
            return Component.m_237110_((String)ModMessages.DOOR_STATUS, (Object[])new Object[]{String.valueOf(tardis.getInternalDoor().isOpen())});
        }

        @Override
        public ResourceLocation getId() {
            return new ResourceLocation("tardis_refined", "door");
        }
    }));
    public static final RegistrySupplier<DisplaySource> LOCK_STATUS = DISPLAY_SOURCE_DEFERRED_REGISTRY.register("locked", () -> new QuickOneLineDisplaySource(new QuickOneLineDisplaySource.TardisInfo(){

        @Override
        public MutableComponent provideInfo(TardisLevelOperator tardis) {
            return Component.m_237110_((String)ModMessages.LOCK_STATUS, (Object[])new Object[]{String.valueOf(tardis.getExteriorManager().locked())});
        }

        @Override
        public ResourceLocation getId() {
            return new ResourceLocation("tardis_refined", "locked");
        }
    }));
    public static final RegistrySupplier<DisplaySource> GPS = DISPLAY_SOURCE_DEFERRED_REGISTRY.register("gps", () -> new TardisNavLocationDisplaySource(new TardisNavLocationDisplaySource.TardisNavInfo(){

        @Override
        public TardisNavLocation provideInfo(TardisLevelOperator tardis) {
            TardisNavLocation currentLoc = tardis.getPilotingManager().getCurrentLocation();
            if (ModCompatChecker.valkyrienSkies()) {
                currentLoc = VSHelper.toWorldLocation(currentLoc);
            }
            return currentLoc;
        }

        @Override
        public ResourceLocation getId() {
            return new ResourceLocation("tardis_refined", "gps");
        }
    }));
    public static final RegistrySupplier<DisplaySource> DESTINATION = DISPLAY_SOURCE_DEFERRED_REGISTRY.register("destination", () -> new TardisNavLocationDisplaySource(new TardisNavLocationDisplaySource.TardisNavInfo(){

        @Override
        public TardisNavLocation provideInfo(TardisLevelOperator tardis) {
            return tardis.getPilotingManager().getTargetLocation();
        }

        @Override
        public ResourceLocation getId() {
            return new ResourceLocation("tardis_refined", "destination");
        }
    }));

    public static void init() {
        DISPLAY_SOURCE_DEFERRED_REGISTRY.registerToModBus();
    }

    public static void initAssignments() {
        TardisRefined.LOGGER.info("Registering Create TARDIS Display Sources");
        DisplaySource.BY_BLOCK.add((Object)((Block)TRBlockRegistry.FLIGHT_DETECTOR.get()), (Object)BIG_DATA.get());
        DisplaySource.BY_BLOCK.add((Object)((Block)TRBlockRegistry.FLIGHT_DETECTOR.get()), (Object)FUEL.get());
        DisplaySource.BY_BLOCK.add((Object)((Block)TRBlockRegistry.FLIGHT_DETECTOR.get()), (Object)DOOR_STATUS.get());
        DisplaySource.BY_BLOCK.add((Object)((Block)TRBlockRegistry.FLIGHT_DETECTOR.get()), (Object)LOCK_STATUS.get());
        DisplaySource.BY_BLOCK.add((Object)((Block)TRBlockRegistry.FLIGHT_DETECTOR.get()), (Object)GPS.get());
        DisplaySource.BY_BLOCK.add((Object)((Block)TRBlockRegistry.FLIGHT_DETECTOR.get()), (Object)DESTINATION.get());
    }
}

