/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.compat.portals;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import qouteall.imm_ptl.core.portal.Portal;
import whocraft.tardis_refined.common.tardis.themes.ShellTheme;
import whocraft.tardis_refined.compat.portals.ImmersivePortals;
import whocraft.tardis_refined.compat.portals.PortalEntry;

public class BotiPortalEntity
extends Portal {
    private static final EntityDataAccessor<Optional<UUID>> TARDIS_ID = SynchedEntityData.m_135353_(BotiPortalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    ShellTheme shellTheme = ShellTheme.FACTORY.get();
    private boolean isValid = false;

    public BotiPortalEntity(EntityType<?> entityType, Level world) {
        super(entityType, world);
    }

    public ShellTheme getShellTheme() {
        return this.shellTheme;
    }

    public void setShellTheme(ShellTheme shellTheme) {
        this.shellTheme = shellTheme;
    }

    protected void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        UUID tardisId = this.getTardisId();
        if (tardisId != null) {
            compoundTag.m_128362_("tardis_id", tardisId);
        }
        compoundTag.m_128379_("valid", this.isValid);
    }

    protected void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (compoundTag.m_128441_("tardis_id")) {
            this.setTardisId(compoundTag.m_128342_("tardis_id"));
        }
        if (compoundTag.m_128441_("valid")) {
            this.setValid(compoundTag.m_128471_("valid"));
        } else {
            this.isValid = false;
        }
    }

    public void m_8119_() {
        super.m_8119_();
    }

    public boolean isPortalValid() {
        UUID tardisId = this.getTardisId();
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.f_19797_ > 800) {
                PortalEntry portalEntry = ImmersivePortals.getPortalsForTardis(tardisId);
                if (portalEntry == null && this.f_19797_ > 40 && !this.getOriginWorld().m_5776_()) {
                    return false;
                }
                if (!this.isValid) {
                    return false;
                }
            }
        }
        return super.isPortalValid();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(TARDIS_ID, Optional.of(UUID.randomUUID()));
    }

    public UUID getTardisId() {
        return (UUID)((Optional)this.m_20088_().m_135370_(TARDIS_ID)).get();
    }

    public void setTardisId(UUID tardisId) {
        this.m_20088_().m_135381_(TARDIS_ID, Optional.of(tardisId));
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setValid(boolean valid) {
        this.isValid = valid;
    }
}

