/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.compat.valkyrienskies;

import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Math;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VS2ChunkAllocator;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import whocraft.tardis_refined.common.tardis.TardisNavLocation;

public class VSHelper {
    public static boolean isChunkInShipyard(ChunkPos pos) {
        return VS2ChunkAllocator.INSTANCE.isChunkInShipyardCompanion(pos.f_45578_, pos.f_45579_);
    }

    public static boolean isBlockInShipyard(Level level, BlockPos pos) {
        return VSGameUtilsKt.isBlockInShipyard((Level)level, (BlockPos)pos);
    }

    public static void forEachShipInAABB(Level level, AABB aabb, Consumer<AABB> consumer) {
        AABBd worldAABB = VectorConversionsMCKt.toJOML((AABB)aabb);
        for (Ship ship : VSGameUtilsKt.getShipsIntersecting((Level)level, (AABB)aabb)) {
            consumer.accept(VectorConversionsMCKt.toMinecraft((AABBdc)worldAABB.transform(ship.getWorldToShip())));
        }
    }

    public static boolean collidesWithShip(Level level, AABB boundingBox) {
        AABBd bb = VectorConversionsMCKt.toJOML((AABB)boundingBox);
        Ship currentShip = VSGameUtilsKt.getShipManagingPos((Level)level, (Position)boundingBox.m_82399_());
        if (currentShip != null) {
            bb.transform(currentShip.getShipToWorld());
        }
        for (Ship ship : VSGameUtilsKt.getShipsIntersecting((Level)level, (AABBdc)bb)) {
            AABBd transformedBB;
            Stream blocks;
            boolean bbEmpty;
            if (ship == currentShip || (bbEmpty = (blocks = BlockPos.m_121921_((AABB)VectorConversionsMCKt.toMinecraft((AABBdc)(transformedBB = bb.transform(ship.getWorldToShip(), new AABBd()))))).allMatch(blockPos -> {
                BlockState state = level.m_8055_(blockPos);
                return state.m_60812_((BlockGetter)level, blockPos).m_83281_() && state.m_60819_().m_76178_();
            }))) continue;
            return true;
        }
        return false;
    }

    public static boolean isBlockOnShip(Level level, BlockPos pos) {
        Ship ship = VSGameUtilsKt.getShipManagingPos((Level)level, (BlockPos)pos);
        Iterable ships = VSGameUtilsKt.getShipsIntersecting((Level)level, (AABB)new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0));
        return ship != null;
    }

    public static Vector3d toWorldRotation(Level level, BlockPos position, Direction direction) {
        Ship ship = VSGameUtilsKt.getShipManagingPos((Level)level, (BlockPos)position);
        if (ship != null) {
            return ship.getShipToWorld().transformDirection(VSHelper.directionToVector(direction));
        }
        return VSHelper.directionToVector(direction);
    }

    public static BlockPos toWorldPosition(Level level, BlockPos blockPos) {
        Vector3d pos = VSHelper.blockPosToVector(blockPos);
        Vector3d worldPos = VSGameUtilsKt.getWorldCoordinates((Level)level, (BlockPos)blockPos, (Vector3d)pos);
        return VSHelper.vectorToBlockPos(worldPos);
    }

    public static Vec3 toWorldPosition(Level level, BlockPos blockPos, Vec3 vector) {
        Vector3d pos = VectorConversionsMCKt.toJOML((Vec3)vector);
        Vector3d worldPos = VSGameUtilsKt.getWorldCoordinates((Level)level, (BlockPos)blockPos, (Vector3d)pos);
        return VectorConversionsMCKt.toMinecraft((Vector3dc)worldPos);
    }

    public static TardisNavLocation toWorldLocation(TardisNavLocation input) {
        ServerShip ship = VSGameUtilsKt.getShipManagingPos((ServerLevel)input.getLevel(), (BlockPos)input.getPosition());
        if (ship != null) {
            BlockPos pos = VSHelper.vectorToBlockPos(ship.getShipToWorld().transformPosition(VSHelper.blockPosToVector(input.getPosition())));
            Direction dir = VSHelper.vectorToDirection(ship.getShipToWorld().transformDirection(VSHelper.directionToVector(input.getDirection())));
            TardisNavLocation output = new TardisNavLocation(pos, dir, input.getLevel());
            output.setName(input.getName());
            return output;
        }
        return input;
    }

    public static Vector3d blockPosToVector(BlockPos blockPos) {
        return new Vector3d((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
    }

    public static BlockPos vectorToBlockPos(Vector3d vector) {
        return new BlockPos((int)Math.round((double)vector.x), (int)Math.round((double)vector.y), (int)Math.round((double)vector.z));
    }

    public static Vector3d directionToVector(Direction direction) {
        return new Vector3d((double)direction.m_122429_(), (double)direction.m_122430_(), (double)direction.m_122431_());
    }

    public static Direction vectorToDirection(Vector3d vector) {
        return Direction.m_122366_((double)vector.x, (double)vector.y, (double)vector.z);
    }
}

