/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.mixin.render;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import whocraft.tardis_refined.client.TardisClientData;
import whocraft.tardis_refined.client.TardisClientLogic;
import whocraft.tardis_refined.common.util.TardisHelper;
import whocraft.tardis_refined.registry.TRDimensionTypes;

@Mixin(value={FogRenderer.class})
public class FogRendererMixin {
    @Inject(at={@At(value="TAIL")}, method={"setupFog(Lnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/FogRenderer$FogMode;FZF)V"})
    private static void setupFog(Camera camera, FogRenderer.FogMode fogMode, float farPlaneDistance, boolean bl, float f, CallbackInfo ci) {
        BlockPos blockPosition;
        if (Minecraft.m_91087_().f_91074_ != null && TardisHelper.isInArsArea(blockPosition = Minecraft.m_91087_().f_91074_.m_20183_())) {
            RenderSystem.setShaderFogStart((float)-8.0f);
            RenderSystem.setShaderFogEnd((float)30.0f);
            RenderSystem.setShaderFogShape((FogShape)FogShape.SPHERE);
        }
    }

    @Inject(at={@At(value="HEAD")}, cancellable=true, method={"setupFog"})
    private static void setupColor(CallbackInfo callbackInfo) {
        if (Minecraft.m_91087_().f_91074_ != null) {
            BlockPos blockPosition = Minecraft.m_91087_().f_91074_.m_20183_();
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level.m_220362_() != TRDimensionTypes.TARDIS) {
                return;
            }
            TardisClientData reactions = TardisClientData.getInstance((ResourceKey<Level>)level.m_46472_());
            if (TardisClientLogic.getFogTickDelta(blockPosition) > 0.0f) {
                float delta = TardisClientLogic.getFogTickDelta(blockPosition);
                RenderSystem.setShaderFogColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                RenderSystem.setShaderFogStart((float)Mth.m_14179_((float)delta, (float)16.0f, (float)-8.0f));
                RenderSystem.setShaderFogEnd((float)16.0f);
                RenderSystem.setShaderFogShape((FogShape)FogShape.SPHERE);
                callbackInfo.cancel();
            }
            if (TardisHelper.isInArsArea(blockPosition)) {
                Vec3 fogColor = reactions.fogColor(reactions.isCrashing());
                RenderSystem.setShaderFogColor((float)((float)fogColor.f_82479_), (float)((float)fogColor.f_82480_), (float)((float)fogColor.f_82481_));
                callbackInfo.cancel();
            }
        }
    }
}

