/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.patterns;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import whocraft.tardis_refined.common.util.RegistryHelper;
import whocraft.tardis_refined.patterns.BasePattern;
import whocraft.tardis_refined.patterns.PatternTexture;
import whocraft.tardis_refined.patterns.sound.ShellSoundProfile;
import whocraft.tardis_refined.patterns.sound.TRShellSoundProfiles;

public class ShellPattern
extends BasePattern {
    public static final Codec<ShellPattern> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("id").forGetter(BasePattern::id), (App)Codec.STRING.orElse((Object)"Placeholder").fieldOf("name_component").forGetter(BasePattern::name), (App)PatternTexture.getCodec().fieldOf("exterior").forGetter(ShellPattern::shellTexture), (App)PatternTexture.getCodec().fieldOf("interior").forGetter(ShellPattern::doorTexture), (App)ShellSoundProfile.CODEC.optionalFieldOf("sound_profile").orElse(Optional.of(TRShellSoundProfiles.DEFAULT_SOUND_PROFILE)).forGetter(ShellPattern::soundProfile)).apply((Applicative)instance, ShellPattern::new));
    private final PatternTexture interiorDoorTexture;
    private final PatternTexture exteriorDoorTexture;
    private final Optional<ShellSoundProfile> shellSoundProfile;

    public ShellPattern(String identifier, PatternTexture exteriorDoorTexture, PatternTexture interiorDoorTexture, Optional<ShellSoundProfile> shellSoundProfile) {
        this(RegistryHelper.makeKey(identifier), exteriorDoorTexture, interiorDoorTexture, shellSoundProfile);
    }

    public ShellPattern(ResourceLocation identifier, PatternTexture exteriorDoorTexture, PatternTexture interiorDoorTexture, Optional<ShellSoundProfile> shellSoundProfile) {
        super(identifier);
        this.exteriorDoorTexture = exteriorDoorTexture;
        this.interiorDoorTexture = interiorDoorTexture;
        this.shellSoundProfile = shellSoundProfile;
    }

    public ShellPattern(ResourceLocation identifier, String name, PatternTexture exteriorDoorTexture, PatternTexture interiorDoorTexture, Optional<ShellSoundProfile> shellSoundProfile) {
        super(identifier, name);
        this.exteriorDoorTexture = exteriorDoorTexture;
        this.interiorDoorTexture = interiorDoorTexture;
        this.shellSoundProfile = shellSoundProfile;
    }

    public PatternTexture shellTexture() {
        return this.exteriorDoorTexture;
    }

    public PatternTexture doorTexture() {
        return this.interiorDoorTexture;
    }

    public Codec<ShellPattern> getCodec() {
        return CODEC;
    }

    public Optional<ShellSoundProfile> soundProfile() {
        return this.shellSoundProfile;
    }
}

