/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.patterns;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import whocraft.tardis_refined.common.tardis.themes.ConsoleTheme;
import whocraft.tardis_refined.common.tardis.themes.ShellTheme;
import whocraft.tardis_refined.constants.ResourceConstants;
import whocraft.tardis_refined.patterns.PatternReloadListener;
import whocraft.tardis_refined.patterns.PatternTexture;
import whocraft.tardis_refined.patterns.ShellPattern;
import whocraft.tardis_refined.patterns.ShellPatternCollection;
import whocraft.tardis_refined.patterns.sound.ConfiguredSound;
import whocraft.tardis_refined.patterns.sound.ShellSoundProfile;
import whocraft.tardis_refined.patterns.sound.TRShellSoundProfiles;

public class ShellPatterns {
    public static Logger LOGGER = LogManager.getLogger((String)"TardisRefined/ShellPatterns");
    public static final ShellPattern DEFAULT = (ShellPattern)new ShellPattern(ResourceConstants.DEFAULT_PATTERN_ID, new PatternTexture(ShellPatterns.exteriorTextureLocation(ShellTheme.FACTORY.getId(), ShellTheme.FACTORY.getId().m_135815_()), false), new PatternTexture(ShellPatterns.interiorTextureLocation(ShellTheme.FACTORY.getId(), ShellTheme.FACTORY.getId().m_135815_()), false), Optional.of(TRShellSoundProfiles.DEFAULT_SOUND_PROFILE)).setThemeId(ConsoleTheme.FACTORY.getId());
    public static PatternReloadListener<ShellPatternCollection, ShellPattern> PATTERNS = PatternReloadListener.createListener("tardis_refined/patterns/shell", ShellPatternCollection.CODEC, patternCollections -> PatternReloadListener.processPatternCollections(patternCollections));
    private static final Map<ResourceLocation, List<ShellPattern>> DEFAULT_PATTERNS = new HashMap<ResourceLocation, List<ShellPattern>>();

    public static PatternReloadListener<ShellPatternCollection, ShellPattern> getReloadListener() {
        return PATTERNS;
    }

    public static Map<ResourceLocation, List<ShellPattern>> getRegistry() {
        return PATTERNS.getData();
    }

    public static List<ShellPattern> getPatternsForTheme(ResourceLocation shellThemeId) {
        return (List)PATTERNS.getData().get(shellThemeId);
    }

    public static List<ShellPattern> getPatternsForThemeDefault(ResourceLocation shellThemeId) {
        return DEFAULT_PATTERNS.get(shellThemeId);
    }

    public static List<ShellPattern> getPatternCollectionForTheme(ResourceLocation shellThemeId) {
        return (List)PATTERNS.getData().get(shellThemeId);
    }

    public static ResourceLocation getThemeForPattern(ShellPattern pattern) {
        Map<ResourceLocation, List<ShellPattern>> entries = ShellPatterns.getRegistry();
        for (Map.Entry<ResourceLocation, List<ShellPattern>> entry : entries.entrySet()) {
            if (pattern.getThemeId() != entry.getKey()) continue;
            return pattern.getThemeId();
        }
        return ShellTheme.HALF_BAKED.getId();
    }

    public static boolean doesPatternExist(ResourceLocation themeId, ResourceLocation patternId) {
        List<ShellPattern> basePatterns = ShellPatterns.getPatternsForTheme(themeId);
        for (ShellPattern basePattern : basePatterns) {
            if (!Objects.equals(basePattern.id(), patternId)) continue;
            return true;
        }
        return false;
    }

    public static ShellPattern getPatternOrDefault(ResourceLocation themeId, ResourceLocation patternId) {
        List<ShellPattern> basePatterns = ShellPatterns.getPatternsForTheme(themeId);
        for (ShellPattern basePattern : basePatterns) {
            if (!Objects.equals(basePattern.id(), patternId)) continue;
            return basePattern;
        }
        return basePatterns.get(0);
    }

    public static ShellPattern next(ResourceLocation shellTheme, ShellPattern currentPattern) {
        List<ShellPattern> collection = ShellPatterns.getPatternCollectionForTheme(shellTheme);
        return ShellPatterns.next(collection, currentPattern);
    }

    public static ShellPattern next(List<ShellPattern> patterns, ShellPattern currentPattern) {
        if (currentPattern == null) {
            return patterns.get(0);
        }
        int prevIndex = patterns.indexOf(currentPattern);
        if (prevIndex > patterns.size() || prevIndex + 1 >= patterns.size()) {
            return patterns.get(0);
        }
        return patterns.get(prevIndex + 1);
    }

    public static ShellPattern addDefaultPattern(ResourceLocation themeId, ShellPattern datagenPattern) {
        ShellPattern pattern = (ShellPattern)datagenPattern.setThemeId(themeId);
        if (DEFAULT_PATTERNS.containsKey(themeId)) {
            List<ShellPattern> patternList = DEFAULT_PATTERNS.get(themeId);
            ArrayList<ShellPattern> currentList = new ArrayList<ShellPattern>(patternList);
            currentList.add(pattern);
            DEFAULT_PATTERNS.replace(themeId, currentList);
            LOGGER.info("Adding Shell Pattern {} for {}", (Object)pattern.id(), (Object)themeId);
        } else {
            List<ShellPattern> patternList = List.of(pattern);
            DEFAULT_PATTERNS.put(themeId, patternList);
        }
        return pattern;
    }

    public static ShellPattern addDefaultPattern(ResourceLocation themeId, String patternName, boolean hasEmissiveTexture) {
        return ShellPatterns.addDefaultPattern(themeId, patternName, hasEmissiveTexture, Optional.of(TRShellSoundProfiles.DEFAULT_SOUND_PROFILE));
    }

    public static ShellPattern addDefaultPattern(ResourceLocation themeId, String patternName, boolean hasEmissiveTexture, Optional<ShellSoundProfile> soundProfile) {
        ShellPattern pattern = (ShellPattern)new ShellPattern(patternName, new PatternTexture(ShellPatterns.exteriorTextureLocation(themeId, patternName), hasEmissiveTexture), new PatternTexture(ShellPatterns.interiorTextureLocation(themeId, patternName), hasEmissiveTexture), soundProfile).setThemeId(themeId);
        return ShellPatterns.addDefaultPattern(themeId, pattern);
    }

    public static ResourceLocation exteriorTextureLocation(ResourceLocation themeId, String textureName) {
        return new ResourceLocation("tardis_refined", "textures/blockentity/shell/" + themeId.m_135815_() + "/" + textureName + ".png");
    }

    public static ResourceLocation exteriorTextureLocation(ResourceLocation themeId, String modid, String textureName) {
        return new ResourceLocation(modid, "textures/blockentity/shell/" + themeId.m_135815_() + "/" + textureName + ".png");
    }

    public static ResourceLocation interiorTextureLocation(ResourceLocation themeId, String modid, String textureName) {
        return new ResourceLocation(modid, "textures/blockentity/shell/" + themeId.m_135815_() + "/" + textureName + "_interior.png");
    }

    public static ResourceLocation interiorTextureLocation(ResourceLocation themeId, String textureName) {
        return new ResourceLocation("tardis_refined", "textures/blockentity/shell/" + themeId.m_135815_() + "/" + textureName + "_interior.png");
    }

    public static Map<ResourceLocation, List<ShellPattern>> getDefaultPatterns() {
        return DEFAULT_PATTERNS;
    }

    public static Map<ResourceLocation, ShellPatternCollection> getDefaultPatternsDatagen() {
        HashMap<ResourceLocation, ShellPatternCollection> defaults = new HashMap<ResourceLocation, ShellPatternCollection>();
        DEFAULT_PATTERNS.forEach((key, value) -> defaults.put((ResourceLocation)key, (ShellPatternCollection)new ShellPatternCollection((List<ShellPattern>)value).setThemeId((ResourceLocation)key)));
        return defaults;
    }

    public static Map<ResourceLocation, List<ShellPattern>> registerDefaultPatterns() {
        String[] shulkerColors;
        DEFAULT_PATTERNS.clear();
        for (ResourceLocation shellTheme : ShellTheme.SHELL_THEME_DEFERRED_REGISTRY.keySet()) {
            if (shellTheme == ShellTheme.SHULKER.getId()) continue;
            boolean hasDefaultEmission = shellTheme == ShellTheme.MYSTIC.getId() || shellTheme == ShellTheme.NUKA.getId() || shellTheme == ShellTheme.PAGODA.getId() || shellTheme == ShellTheme.PHONE_BOOTH.getId() || shellTheme == ShellTheme.POLICE_BOX.getId() || shellTheme == ShellTheme.VENDING.getId();
            String textureName = shellTheme.m_135815_();
            ShellSoundProfile soundProfile = TRShellSoundProfiles.defaultSoundProfilesByTheme().getOrDefault(shellTheme, TRShellSoundProfiles.DEFAULT_SOUND_PROFILE);
            ShellPattern pattern = new ShellPattern(ResourceConstants.DEFAULT_PATTERN_ID, new PatternTexture(ShellPatterns.exteriorTextureLocation(shellTheme, textureName), hasDefaultEmission), new PatternTexture(ShellPatterns.interiorTextureLocation(shellTheme, textureName), hasDefaultEmission), Optional.of(soundProfile));
            ShellPatterns.addDefaultPattern(shellTheme, pattern);
        }
        ShellPatterns.addDefaultPattern(ShellTheme.POLICE_BOX.getId(), "faded", true);
        ShellPatterns.addDefaultPattern(ShellTheme.POLICE_BOX.getId(), "fourteen", true);
        ShellPatterns.addDefaultPattern(ShellTheme.POLICE_BOX.getId(), "barbie", true);
        ShellPatterns.addDefaultPattern(ShellTheme.PHONE_BOOTH.getId(), "metal", false);
        ShellPatterns.addDefaultPattern(ShellTheme.PRESENT.getId(), "cardboard", false);
        ShellPatterns.addDefaultPattern(ShellTheme.BRIEFCASE.getId(), "intel", false);
        ShellPatterns.addDefaultPattern(ShellTheme.BRIEFCASE.getId(), "metal", false);
        ShellPatterns.addDefaultPattern(ShellTheme.BRIEFCASE.getId(), "mesa", false);
        ShellPatterns.addDefaultPattern(ShellTheme.MYSTIC.getId(), "dwarven", false);
        ShellPatterns.addDefaultPattern(ShellTheme.BIG_BEN.getId(), "gothic", true);
        ShellSoundProfile soundProfile = new ShellSoundProfile();
        soundProfile.setDoorOpen(new ConfiguredSound(SoundEvents.f_12409_));
        soundProfile.setDoorClose(new ConfiguredSound(SoundEvents.f_12408_));
        for (String color : shulkerColors = new String[]{"black", "blue", "brown", "cyan", "gray", "green", "light_blue", "light_gray", "lime", "magenta", "orange", "pink", "purple", "red", "white", "yellow"}) {
            ShellPatterns.addDefaultPattern(ShellTheme.SHULKER.getId(), color, false, Optional.of(soundProfile));
        }
        ShellPatterns.addDefaultPattern(ShellTheme.SHULKER.getId(), "shulker", false, Optional.of(soundProfile));
        return new HashMap<ResourceLocation, List<ShellPattern>>(DEFAULT_PATTERNS);
    }
}

