/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.registry;

import com.mojang.datafixers.util.Either;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.Nullable;

public class RegistrySupplierHolder<R, T extends R>
implements Holder<R>,
Supplier<T> {
    protected final ResourceKey<R> key;
    @Nullable
    private Holder<R> holder = null;

    protected RegistrySupplierHolder(ResourceKey<R> key) {
        this.key = Objects.requireNonNull(key);
        this.bind(false);
    }

    public static <R, T extends R> RegistrySupplierHolder<R, T> create(ResourceKey<? extends Registry<R>> registryKey, ResourceLocation valueName) {
        return RegistrySupplierHolder.create(ResourceKey.m_135785_(registryKey, (ResourceLocation)valueName));
    }

    public static <R, T extends R> RegistrySupplierHolder<R, T> create(ResourceLocation registryName, ResourceLocation valueName) {
        return RegistrySupplierHolder.create(ResourceKey.m_135788_((ResourceLocation)registryName), valueName);
    }

    public static <R, T extends R> RegistrySupplierHolder<R, T> create(ResourceKey<R> key) {
        return new RegistrySupplierHolder<R, T>(key);
    }

    @Nullable
    protected Registry<R> getRegistry() {
        return (Registry)BuiltInRegistries.f_257047_.m_7745_(this.key.m_211136_());
    }

    protected final void bind(boolean throwOnMissingRegistry) {
        if (this.holder != null) {
            return;
        }
        Registry<R> registry = this.getRegistry();
        if (registry != null) {
            this.holder = registry.m_203636_(this.key).orElse(null);
        } else if (throwOnMissingRegistry) {
            throw new IllegalStateException("Registry not present for " + this + ": " + this.key.m_211136_());
        }
    }

    public ResourceLocation getId() {
        return this.key.m_135782_();
    }

    public ResourceKey<R> getKey() {
        return this.key;
    }

    public T m_203334_() {
        this.bind(true);
        if (this.holder == null) {
            throw new NullPointerException("Trying to access unbound value: " + this.key);
        }
        return (T)this.holder.m_203334_();
    }

    public boolean m_203633_() {
        this.bind(false);
        return this.holder != null && this.holder.m_203633_();
    }

    public boolean m_203373_(ResourceLocation id) {
        return id.equals((Object)this.key.m_135782_());
    }

    public boolean m_203565_(ResourceKey<R> key) {
        return key == this.key;
    }

    public boolean m_203425_(Predicate<ResourceKey<R>> filter) {
        return filter.test(this.key);
    }

    public boolean m_203656_(TagKey<R> tag) {
        this.bind(false);
        return this.holder != null && this.holder.m_203656_(tag);
    }

    public Stream<TagKey<R>> m_203616_() {
        this.bind(false);
        return this.holder != null ? this.holder.m_203616_() : Stream.empty();
    }

    public Either<ResourceKey<R>, R> m_203439_() {
        return Either.left(this.key);
    }

    public Optional<ResourceKey<R>> m_203543_() {
        return Optional.of(this.key);
    }

    public Holder.Kind m_203376_() {
        return Holder.Kind.REFERENCE;
    }

    public boolean m_203401_(HolderOwner<R> owner) {
        this.bind(false);
        return this.holder != null && this.holder.m_203401_(owner);
    }

    @Override
    public T get() {
        return this.m_203334_();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RegistrySupplierHolder)) return false;
        RegistrySupplierHolder rh = (RegistrySupplierHolder)obj;
        if (rh.key != this.key) return false;
        return true;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return String.format(Locale.ENGLISH, "RegistrySupplierHolder{%s}", this.key);
    }
}

